<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:21:35+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "fa"
}
-->
# پروژه خود را با Co-op Translator ترجمه کنید

**Co-op Translator** یک ابزار خط فرمان (CLI) است که به شما کمک می‌کند فایل‌های markdown و تصاویر پروژه‌تان را به چندین زبان ترجمه کنید. در این بخش، نحوه استفاده از ابزار، گزینه‌های مختلف CLI و مثال‌هایی برای کاربردهای گوناگون توضیح داده شده است.

---

## سناریوها و دستورات نمونه

در اینجا چند کاربرد رایج **Co-op Translator** و دستورات مناسب برای هر مورد آورده شده است.

### ۱. ترجمه پایه (یک زبان)

برای ترجمه کل پروژه (فایل‌های markdown و تصاویر) به یک زبان، مثلاً کره‌ای، از دستور زیر استفاده کنید:

```bash
translate -l "ko"
```

این دستور همه فایل‌های markdown و تصاویر را به کره‌ای ترجمه می‌کند و ترجمه‌های جدید را اضافه می‌کند بدون اینکه ترجمه‌های قبلی حذف شوند.

#### مثال در Phi-3 CookBook

در **Phi-3 CookBook**، من از روش زیر برای افزودن ترجمه کره‌ای به فایل‌های markdown و تصاویر موجود استفاده کردم.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### ۲. ترجمه به چند زبان

برای ترجمه پروژه به چند زبان (مثلاً اسپانیایی، فرانسوی و آلمانی)، از این دستور استفاده کنید:

```bash
translate -l "es fr de"
```

این دستور پروژه را به اسپانیایی، فرانسوی و آلمانی ترجمه می‌کند و ترجمه‌های جدید را اضافه می‌کند بدون اینکه ترجمه‌های قبلی را بازنویسی کند.

#### مثال در Phi-3 CookBook

در **Phi-3 CookBook**، پس از دریافت آخرین تغییرات برای هماهنگی با جدیدترین commitها، از روش زیر برای ترجمه فایل‌های markdown و تصاویر جدید استفاده کردم.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

### ۳. به‌روزرسانی ترجمه‌ها (حذف ترجمه‌های قبلی)

برای به‌روزرسانی ترجمه‌های موجود (یعنی حذف ترجمه‌های فعلی و جایگزینی با ترجمه‌های جدید)، از گزینه `-u` استفاده کنید. این کار همه ترجمه‌های موجود برای زبان‌های مشخص‌شده را حذف و دوباره ترجمه می‌کند.

```bash
translate -l "ko" -u
```

هشدار: این دستور قبل از حذف ترجمه‌های قبلی از شما تأیید می‌خواهد.

#### مثال در Phi-3 CookBook

در **Phi-3 CookBook**، من از روش زیر برای به‌روزرسانی همه فایل‌های ترجمه‌شده به اسپانیایی استفاده کردم. توصیه می‌کنم زمانی که تغییرات زیادی در محتوای اصلی چندین سند markdown وجود دارد، از این روش استفاده کنید. اگر فقط چند فایل ترجمه‌شده نیاز به به‌روزرسانی دارند، بهتر است آن فایل‌ها را به صورت دستی حذف کنید و سپس با روش `-a` ترجمه‌های جدید را اضافه کنید.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### ۵. ترجمه فقط تصاویر

برای ترجمه فقط فایل‌های تصویری پروژه، از گزینه `-img` استفاده کنید:

```bash
translate -l "ko" -img
```

این دستور فقط تصاویر را به کره‌ای ترجمه می‌کند و فایل‌های markdown را تغییر نمی‌دهد.

### ۶. ترجمه فقط فایل‌های Markdown

برای ترجمه فقط فایل‌های markdown پروژه، از گزینه `-md` استفاده کنید:

```bash
translate -l "ko" -md
```

#### مثال در Phi-3 CookBook

در **Phi-3 CookBook**، من از روش زیر برای بررسی خطاهای ترجمه در فایل‌های کره‌ای و تلاش مجدد خودکار برای ترجمه فایل‌هایی که مشکل داشتند استفاده کردم.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

این گزینه خطاهای ترجمه را بررسی می‌کند. در حال حاضر، اگر تفاوت تعداد خطوط بین فایل اصلی و ترجمه‌شده بیش از شش باشد، فایل به عنوان دارای خطای ترجمه علامت‌گذاری می‌شود. قصد دارم این معیار را در آینده انعطاف‌پذیرتر کنم.

برای مثال، این روش برای شناسایی بخش‌های ناقص یا ترجمه‌های خراب مفید است و ترجمه آن فایل‌ها را به صورت خودکار دوباره انجام می‌دهد.

با این حال، اگر از قبل می‌دانید کدام فایل‌ها مشکل دارند، بهتر است آن‌ها را به صورت دستی حذف کنید و با گزینه `-a` دوباره ترجمه کنید.

### ۸. حالت Debug

برای فعال کردن گزارش‌گیری دقیق جهت رفع اشکال، از گزینه `-d` استفاده کنید:

```bash
translate -l "ko" -d
```

این دستور ترجمه را در حالت debug اجرا می‌کند و اطلاعات بیشتری برای شناسایی مشکلات در فرآیند ترجمه ارائه می‌دهد.

#### مثال در Phi-3 CookBook

در **Phi-3 CookBook**، با مشکلی مواجه شدم که ترجمه‌هایی با لینک‌های زیاد در فایل‌های markdown باعث خطاهای قالب‌بندی، مانند ترجمه‌های ناقص و نادیده گرفتن شکست خطوط می‌شد. برای بررسی این مشکل، از گزینه `-d` استفاده کردم تا ببینم فرآیند ترجمه چگونه انجام می‌شود.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### ۹. ترجمه به همه زبان‌ها

اگر می‌خواهید پروژه را به همه زبان‌های پشتیبانی‌شده ترجمه کنید، از کلیدواژه all استفاده کنید.

```bash
translate -l "all"
```

این دستور پروژه را به همه زبان‌های موجود ترجمه می‌کند. اگر ادامه دهید، ترجمه بسته به اندازه پروژه ممکن است زمان زیادی ببرد.

>
> ### حذف دستی فایل‌های ترجمه‌شده (اختیاری)
> فایل‌های ترجمه‌شده اکنون به صورت خودکار شناسایی و هنگام به‌روزرسانی فایل منبع پاک‌سازی می‌شوند.
>
> با این حال، اگر بخواهید ترجمه‌ای را به صورت دستی به‌روزرسانی کنید - مثلاً برای ترجمه مجدد یک فایل خاص یا نادیده گرفتن رفتار سیستم - می‌توانید با دستور زیر همه نسخه‌های فایل را در پوشه‌های زبان حذف کنید.
>
> ### در ویندوز:
> ۱. **با Command Prompt**:
>    - Command Prompt را باز کنید.
>    - با دستور `cd` به پوشه مورد نظر بروید.
>    - با دستور زیر فایل‌ها را حذف کنید:
>      ```
>      del /s *filename*
>      ```
>      به جای `filename` نام مورد نظر فایل را قرار دهید. گزینه `/s` برای جستجو در زیرپوشه‌ها است.
>
> ۲. **با PowerShell**:
>    - PowerShell را باز کنید.
>    - این دستور را اجرا کنید:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      به جای `"C:\YourPath"` مسیر پوشه و به جای `filename` نام مورد نظر را قرار دهید.
>
> ### در macOS/Linux:
> ۱. **با Terminal**:
>   - Terminal را باز کنید.
>   - با `cd` به پوشه مورد نظر بروید.
>   - از دستور `find` استفاده کنید:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     به جای `filename` نام مورد نظر را قرار دهید.
>
> همیشه قبل از حذف فایل‌ها، آن‌ها را دوباره بررسی کنید تا از حذف اشتباهی جلوگیری شود.
>
> پس از حذف فایل‌هایی که باید جایگزین شوند، کافی است دوباره دستور `translate -l` را اجرا کنید تا آخرین تغییرات فایل‌ها به‌روزرسانی شود.

---

**سلب مسئولیت**:
این سند با استفاده از سرویس ترجمه هوش مصنوعی [Co-op Translator](https://github.com/Azure/co-op-translator) ترجمه شده است. اگرچه ما برای دقت تلاش می‌کنیم، لطفاً توجه داشته باشید که ترجمه‌های خودکار ممکن است شامل خطا یا نادقتی باشند. نسخه اصلی سند به زبان مادری آن باید به عنوان منبع معتبر در نظر گرفته شود. برای اطلاعات حساس، ترجمه انسانی حرفه‌ای توصیه می‌شود. ما هیچ مسئولیتی در قبال سوء تفاهم یا تفسیر نادرست ناشی از استفاده از این ترجمه نداریم.