<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T02:21:26+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "fa"
}
-->
# نصب بسته Co-op Translator

**Co-op Translator** یک ابزار خط فرمان (CLI) است که برای کمک به ترجمه تمام فایل‌های مارک‌داون و تصاویر پروژه شما به چندین زبان طراحی شده است. این آموزش شما را در پیکربندی مترجم و اجرای آن برای موارد استفاده مختلف راهنمایی می‌کند.

### ساخت محیط مجازی

می‌توانید با استفاده از `pip` یا `Poetry` یک محیط مجازی بسازید. یکی از دستورات زیر را در ترمینال خود وارد کنید.

#### با استفاده از pip

```bash
python -m venv .venv
```

#### با استفاده از Poetry

```bash
poetry init
```

### فعال‌سازی محیط مجازی

پس از ساخت محیط مجازی، باید آن را فعال کنید. مراحل فعال‌سازی بسته به سیستم عامل شما متفاوت است. دستور زیر را در ترمینال خود وارد کنید.

#### برای هر دو pip و Poetry

- ویندوز:

    ```bash
    .venv\Scripts\activate
    ```

- مک/لینوکس:

    ```bash
    source .venv/bin/activate
    ```

#### با استفاده از Poetry

1. اگر محیط را با Poetry ساخته‌اید، دستور زیر را در ترمینال خود وارد کنید تا آن را فعال کنید.

    ```bash
    poetry shell
    ```

### نصب بسته و بسته‌های مورد نیاز

پس از راه‌اندازی و فعال‌سازی محیط مجازی، گام بعدی نصب وابستگی‌های لازم است.

### نصب سریع

نصب Co-Op Translator از طریق pip

```
pip install co-op-translator
```
یا

نصب از طریق poetry
```
poetry add co-op-translator
```

#### با استفاده از pip (از requirements.txt) اگر این مخزن را کلون کرده‌اید

> [!NOTE]
> لطفاً اگر co-op translator را از طریق نصب سریع نصب کرده‌اید، این کار را انجام ندهید.

1. اگر از pip استفاده می‌کنید، دستور زیر را در ترمینال خود وارد کنید. این دستور به طور خودکار بسته‌های مورد نیاز را که در فایل `requirements.txt` مشخص شده‌اند نصب می‌کند:

    ```bash
    pip install -r requirements.txt
    ```

#### با استفاده از Poetry (از pyproject.toml)

1. اگر از Poetry استفاده می‌کنید، دستور زیر را در ترمینال خود وارد کنید. این دستور به طور خودکار بسته‌های مورد نیاز را که در فایل `pyproject.toml` مشخص شده‌اند نصب می‌کند:

    ```bash
    poetry install
    ```

---

**سلب مسئولیت**:
این سند با استفاده از سرویس ترجمه هوش مصنوعی [Co-op Translator](https://github.com/Azure/co-op-translator) ترجمه شده است. اگرچه ما برای دقت تلاش می‌کنیم، لطفاً توجه داشته باشید که ترجمه‌های خودکار ممکن است شامل خطا یا نادقتی باشند. نسخه اصلی سند به زبان مادری آن باید به عنوان منبع معتبر در نظر گرفته شود. برای اطلاعات حساس، ترجمه انسانی حرفه‌ای توصیه می‌شود. ما هیچ مسئولیتی در قبال سوءتفاهم یا تفسیر نادرست ناشی از استفاده از این ترجمه نداریم.