<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T09:59:40+00:00",
  "source_file": "README.md",
  "language_code": "fa"
}
-->
# مترجم تعاونی

_به‌راحتی ترجمه محتوای آموزشی گیت‌هاب خود را به چندین زبان به‌صورت خودکار انجام دهید تا به مخاطبان جهانی دسترسی پیدا کنید._

[![بسته پایتون](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![مجوز: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![تعداد دانلودها](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![تعداد دانلودها](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![کانتینر: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![سبک کد: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![مشارکت‌کنندگان گیت‌هاب](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![مسائل گیت‌هاب](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![درخواست‌های pull گیت‌هاب](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![خوش آمدید به PRها](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 پشتیبانی چندزبانه

#### پشتیبانی شده توسط [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[عربی](../ar/README.md) | [بنگالی](../bn/README.md) | [بلغاری](../bg/README.md) | [برمه‌ای (میانمار)](../my/README.md) | [چینی (ساده‌شده)](../zh/README.md) | [چینی (سنتی، هنگ‌کنگ)](../hk/README.md) | [چینی (سنتی، ماکائو)](../mo/README.md) | [چینی (سنتی، تایوان)](../tw/README.md) | [کرواتی](../hr/README.md) | [چکی](../cs/README.md) | [دانمارکی](../da/README.md) | [هلندی](../nl/README.md) | [استونیایی](../et/README.md) | [فنلاندی](../fi/README.md) | [فرانسوی](../fr/README.md) | [آلمانی](../de/README.md) | [یونانی](../el/README.md) | [عبری](../he/README.md) | [هندی](../hi/README.md) | [مجارستانی](../hu/README.md) | [اندونزیایی](../id/README.md) | [ایتالیایی](../it/README.md) | [ژاپنی](../ja/README.md) | [کانادا](../kn/README.md) | [کره‌ای](../ko/README.md) | [لیتوانیایی](../lt/README.md) | [مالایی](../ms/README.md) | [مالایالام](../ml/README.md) | [مراتی](../mr/README.md) | [نپالی](../ne/README.md) | [پیدج نیجریه‌ای](../pcm/README.md) | [نروژی](../no/README.md) | [فارسی](./README.md) | [لهستانی](../pl/README.md) | [پرتغالی (برزیل)](../br/README.md) | [پرتغالی (پرتغال)](../pt/README.md) | [پنجابی (گورمخی)](../pa/README.md) | [رومانیایی](../ro/README.md) | [روسی](../ru/README.md) | [صربی (سیریلیک)](../sr/README.md) | [اسلواکی](../sk/README.md) | [اسلوونیایی](../sl/README.md) | [اسپانیایی](../es/README.md) | [سواحیلی](../sw/README.md) | [سوئدی](../sv/README.md) | [تاگالوگ (فیلیپینی)](../tl/README.md) | [تامیل](../ta/README.md) | [تلوگو](../te/README.md) | [تایلندی](../th/README.md) | [ترکی](../tr/README.md) | [اوکراینی](../uk/README.md) | [اردو](../ur/README.md) | [ویتنامی](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![ناظرین گیت‌هاب](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![شاخه‌های گیت‌هاب](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![ستاره‌های گیت‌هاب](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![دیسکورد Microsoft Foundry](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![باز کردن در GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## مرور کلی

**مترجم تعاونی** به شما کمک می‌کند محتوای آموزشی گیت‌هاب خود را به چند زبان به‌راحتی بومی‌سازی کنید.
وقتی فایل‌های Markdown، تصاویر یا نوت‌بوک‌های خود را به‌روزرسانی می‌کنید، ترجمه‌ها به‌صورت خودکار همگام‌سازی می‌شوند تا محتوای شما برای یادگیرندگان در سراسر جهان دقیق و به‌روز باقی بماند.

نمونه‌ای از نحوه سازماندهی محتوای ترجمه شده:

![نمونه](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.fa.png)

## شروع سریع

```bash
# ایجاد و فعال‌سازی یک محیط مجازی (توصیه شده)
python -m venv .venv
# ویندوز
.venv\Scripts\activate
# مک‌اواس/لینوکس
source .venv/bin/activate
# نصب بسته
pip install co-op-translator
# ترجمه کردن
translate -l "ko ja fr" -md
```

داکر:

```bash
# تصویر عمومی را از GHCR بکشید
docker pull ghcr.io/azure/co-op-translator:latest
# با پوشه فعلی نصب شده و فایل .env ارائه شده اجرا کنید (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## راه‌اندازی حداقلی

1. یک فایل `.env` با استفاده از قالب: [.env.template](../../.env.template) بسازید
2. یک ارائه‌دهنده LLM را پیکربندی کنید (Azure OpenAI یا OpenAI)
3. (اختیاری) برای ترجمه تصویر (`-img`)، Azure AI Vision را تنظیم کنید
4. (توصیه شده) ترجمه‌های قبلی را پاک کنید تا از تداخل جلوگیری شود (مثلاً پوشه `translations/`)
5. (توصیه شده) یک بخش ترجمه به README خود اضافه کنید با استفاده از [قالب زبان‌های README](./getting_started/README_languages_template.md)
6. مراجعه کنید به: [راه‌اندازی Azure AI](./getting_started/set-up-azure-ai.md)

## نحوه استفاده

ترجمه همه انواع پشتیبانی شده:

```bash
translate -l "ko ja"
```

فقط Markdown:

```bash
translate -l "de" -md
```

Markdown + تصاویر:

```bash
translate -l "pt" -md -img
```

فقط نوت‌بوک‌ها:

```bash
translate -l "zh" -nb
```

پرچم‌های بیشتر: [مرجع دستورات](./getting_started/command-reference.md)

## ویژگی‌ها

- ترجمه خودکار برای Markdown، نوت‌بوک‌ها و تصاویر
- همگام‌سازی ترجمه‌ها با تغییرات منبع
- اجرا به‌صورت محلی (CLI) یا در CI (GitHub Actions)
- استفاده از Azure OpenAI یا OpenAI؛ Azure AI Vision اختیاری برای تصاویر
- حفظ قالب‌بندی و ساختار Markdown

## مستندات

- [راهنمای خط فرمان](./getting_started/command-line-guide/command-line-guide.md)
- [راهنمای GitHub Actions (مخازن عمومی و اسرار استاندارد)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [راهنمای GitHub Actions (مخازن سازمانی مایکروسافت و تنظیمات سطح سازمان)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [قالب زبان‌های README](./getting_started/README_languages_template.md)
- [زبان‌های پشتیبانی شده](./getting_started/supported-languages.md)
- [مشارکت](./CONTRIBUTING.md)
- [عیب‌یابی](./getting_started/troubleshooting.md)

### راهنمای مخصوص مایکروسافت
> [!NOTE]
> فقط برای نگهدارندگان مخازن «برای مبتدیان» مایکروسافت.

- [به‌روزرسانی فهرست «دوره‌های دیگر» (فقط برای مخازن MS Beginners)](./getting_started/update-other-courses.md)

## از ما حمایت کنید و یادگیری جهانی را تقویت کنید

با ما همراه شوید تا نحوه اشتراک‌گذاری محتوای آموزشی در سطح جهان را متحول کنیم! به [Co-op Translator](https://github.com/azure/co-op-translator) در گیت‌هاب ستاره دهید و از مأموریت ما برای از بین بردن موانع زبانی در یادگیری و فناوری حمایت کنید. علاقه و مشارکت شما تأثیر بزرگی دارد! مشارکت در کد و پیشنهاد ویژگی‌ها همیشه خوش‌آمد است.

### محتوای آموزشی مایکروسافت را به زبان خود کاوش کنید

- [AZD برای مبتدیان](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI برای مبتدیان](https://github.com/microsoft/edgeai-for-beginners)
- [پروتکل زمینه مدل (MCP) برای مبتدیان](https://github.com/microsoft/mcp-for-beginners)
- [عامل‌های هوش مصنوعی برای مبتدیان](https://github.com/microsoft/ai-agents-for-beginners)
- [هوش مصنوعی مولد برای مبتدیان با استفاده از .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [هوش مصنوعی مولد برای مبتدیان](https://github.com/microsoft/generative-ai-for-beginners)
- [هوش مصنوعی مولد برای مبتدیان با استفاده از Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [یادگیری ماشین برای مبتدیان](https://aka.ms/ml-beginners)
- [علم داده برای مبتدیان](https://aka.ms/datascience-beginners)
- [هوش مصنوعی برای مبتدیان](https://aka.ms/ai-beginners)
- [امنیت سایبری برای مبتدیان](https://github.com/microsoft/Security-101)
- [توسعه وب برای مبتدیان](https://aka.ms/webdev-beginners)
- [اینترنت اشیاء برای مبتدیان](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## ارائه‌های ویدیویی

👉 برای تماشا در یوتیوب روی تصویر زیر کلیک کنید.

- **Open at Microsoft**: معرفی کوتاه ۱۸ دقیقه‌ای و راهنمای سریع استفاده از مترجم تعاونی.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.fa.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## مشارکت

این پروژه از مشارکت‌ها و پیشنهادات استقبال می‌کند. علاقه‌مند به همکاری در Azure Co-op Translator هستید؟ لطفاً راهنمای ما را در [CONTRIBUTING.md](./CONTRIBUTING.md) ببینید تا بدانید چگونه می‌توانید به دسترسی‌پذیرتر شدن مترجم تعاونی کمک کنید.

## مشارکت‌کنندگان

[![مشارکت‌کنندگان co-op-translator](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## منشور رفتاری

این پروژه منشور رفتاری [مایکروسافت منبع باز](https://opensource.microsoft.com/codeofconduct/) را پذیرفته است.
برای اطلاعات بیشتر به [سؤالات متداول منشور رفتاری](https://opensource.microsoft.com/codeofconduct/faq/) مراجعه کنید یا
با [opencode@microsoft.com](mailto:opencode@microsoft.com) برای هر سؤال یا نظر اضافی تماس بگیرید.

## هوش مصنوعی مسئولانه

مایکروسافت متعهد است به مشتریان خود کمک کند تا محصولات هوش مصنوعی ما را به‌صورت مسئولانه استفاده کنند، تجربیات خود را به اشتراک بگذارد و از طریق ابزارهایی مانند یادداشت‌های شفافیت و ارزیابی‌های تأثیر، شراکت‌های مبتنی بر اعتماد بسازد. بسیاری از این منابع را می‌توانید در [https://aka.ms/RAI](https://aka.ms/RAI) بیابید.
رویکرد مایکروسافت به هوش مصنوعی مسئولانه بر اصول هوش مصنوعی ما مبتنی است: عدالت، قابلیت اطمینان و ایمنی، حریم خصوصی و امنیت، فراگیری، شفافیت و پاسخگویی.

مدل‌های بزرگ زبان طبیعی، تصویر و گفتار - مانند آن‌هایی که در این نمونه استفاده شده‌اند - ممکن است رفتارهایی ناعادلانه، غیرقابل اعتماد یا توهین‌آمیز داشته باشند که می‌تواند آسیب‌زا باشد. لطفاً برای آگاهی از ریسک‌ها و محدودیت‌ها به [یادداشت شفافیت سرویس Azure OpenAI](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) مراجعه کنید.
روش پیشنهادی برای کاهش این ریسک‌ها، افزودن یک سیستم ایمنی در معماری شما است که بتواند رفتارهای مضر را شناسایی و جلوگیری کند. <a href="https://learn.microsoft.com/azure/ai-services/content-safety/overview">Azure AI Content Safety</a> یک لایه محافظتی مستقل فراهم می‌کند که قادر است محتوای مضر تولید شده توسط کاربران و هوش مصنوعی را در برنامه‌ها و خدمات تشخیص دهد. Azure AI Content Safety شامل APIهای متنی و تصویری است که به شما امکان می‌دهد محتوای مضر را شناسایی کنید. همچنین یک استودیوی تعاملی Content Safety داریم که به شما اجازه می‌دهد نمونه کدهای تشخیص محتوای مضر در حالت‌های مختلف را مشاهده، بررسی و آزمایش کنید. مستندات <a href="https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest">شروع سریع</a> زیر، شما را در ارسال درخواست به این سرویس راهنمایی می‌کند.

یکی دیگر از جنبه‌های مهم، عملکرد کلی برنامه است. در برنامه‌های چندرسانه‌ای و چندمدلی، عملکرد به معنای این است که سیستم همانطور که شما و کاربران انتظار دارید عمل کند، از جمله عدم تولید خروجی‌های مضر. ارزیابی عملکرد کلی برنامه با استفاده از <a href="https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in">معیارهای کیفیت تولید و ریسک و ایمنی</a> اهمیت زیادی دارد.

شما می‌توانید برنامه هوش مصنوعی خود را در محیط توسعه با استفاده از <a href="https://microsoft.github.io/promptflow/index.html">prompt flow SDK</a> ارزیابی کنید. با داشتن یک مجموعه داده آزمایشی یا هدف مشخص، تولیدات برنامه هوش مصنوعی شما به صورت کمی با ارزیاب‌های داخلی یا ارزیاب‌های سفارشی انتخابی شما اندازه‌گیری می‌شود. برای شروع کار با prompt flow sdk جهت ارزیابی سیستم خود، می‌توانید راهنمای <a href="https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk">شروع سریع</a> را دنبال کنید. پس از اجرای ارزیابی، می‌توانید <a href="https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results">نتایج را در Azure AI Studio مشاهده کنید</a>.

## علائم تجاری

این پروژه ممکن است شامل علائم تجاری یا لوگوهایی برای پروژه‌ها، محصولات یا خدمات باشد. استفاده مجاز از علائم تجاری یا لوگوهای مایکروسافت مشروط به رعایت <a href="https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general">راهنمای علائم تجاری و برند مایکروسافت</a> است. استفاده از علائم تجاری یا لوگوهای مایکروسافت در نسخه‌های تغییر یافته این پروژه نباید باعث سردرگمی شود یا دلالت بر حمایت مایکروسافت داشته باشد. هرگونه استفاده از علائم تجاری یا لوگوهای شخص ثالث تابع سیاست‌های آن‌ها است.

## دریافت کمک

اگر در ساخت برنامه‌های هوش مصنوعی به مشکل برخوردید یا سوالی داشتید، به اینجا بپیوندید:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

اگر بازخورد محصول یا خطایی هنگام ساخت داشتید، به اینجا مراجعه کنید:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**سلب مسئولیت**:  
این سند با استفاده از سرویس ترجمه هوش مصنوعی [Co-op Translator](https://github.com/Azure/co-op-translator) ترجمه شده است. در حالی که ما در تلاش برای دقت هستیم، لطفاً توجه داشته باشید که ترجمه‌های خودکار ممکن است حاوی خطاها یا نادرستی‌هایی باشند. سند اصلی به زبان بومی خود باید به عنوان منبع معتبر در نظر گرفته شود. برای اطلاعات حیاتی، ترجمه حرفه‌ای انسانی توصیه می‌شود. ما مسئول هیچ گونه سوءتفاهم یا تفسیر نادرستی که از استفاده این ترجمه ناشی شود، نیستیم.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->