<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T09:58:46+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "fa"
}
-->
# مشارکت در Co-op Translator

این پروژه از مشارکت‌ها و پیشنهادات استقبال می‌کند. بیشتر مشارکت‌ها نیازمند آن است که شما با یک توافقنامه مجوز مشارکت‌کننده (CLA) موافقت کنید که اعلام می‌کند شما حق دارید و واقعاً به ما اجازه می‌دهید از مشارکت شما استفاده کنیم. برای جزئیات بیشتر به https://cla.opensource.microsoft.com مراجعه کنید.

وقتی یک pull request ارسال می‌کنید، یک ربات CLA به‌طور خودکار تعیین می‌کند که آیا نیاز به ارائه CLA دارید و PR را به‌طور مناسب علامت‌گذاری می‌کند (مثلاً بررسی وضعیت، نظر). کافی است دستورالعمل‌های ارائه شده توسط ربات را دنبال کنید. شما فقط یک بار در تمام مخازنی که از CLA ما استفاده می‌کنند، این کار را انجام خواهید داد.

## راه‌اندازی محیط توسعه

برای راه‌اندازی محیط توسعه این پروژه، توصیه می‌کنیم از Poetry برای مدیریت وابستگی‌ها استفاده کنید. ما از `pyproject.toml` برای مدیریت وابستگی‌های پروژه استفاده می‌کنیم، بنابراین برای نصب وابستگی‌ها باید از Poetry استفاده کنید.

### ایجاد محیط مجازی

#### استفاده از pip

```bash
python -m venv .venv
```

#### استفاده از Poetry

```bash
poetry init
```

### فعال‌سازی محیط مجازی

#### برای هر دو pip و Poetry

- ویندوز:

    ```bash
    .venv\Scripts\activate.bat
    ```

- مک/لینوکس:

    ```bash
    source .venv/bin/activate
    ```

#### استفاده از Poetry

```bash
poetry shell
```

### نصب بسته و بسته‌های مورد نیاز

#### استفاده از Poetry (از pyproject.toml)

```bash
poetry install
```

### تست دستی

قبل از ارسال PR، مهم است که عملکرد ترجمه را با مستندات واقعی تست کنید:

1. یک پوشه تست در دایرکتوری ریشه ایجاد کنید:
    ```bash
    mkdir test_docs
    ```

2. برخی مستندات مارک‌داون و تصاویر مورد نظر برای ترجمه را در پوشه تست کپی کنید. برای مثال:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. بسته را به‌صورت محلی نصب کنید:
    ```bash
    pip install -e .
    ```

4. Co-op Translator را روی اسناد تست خود اجرا کنید:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. فایل‌های ترجمه شده در `test_docs/translations` و `test_docs/translated_images` را بررسی کنید تا مطمئن شوید:
   - کیفیت ترجمه مناسب است
   - نظرات متادیتا صحیح هستند
   - ساختار اصلی مارک‌داون حفظ شده است
   - لینک‌ها و تصاویر به درستی کار می‌کنند

این تست دستی کمک می‌کند تا مطمئن شوید تغییرات شما در شرایط واقعی به خوبی کار می‌کنند.

### متغیرهای محیطی

1. یک فایل `.env` در دایرکتوری ریشه با کپی کردن فایل `.env.template` ایجاد کنید.
2. متغیرهای محیطی را طبق راهنما پر کنید.

> [!TIP]
>
> ### گزینه‌های اضافی برای محیط توسعه
>
> علاوه بر اجرای پروژه به‌صورت محلی، می‌توانید از GitHub Codespaces یا VS Code Dev Containers برای راه‌اندازی محیط توسعه جایگزین استفاده کنید.
>
> #### GitHub Codespaces
>
> می‌توانید این نمونه‌ها را به‌صورت مجازی با استفاده از GitHub Codespaces اجرا کنید و نیازی به تنظیمات اضافی نیست.
>
> دکمه زیر یک نسخه وب VS Code را در مرورگر شما باز می‌کند:
>
> 1. قالب را باز کنید (ممکن است چند دقیقه طول بکشد):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### اجرای محلی با استفاده از VS Code Dev Containers
>
> ⚠️ این گزینه فقط در صورتی کار می‌کند که Docker Desktop شما حداقل ۱۶ گیگابایت رم اختصاص داده باشد. اگر کمتر از ۱۶ گیگابایت رم دارید، می‌توانید گزینه [GitHub Codespaces](../..) را امتحان کنید یا [محلی راه‌اندازی کنید](../..).
>
> گزینه مرتبط VS Code Dev Containers است که پروژه را در VS Code محلی شما با استفاده از [افزونه Dev Containers](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) باز می‌کند:
>
> 1. Docker Desktop را اجرا کنید (اگر نصب نیست، نصب کنید)
> 2. پروژه را باز کنید:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### سبک کد

ما از [Black](https://github.com/psf/black) به‌عنوان فرمت‌کننده کد پایتون استفاده می‌کنیم تا سبک کد در سراسر پروژه یکدست باشد. Black یک فرمت‌کننده کد بدون مصالحه است که به‌طور خودکار کد پایتون را بازفرمت می‌کند تا با سبک کد Black مطابقت داشته باشد.

#### پیکربندی

پیکربندی Black در `pyproject.toml` ما مشخص شده است:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### نصب Black

می‌توانید Black را با استفاده از Poetry (توصیه شده) یا pip نصب کنید:

##### استفاده از Poetry

Black به‌طور خودکار هنگام راه‌اندازی محیط توسعه نصب می‌شود:
```bash
poetry install
```

##### استفاده از pip

اگر از pip استفاده می‌کنید، می‌توانید Black را مستقیماً نصب کنید:
```bash
pip install black
```

#### استفاده از Black

##### با Poetry

1. تمام فایل‌های پایتون پروژه را فرمت کنید:
    ```bash
    poetry run black .
    ```

2. یک فایل یا دایرکتوری خاص را فرمت کنید:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### با pip

1. تمام فایل‌های پایتون پروژه را فرمت کنید:
    ```bash
    black .
    ```

2. یک فایل یا دایرکتوری خاص را فرمت کنید:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> توصیه می‌کنیم ویرایشگر خود را طوری تنظیم کنید که هنگام ذخیره، کد را به‌طور خودکار با Black فرمت کند. بیشتر ویرایشگرهای مدرن این قابلیت را از طریق افزونه‌ها یا پلاگین‌ها پشتیبانی می‌کنند.

## اجرای Co-op Translator

برای اجرای Co-op Translator با استفاده از Poetry در محیط خود، مراحل زیر را دنبال کنید:

1. به دایرکتوری‌ای که می‌خواهید تست‌های ترجمه را انجام دهید بروید یا یک پوشه موقت برای تست ایجاد کنید.

2. دستور زیر را اجرا کنید. `-l ko` را با کد زبان مورد نظر برای ترجمه جایگزین کنید. گزینه `-d` حالت اشکال‌زدایی را فعال می‌کند.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> قبل از اجرای دستور، مطمئن شوید محیط Poetry فعال است (poetry shell).

## افزودن زبان جدید

ما از مشارکت‌هایی که پشتیبانی از زبان‌های جدید را اضافه می‌کنند استقبال می‌کنیم. قبل از باز کردن PR، لطفاً مراحل زیر را برای اطمینان از بررسی روان انجام دهید.

1. زبان را به نگاشت فونت اضافه کنید
   - فایل `src/co_op_translator/fonts/font_language_mappings.yml` را ویرایش کنید
   - یک ورودی با موارد زیر اضافه کنید:
     - `code`: کد زبان شبیه ISO (مثلاً `vi`)
     - `name`: نام قابل فهم برای نمایش
     - `font`: فونتی که در `src/co_op_translator/fonts/` موجود است و از اسکریپت پشتیبانی می‌کند
     - `rtl`: اگر زبان راست به چپ است `true` وگرنه `false`

2. فایل‌های فونت مورد نیاز را اضافه کنید (در صورت نیاز)
   - اگر فونت جدیدی لازم است، سازگاری مجوز برای توزیع متن‌باز را بررسی کنید
   - فایل فونت را به `src/co_op_translator/fonts/` اضافه کنید

3. بررسی محلی
   - ترجمه‌ها را برای نمونه کوچکی (مارک‌داون، تصاویر و نوت‌بوک‌ها در صورت لزوم) اجرا کنید
   - خروجی را بررسی کنید که به درستی رندر شده باشد، شامل فونت‌ها و هر چیدمان RTL در صورت وجود

4. به‌روزرسانی مستندات
   - اطمینان حاصل کنید زبان در `getting_started/supported-languages.md` ظاهر شده است
   - نیازی به تغییر در `getting_started/README_languages_template.md` نیست؛ این فایل از لیست پشتیبانی شده تولید می‌شود

5. باز کردن PR
   - زبان اضافه شده و هر نکته مربوط به فونت/مجوز را شرح دهید
   - در صورت امکان اسکرین‌شات‌های خروجی رندر شده را ضمیمه کنید

نمونه ورودی YAML:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### تست زبان جدید

می‌توانید زبان جدید را با اجرای دستور زیر تست کنید:

```bash
# ایجاد و فعال‌سازی یک محیط مجازی
python -m venv .venv
# ویندوز
.venv\Scripts\activate
# مک‌اواس/لینوکس
source .venv/bin/activate
# نصب بسته توسعه
pip install -e .
# اجرای ترجمه
translate -l "new_lang"
```

## نگهدارندگان

### پیام کامیت و استراتژی ادغام

برای اطمینان از یکنواختی و وضوح در تاریخچه کامیت پروژه، ما از قالب پیام کامیت خاصی **برای پیام کامیت نهایی** هنگام استفاده از استراتژی **Squash and Merge** پیروی می‌کنیم.

وقتی یک pull request (PR) ادغام می‌شود، کامیت‌های جداگانه به یک کامیت واحد فشرده می‌شوند. پیام کامیت نهایی باید قالب زیر را دنبال کند تا تاریخچه تمیز و یکدستی حفظ شود.

#### قالب پیام کامیت (برای squash and merge)

ما از قالب زیر برای پیام‌های کامیت استفاده می‌کنیم:

```bash
<type>: <description> (#<شماره PR>)
```

- **type**: دسته‌بندی کامیت را مشخص می‌کند. ما از انواع زیر استفاده می‌کنیم:
  - `Docs`: برای به‌روزرسانی‌های مستندات.
  - `Build`: برای تغییرات مربوط به سیستم ساخت یا وابستگی‌ها، شامل به‌روزرسانی فایل‌های پیکربندی، گردش‌های کاری CI یا Dockerfile.
  - `Core`: برای تغییرات در عملکرد یا ویژگی‌های اصلی پروژه، به‌ویژه فایل‌های داخل دایرکتوری `src/co_op_translator/core`.

- **description**: خلاصه‌ای کوتاه از تغییر.
- **PR number**: شماره pull request مرتبط با کامیت.

**نمونه‌ها**:

- `Docs: Update installation instructions for clarity (#50)`
- `Core: Improve handling of image translation (#60)`

> [!NOTE]
> در حال حاضر، پیشوندهای **`Docs`**، **`Core`** و **`Build`** به‌طور خودکار بر اساس برچسب‌های اعمال شده روی کد منبع تغییر یافته به عنوان عنوان PR اضافه می‌شوند. تا زمانی که برچسب صحیح اعمال شده باشد، معمولاً نیازی به به‌روزرسانی دستی عنوان PR نیست. فقط کافی است بررسی کنید همه چیز درست است و پیشوند به درستی تولید شده است.

#### استراتژی ادغام

ما به‌طور پیش‌فرض از **Squash and Merge** برای pull requestها استفاده می‌کنیم. این استراتژی تضمین می‌کند که پیام‌های کامیت قالب ما را دنبال کنند، حتی اگر کامیت‌های جداگانه این‌گونه نباشند.

**دلایل**:

- تاریخچه پروژه تمیز و خطی.
- یکنواختی در پیام‌های کامیت.
- کاهش نویز از کامیت‌های کوچک (مثلاً "رفع اشتباه تایپی").

هنگام ادغام، مطمئن شوید پیام کامیت نهایی قالب پیام کامیت شرح داده شده را دنبال می‌کند.

**نمونه Squash and Merge**
اگر PR شامل کامیت‌های زیر باشد:

- `fix typo`
- `update README`
- `adjust formatting`

باید به صورت زیر فشرده شود:
`Docs: Improve documentation clarity and formatting (#65)`

### فرآیند انتشار

این بخش ساده‌ترین روش برای نگهدارندگان را برای انتشار نسخه جدید Co-op Translator شرح می‌دهد.

#### ۱. افزایش نسخه در `pyproject.toml`

1. شماره نسخه بعدی را تعیین کنید (ما از نسخه‌بندی معنایی استفاده می‌کنیم: `MAJOR.MINOR.PATCH`).
2. فایل `pyproject.toml` را ویرایش کرده و فیلد `version` زیر `[tool.poetry]` را به‌روزرسانی کنید.
3. یک pull request اختصاصی باز کنید که فقط نسخه (و هر فایل قفل/متادیتای به‌روزرسانی شده خودکار، در صورت وجود) را تغییر می‌دهد.
4. پس از بازبینی، از **Squash and Merge** استفاده کنید و مطمئن شوید پیام کامیت نهایی قالب بالا را دنبال می‌کند.

#### ۲. ایجاد یک انتشار در GitHub

1. به صفحه مخزن GitHub بروید و **Releases** → **Draft a new release** را باز کنید.
2. یک تگ جدید (مثلاً `v0.13.0`) از شاخه `main` ایجاد کنید.
3. عنوان انتشار را همان نسخه قرار دهید (مثلاً `v0.13.0`).
4. روی **Generate release notes** کلیک کنید تا متن تغییرات به‌طور خودکار پر شود.
5. در صورت تمایل متن را ویرایش کنید (مثلاً برای برجسته کردن زبان‌های جدید پشتیبانی شده یا تغییرات مهم).
6. انتشار را منتشر کنید.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**سلب مسئولیت**:  
این سند با استفاده از سرویس ترجمه هوش مصنوعی [Co-op Translator](https://github.com/Azure/co-op-translator) ترجمه شده است. در حالی که ما در تلاش برای دقت هستیم، لطفاً توجه داشته باشید که ترجمه‌های خودکار ممکن است حاوی خطاها یا نادرستی‌هایی باشند. سند اصلی به زبان بومی خود باید به عنوان منبع معتبر در نظر گرفته شود. برای اطلاعات حیاتی، ترجمه حرفه‌ای انسانی توصیه می‌شود. ما مسئول هیچ گونه سوءتفاهم یا تفسیر نادرستی که از استفاده این ترجمه ناشی شود، نیستیم.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->