<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T03:13:48+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "el"
}
-->
# Οδηγός Επίλυσης Προβλημάτων Microsoft Co-op Translator

## Επισκόπηση
Το Microsoft Co-Op Translator είναι ένα ισχυρό εργαλείο για την αυτόματη μετάφραση εγγράφων Markdown. Αυτός ο οδηγός θα σας βοηθήσει να αντιμετωπίσετε συνηθισμένα προβλήματα που μπορεί να προκύψουν κατά τη χρήση του εργαλείου.

## Συνηθισμένα Προβλήματα και Λύσεις

### 1. Πρόβλημα με το Markdown Tag
**Πρόβλημα:** Το μεταφρασμένο αρχείο Markdown περιλαμβάνει ένα tag `markdown` στην αρχή, προκαλώντας προβλήματα στην εμφάνιση.

**Λύση:** Για να το διορθώσετε, απλώς διαγράψτε το tag `markdown` από την αρχή του αρχείου. Έτσι το αρχείο θα εμφανίζεται σωστά.

**Βήματα:**
1. Ανοίξτε το μεταφρασμένο αρχείο Markdown (`.md`).
2. Εντοπίστε το tag `markdown` στην κορυφή του εγγράφου.
3. Διαγράψτε το tag `markdown`.
4. Αποθηκεύστε τις αλλαγές.
5. Ανοίξτε ξανά το αρχείο για να βεβαιωθείτε ότι εμφανίζεται σωστά.

### 2. Πρόβλημα με τα URLs των Ενσωματωμένων Εικόνων
**Πρόβλημα:** Τα URLs των ενσωματωμένων εικόνων δεν αντιστοιχούν στη γλωσσική τοπικότητα, με αποτέλεσμα να εμφανίζονται λάθος ή να λείπουν εικόνες.

**Λύση:** Ελέγξτε τα URLs των εικόνων και βεβαιωθείτε ότι ταιριάζουν με τη γλώσσα του εγγράφου. Όλες οι εικόνες βρίσκονται στον φάκελο `translated_images` και κάθε εικόνα έχει tag γλώσσας στο όνομα αρχείου.

**Βήματα:**
1. Ανοίξτε το μεταφρασμένο αρχείο Markdown.
2. Εντοπίστε τις ενσωματωμένες εικόνες και τα URLs τους.
3. Ελέγξτε ότι το tag γλώσσας στο όνομα αρχείου της εικόνας ταιριάζει με τη γλώσσα του εγγράφου.
4. Ενημερώστε τα URLs αν χρειάζεται.
5. Αποθηκεύστε τις αλλαγές και ανοίξτε ξανά το αρχείο για να βεβαιωθείτε ότι οι εικόνες εμφανίζονται σωστά.

### 3. Ακρίβεια Μετάφρασης
**Πρόβλημα:** Το μεταφρασμένο περιεχόμενο δεν είναι ακριβές ή χρειάζεται περαιτέρω επεξεργασία.

**Λύση:** Ελέγξτε το μεταφρασμένο έγγραφο και κάντε τις απαραίτητες διορθώσεις για καλύτερη ακρίβεια και αναγνωσιμότητα.

**Βήματα:**
1. Ανοίξτε το μεταφρασμένο έγγραφο.
2. Ελέγξτε προσεκτικά το περιεχόμενο.
3. Κάντε τις απαραίτητες διορθώσεις για βελτίωση της μετάφρασης.
4. Αποθηκεύστε τις αλλαγές.

## 4. Σφάλμα Άδειας Redacted ή 404

Αν οι εικόνες ή το κείμενο δεν μεταφράζονται στη σωστή γλώσσα και όταν τρέχετε σε -d debug mode εμφανίζεται σφάλμα 401, πρόκειται για κλασική αποτυχία ταυτοποίησης—είτε το κλειδί είναι λάθος, έχει λήξει ή δεν είναι συνδεδεμένο στη σωστή περιοχή του endpoint.

Τρέξτε το co-op translator με το [-d debug switch](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md) για να κατανοήσετε καλύτερα την αιτία του προβλήματος.

- **Μήνυμα Σφάλματος**: `Access denied due to invalid subscription key or wrong API endpoint.`
- **Πιθανές Αιτίες**:
  - Το subscription key ήταν redacted ή λάθος στο αίτημα.
  - Το AI Services Key ή Subscription Key μπορεί να ανήκει σε διαφορετικό Azure resource (όπως Translator ή OpenAI) αντί για **Azure AI Vision** resource.

 **Τύπος Πόρου**
  - Μεταβείτε στο [Azure Portal](https://portal.azure.com) ή στο [Azure AI Foundry](https://ai.azure.com) και βεβαιωθείτε ότι ο πόρος είναι τύπου `Azure AI services` → `Vision`.
  - Επαληθεύστε τα κλειδιά και βεβαιωθείτε ότι χρησιμοποιείτε το σωστό κλειδί.

## 5. Σφάλματα Ρυθμίσεων (Νέος Χειρισμός Σφαλμάτων)

Με το νέο σύστημα επιλεκτικής μετάφρασης, το Co-op Translator παρέχει πλέον ξεκάθαρα μηνύματα σφάλματος όταν δεν έχουν ρυθμιστεί οι απαραίτητες υπηρεσίες.

### 5.1. Η Υπηρεσία Azure AI δεν έχει ρυθμιστεί για Μετάφραση Εικόνων

**Πρόβλημα:** Ζητήσατε μετάφραση εικόνων (σημαία `-img`) αλλά η υπηρεσία Azure AI δεν έχει ρυθμιστεί σωστά.

**Μήνυμα Σφάλματος:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**Λύση:**
1. **Επιλογή 1**: Ρυθμίστε την υπηρεσία Azure AI
   - Προσθέστε `AZURE_AI_SERVICE_API_KEY` στο αρχείο `.env`
   - Προσθέστε `AZURE_AI_SERVICE_ENDPOINT` στο αρχείο `.env`
   - Επαληθεύστε ότι η υπηρεσία είναι προσβάσιμη

2. **Επιλογή 2**: Αφαιρέστε το αίτημα για μετάφραση εικόνων
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### 5.2. Λείπει Απαραίτητη Ρύθμιση

**Πρόβλημα:** Λείπει βασική ρύθμιση LLM.

**Μήνυμα Σφάλματος:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**Λύση:**
1. Επαληθεύστε ότι το αρχείο `.env` περιέχει τουλάχιστον μία από τις παρακάτω ρυθμίσεις LLM:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` και `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   Χρειάζεστε είτε Azure OpenAI είτε OpenAI, όχι και τα δύο.

### 5.3. Σύγχυση με Επιλεκτική Μετάφραση

**Πρόβλημα:** Δεν μεταφράστηκαν αρχεία παρόλο που η εντολή ολοκληρώθηκε με επιτυχία.

**Πιθανές Αιτίες:**
- Λάθος flags τύπου αρχείου (`-md`, `-img`, `-nb`)
- Δεν υπάρχουν αντίστοιχα αρχεία στο project
- Λάθος δομή φακέλων

**Λύση:**
1. **Χρησιμοποιήστε debug mode** για να δείτε τι συμβαίνει:
   ```bash
   translate -l "ko" -md -d
   ```

2. **Ελέγξτε τους τύπους αρχείων** στο project σας:
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **Επαληθεύστε τους συνδυασμούς flags**:
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## 6. Μετάβαση από το Παλιό Σύστημα

### 6.1. Κατάργηση του Markdown-Only Mode

**Πρόβλημα:** Εντολές που βασίζονταν στην αυτόματη fallback λειτουργία μόνο για markdown δεν λειτουργούν πλέον όπως πριν.

**Παλιά Συμπεριφορά:**
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

**Νέα Συμπεριφορά:**
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

**Λύση:**
- **Να είστε σαφείς** για το τι θέλετε να μεταφράσετε:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### 6.2. Απρόσμενη Συμπεριφορά Συνδέσμων

**Πρόβλημα:** Οι σύνδεσμοι στα μεταφρασμένα αρχεία οδηγούν σε απρόσμενες τοποθεσίες.

**Αιτία:** Η δυναμική επεξεργασία συνδέσμων αλλάζει ανάλογα με τους επιλεγμένους τύπους αρχείων.

**Λύση:**
1. **Κατανοήστε τη νέα συμπεριφορά συνδέσμων**:
   - Αν περιλαμβάνεται το `-nb`: Οι σύνδεσμοι σε notebooks οδηγούν σε μεταφρασμένες εκδόσεις
   - Αν δεν περιλαμβάνεται το `-nb`: Οι σύνδεσμοι σε notebooks οδηγούν στα αρχικά αρχεία
   - Αν περιλαμβάνεται το `-img`: Οι σύνδεσμοι εικόνων οδηγούν σε μεταφρασμένες εκδόσεις
   - Αν δεν περιλαμβάνεται το `-img`: Οι σύνδεσμοι εικόνων οδηγούν στα αρχικά αρχεία

2. **Επιλέξτε τον σωστό συνδυασμό** για την περίπτωσή σας:
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## 7. Το GitHub Action εκτελέστηκε αλλά δεν δημιουργήθηκε Pull Request (PR)

**Σύμπτωμα:** Τα logs του workflow για `peter-evans/create-pull-request` δείχνουν:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**Πιθανές αιτίες:**
- **Δεν εντοπίστηκαν αλλαγές:** Το βήμα μετάφρασης δεν παρήγαγε διαφορές (το repo είναι ήδη ενημερωμένο).
- **Αγνοημένα outputs:** Το `.gitignore` αποκλείει αρχεία που περιμένετε να γίνουν commit (π.χ. `*.ipynb`, `translations/`, `translated_images/`).
- **Ασυμφωνία add-paths:** Τα paths που δόθηκαν στο action δεν ταιριάζουν με τις πραγματικές τοποθεσίες των outputs.
- **Λογική/συνθήκες workflow:** Το βήμα μετάφρασης τερματίστηκε νωρίς ή έγραψε σε απρόσμενους φακέλους.

**Πώς να το διορθώσετε / ελέγξετε:**
1. **Επιβεβαιώστε ότι υπάρχουν outputs:** Μετά τη μετάφραση, ελέγξτε ότι υπάρχουν νέα/τροποποιημένα αρχεία στους φακέλους `translations/` και/ή `translated_images/`.
   - Αν μεταφράζετε notebooks, βεβαιωθείτε ότι τα αρχεία `.ipynb` γράφονται στον φάκελο `translations/<lang>/...`.
2. **Ελέγξτε το `.gitignore`:** Μην αγνοείτε τα παραγόμενα outputs. Βεβαιωθείτε ότι ΔΕΝ αγνοείτε:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (αν μεταφράζετε notebooks)
3. **Βεβαιωθείτε ότι το add-paths ταιριάζει με τα outputs:** Χρησιμοποιήστε τιμή πολλαπλών γραμμών και συμπεριλάβετε και τους δύο φακέλους αν χρειάζεται:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **Εξαναγκάστε PR για debugging:** Προσωρινά επιτρέψτε empty commits για να επιβεβαιώσετε ότι η σύνδεση λειτουργεί σωστά:
   ```yaml
   with:
     commit-empty: true
   ```
5. **Τρέξτε με debug:** Προσθέστε `-d` στην εντολή translate για να δείτε ποια αρχεία εντοπίστηκαν και γράφτηκαν.
6. **Δικαιώματα (GITHUB_TOKEN):** Βεβαιωθείτε ότι το workflow έχει δικαιώματα εγγραφής για δημιουργία commits και PRs:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```

## Γρήγορη Λίστα Ελέγχου για Εντοπισμό Προβλημάτων

Όταν αντιμετωπίζετε προβλήματα με τη μετάφραση:

1. **Χρησιμοποιήστε debug mode**: Προσθέστε το flag `-d` για αναλυτικά logs
2. **Ελέγξτε τα flags σας**: Βεβαιωθείτε ότι τα `-md`, `-img`, `-nb` αντιστοιχούν σε αυτό που θέλετε
3. **Επαληθεύστε τη ρύθμιση**: Ελέγξτε ότι το αρχείο `.env` έχει τα απαραίτητα κλειδιά
4. **Δοκιμάστε σταδιακά**: Ξεκινήστε μόνο με `-md` και προσθέστε σταδιακά άλλους τύπους
5. **Ελέγξτε τη δομή των αρχείων**: Βεβαιωθείτε ότι τα αρχεία πηγής υπάρχουν και είναι προσβάσιμα

Για περισσότερες λεπτομέρειες σχετικά με διαθέσιμες εντολές και flags, δείτε το [Command Reference](./command-reference.md).

---

**Αποποίηση Ευθύνης**:  
Αυτό το έγγραφο έχει μεταφραστεί χρησιμοποιώντας την υπηρεσία αυτόματης μετάφρασης AI [Co-op Translator](https://github.com/Azure/co-op-translator). Παρότι καταβάλλουμε προσπάθειες για ακρίβεια, παρακαλούμε να γνωρίζετε ότι οι αυτόματες μεταφράσεις ενδέχεται να περιέχουν σφάλματα ή ανακρίβειες. Το πρωτότυπο έγγραφο στη μητρική του γλώσσα πρέπει να θεωρείται η αυθεντική πηγή. Για κρίσιμες πληροφορίες, συνιστάται επαγγελματική ανθρώπινη μετάφραση. Δεν φέρουμε ευθύνη για τυχόν παρανοήσεις ή εσφαλμένες ερμηνείες που προκύπτουν από τη χρήση αυτής της μετάφρασης.