<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T03:14:20+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "el"
}
-->
# Μεταφράστε το έργο σας με το Co-op Translator

Το **Co-op Translator** είναι ένα εργαλείο γραμμής εντολών (CLI) που σας βοηθά να μεταφράσετε αρχεία markdown και εικόνες στο έργο σας σε πολλές γλώσσες. Σε αυτή την ενότητα θα βρείτε οδηγίες χρήσης του εργαλείου, τις διαθέσιμες επιλογές CLI και παραδείγματα για διάφορες περιπτώσεις χρήσης.

> [!NOTE]
> Για πλήρη λίστα εντολών και αναλυτικές περιγραφές, δείτε το [Command reference](./command-reference.md).

---

## Παραδείγματα σεναρίων και εντολών

Ακολουθούν μερικές συνηθισμένες περιπτώσεις χρήσης του **Co-op Translator** μαζί με τις κατάλληλες εντολές.

### 1. Βασική μετάφραση (Μία γλώσσα)

Για να μεταφράσετε ολόκληρο το έργο σας (αρχεία markdown και εικόνες) σε μία γλώσσα, π.χ. Κορεατικά, χρησιμοποιήστε την παρακάτω εντολή:

```bash
translate -l "ko"
```

Αυτή η εντολή θα μεταφράσει όλα τα αρχεία markdown και εικόνων στα Κορεατικά, προσθέτοντας νέες μεταφράσεις χωρίς να διαγράψει τις υπάρχουσες.

> [!TIP]
>
> Θέλετε να δείτε ποιοι κωδικοί γλωσσών είναι διαθέσιμοι στο **Co-op Translator**; Επισκεφθείτε το [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) στο αποθετήριο για περισσότερες λεπτομέρειες.

#### Παράδειγμα στο Phi-3 CookBook

Στο **Phi-3 CookBook**, χρησιμοποίησα την παρακάτω μέθοδο για να προσθέσω την κορεατική μετάφραση στα υπάρχοντα αρχεία markdown και εικόνες.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. Μετάφραση σε πολλές γλώσσες

Για να μεταφράσετε το έργο σας σε πολλές γλώσσες (π.χ. Ισπανικά, Γαλλικά και Γερμανικά), χρησιμοποιήστε αυτή την εντολή:

```bash
translate -l "es fr de"
```

Αυτή η εντολή θα μεταφράσει το έργο στα Ισπανικά, Γαλλικά και Γερμανικά, προσθέτοντας νέες μεταφράσεις χωρίς να αντικαταστήσει τις υπάρχουσες.

#### Παράδειγμα στο Phi-3 CookBook

Στο **Phi-3 CookBook**, αφού έκανα pull τις τελευταίες αλλαγές για να ενημερώσω τα πιο πρόσφατα commits, χρησιμοποίησα την παρακάτω μέθοδο για να μεταφράσω τα νέα αρχεία markdown και εικόνες.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> Αν και συνήθως συνιστάται να μεταφράζετε μία γλώσσα κάθε φορά, σε περιπτώσεις όπως αυτή όπου πρέπει να προστεθούν συγκεκριμένες αλλαγές, η μετάφραση σε πολλές γλώσσες ταυτόχρονα μπορεί να είναι αποδοτική.

### 3. Ενημέρωση μεταφράσεων (Διαγράφει υπάρχουσες μεταφράσεις)

Για να ενημερώσετε τις υπάρχουσες μεταφράσεις (δηλαδή να διαγράψετε τις τρέχουσες και να τις αντικαταστήσετε με νέες), χρησιμοποιήστε την επιλογή `-u`. Αυτή θα διαγράψει όλες τις υπάρχουσες μεταφράσεις για τις καθορισμένες γλώσσες και θα τις μεταφράσει ξανά.

```bash
translate -l "ko" -u
```

Προσοχή: Αυτή η εντολή θα σας ζητήσει επιβεβαίωση πριν προχωρήσει στη διαγραφή των υπαρχουσών μεταφράσεων.

#### Παράδειγμα στο Phi-3 CookBook

Στο **Phi-3 CookBook**, χρησιμοποίησα την παρακάτω μέθοδο για να ενημερώσω όλα τα μεταφρασμένα αρχεία στα Ισπανικά. Προτείνω να χρησιμοποιείτε αυτή τη μέθοδο όταν υπάρχουν σημαντικές αλλαγές στο αρχικό περιεχόμενο σε πολλά αρχεία markdown. Αν υπάρχουν μόνο λίγα αρχεία markdown που χρειάζονται ενημέρωση, είναι πιο αποδοτικό να τα διαγράψετε χειροκίνητα και μετά να χρησιμοποιήσετε τη μέθοδο `-a` για να προσθέσετε τις ενημερωμένες μεταφράσεις.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. Μετάφραση μόνο εικόνων

Για να μεταφράσετε μόνο τα αρχεία εικόνων στο έργο σας, χρησιμοποιήστε την επιλογή `-img`:

```bash
translate -l "ko" -img
```

Αυτή η εντολή θα μεταφράσει μόνο τις εικόνες στα Κορεατικά, χωρίς να επηρεάσει τα αρχεία markdown.

### 6. Μετάφραση μόνο αρχείων Markdown

Για να μεταφράσετε μόνο τα αρχεία markdown στο έργο σας, χρησιμοποιήστε την επιλογή `-md`:

```bash
translate -l "ko" -md
```

#### Παράδειγμα στο Phi-3 CookBook

Στο **Phi-3 CookBook**, χρησιμοποίησα την παρακάτω μέθοδο για να ελέγξω για σφάλματα μετάφρασης στα κορεατικά αρχεία και να επαναλάβω αυτόματα τη μετάφραση για όσα αρχεία εντοπίστηκαν προβλήματα.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

Αυτή η επιλογή ελέγχει για σφάλματα μετάφρασης. Προς το παρόν, αν η διαφορά στις αλλαγές γραμμών μεταξύ του αρχικού και του μεταφρασμένου αρχείου είναι πάνω από έξι, το αρχείο επισημαίνεται ως προβληματικό. Σκοπεύω να βελτιώσω αυτό το κριτήριο για μεγαλύτερη ευελιξία στο μέλλον.

Για παράδειγμα, αυτή η μέθοδος είναι χρήσιμη για τον εντοπισμό ελλιπών τμημάτων ή κατεστραμμένων μεταφράσεων, και θα επαναλάβει αυτόματα τη μετάφραση για αυτά τα αρχεία.

Ωστόσο, αν ήδη γνωρίζετε ποια αρχεία είναι προβληματικά, είναι πιο αποδοτικό να τα διαγράψετε χειροκίνητα και να χρησιμοποιήσετε την επιλογή `-a` για να τα μεταφράσετε ξανά.

### 8. Λειτουργία Debug

Για να ενεργοποιήσετε αναλυτική καταγραφή για αντιμετώπιση προβλημάτων, χρησιμοποιήστε την επιλογή `-d`:

```bash
translate -l "ko" -d
```

Αυτή η εντολή θα εκτελέσει τη μετάφραση σε λειτουργία debug, παρέχοντας επιπλέον πληροφορίες καταγραφής που μπορούν να σας βοηθήσουν να εντοπίσετε προβλήματα κατά τη διαδικασία μετάφρασης.

#### Παράδειγμα στο Phi-3 CookBook

Στο **Phi-3 CookBook**, αντιμετώπισα ένα πρόβλημα όπου οι μεταφράσεις με πολλά links σε αρχεία markdown προκαλούσαν σφάλματα μορφοποίησης, όπως σπασμένες μεταφράσεις και αγνοημένες αλλαγές γραμμών. Για να διαγνώσω το πρόβλημα, χρησιμοποίησα την επιλογή `-d` για να δω πώς λειτουργεί η διαδικασία μετάφρασης.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. Μετάφραση σε όλες τις γλώσσες

Αν θέλετε να μεταφράσετε το έργο σε όλες τις υποστηριζόμενες γλώσσες, χρησιμοποιήστε τη λέξη-κλειδί all.

> [!WARNING]
> Η μετάφραση σε όλες τις γλώσσες ταυτόχρονα μπορεί να πάρει πολύ χρόνο, ανάλογα με το μέγεθος του έργου. Για παράδειγμα, η μετάφραση του **Phi-3 CookBook** στα Ισπανικά πήρε περίπου 2 ώρες. Δεδομένης της κλίμακας, δεν είναι πρακτικό για ένα άτομο να διαχειριστεί 20 γλώσσες. Συνιστάται να μοιράσετε τη δουλειά σε πολλούς συνεισφέροντες, ο καθένας να αναλάβει μία ή δύο γλώσσες, και να ενημερώνετε τις μεταφράσεις σταδιακά.

```bash
translate -l "all"
```

Αυτή η εντολή θα μεταφράσει το έργο σε όλες τις διαθέσιμες γλώσσες. Αν προχωρήσετε, η μετάφραση μπορεί να πάρει αρκετό χρόνο ανάλογα με το μέγεθος του έργου.

> [!TIP]
>
> ### Χειροκίνητη διαγραφή μεταφρασμένων αρχείων (Προαιρετικό)
> Τα μεταφρασμένα αρχεία πλέον ανιχνεύονται και καθαρίζονται αυτόματα όταν ενημερώνεται ένα αρχείο πηγής.
>
> Ωστόσο, αν θέλετε να ενημερώσετε χειροκίνητα μια μετάφραση - για παράδειγμα, να ξανακάνετε ένα συγκεκριμένο αρχείο ή να παρακάμψετε τη συμπεριφορά του συστήματος - μπορείτε να χρησιμοποιήσετε την παρακάτω εντολή για να διαγράψετε όλες τις εκδόσεις του αρχείου σε όλους τους φακέλους γλωσσών.
>
> ### Σε Windows:
> 1. **Με Command Prompt**:
>    - Ανοίξτε το Command Prompt.
>    - Μεταβείτε στο φάκελο όπου βρίσκονται τα αρχεία με την εντολή `cd`.
>    - Χρησιμοποιήστε την παρακάτω εντολή για διαγραφή αρχείων:
>      ```
>      del /s *filename*
>      ```
>      Αντικαταστήστε το `filename` με το συγκεκριμένο μέρος του ονόματος αρχείου που ψάχνετε. Η επιλογή `/s` ψάχνει και σε υποφακέλους.
>
> 2. **Με PowerShell**:
>    - Ανοίξτε το PowerShell.
>    - Εκτελέστε αυτή την εντολή:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      Αντικαταστήστε το `"C:\YourPath"` με τη διαδρομή του φακέλου και το `filename` με το συγκεκριμένο όνομα.
>
> ### Σε macOS/Linux:
> 1. **Με Terminal**:
>   - Ανοίξτε το Terminal.
>   - Μεταβείτε στον κατάλογο με `cd`.
>   - Χρησιμοποιήστε την εντολή `find`:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     Αντικαταστήστε το `filename` με το συγκεκριμένο όνομα.
>
> Πάντα να ελέγχετε τα αρχεία πριν τα διαγράψετε για να αποφύγετε τυχαία απώλεια. 
>
> Μόλις διαγράψετε τα αρχεία που θέλετε να αντικατασταθούν, απλά ξανατρέξτε την εντολή `translate -l` για να ενημερώσετε τις πιο πρόσφατες αλλαγές αρχείων.

---

**Αποποίηση Ευθύνης**:
Αυτό το έγγραφο έχει μεταφραστεί χρησιμοποιώντας την υπηρεσία αυτόματης μετάφρασης AI [Co-op Translator](https://github.com/Azure/co-op-translator). Παρότι καταβάλλουμε προσπάθειες για ακρίβεια, παρακαλούμε να γνωρίζετε ότι οι αυτόματες μεταφράσεις ενδέχεται να περιέχουν σφάλματα ή ανακρίβειες. Το πρωτότυπο έγγραφο στη μητρική του γλώσσα πρέπει να θεωρείται η αυθεντική πηγή. Για κρίσιμες πληροφορίες, συνιστάται επαγγελματική ανθρώπινη μετάφραση. Δεν φέρουμε ευθύνη για τυχόν παρανοήσεις ή εσφαλμένες ερμηνείες που προκύπτουν από τη χρήση αυτής της μετάφρασης.