<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T11:10:42+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "el"
}
-->
# Συμβολή στο Co-op Translator

Αυτό το έργο καλωσορίζει συνεισφορές και προτάσεις. Οι περισσότερες συνεισφορές απαιτούν να συμφωνήσετε με μια
Συμφωνία Άδειας Συμβολής (CLA) που δηλώνει ότι έχετε το δικαίωμα και πράγματι μας παραχωρείτε
τα δικαιώματα να χρησιμοποιήσουμε τη συνεισφορά σας. Για λεπτομέρειες, επισκεφθείτε https://cla.opensource.microsoft.com.

Όταν υποβάλλετε ένα pull request, ένα bot CLA θα καθορίσει αυτόματα αν χρειάζεται να παρέχετε
CLA και θα διακοσμήσει το PR ανάλογα (π.χ., έλεγχος κατάστασης, σχόλιο). Απλώς ακολουθήστε τις οδηγίες
που παρέχει το bot. Θα χρειαστεί να το κάνετε μόνο μία φορά σε όλα τα αποθετήρια που χρησιμοποιούν το CLA μας.

## Ρύθμιση περιβάλλοντος ανάπτυξης

Για να ρυθμίσετε το περιβάλλον ανάπτυξης για αυτό το έργο, προτείνουμε τη χρήση του Poetry για τη διαχείριση εξαρτήσεων. Χρησιμοποιούμε το `pyproject.toml` για τη διαχείριση των εξαρτήσεων του έργου, και επομένως, για να εγκαταστήσετε τις εξαρτήσεις, θα πρέπει να χρησιμοποιήσετε το Poetry.

### Δημιουργία εικονικού περιβάλλοντος

#### Χρήση pip

```bash
python -m venv .venv
```

#### Χρήση Poetry

```bash
poetry init
```

### Ενεργοποίηση του εικονικού περιβάλλοντος

#### Για pip και Poetry

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Χρήση Poetry

```bash
poetry shell
```

### Εγκατάσταση του πακέτου και των απαιτούμενων πακέτων

#### Χρήση Poetry (από pyproject.toml)

```bash
poetry install
```

### Χειροκίνητος έλεγχος

Πριν υποβάλετε ένα PR, είναι σημαντικό να δοκιμάσετε τη λειτουργία μετάφρασης με πραγματική τεκμηρίωση:

1. Δημιουργήστε έναν φάκελο test στον ριζικό κατάλογο:
    ```bash
    mkdir test_docs
    ```

2. Αντιγράψτε κάποια αρχεία markdown τεκμηρίωσης και εικόνες που θέλετε να μεταφράσετε στον φάκελο test. Για παράδειγμα:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. Εγκαταστήστε το πακέτο τοπικά:
    ```bash
    pip install -e .
    ```

4. Εκτελέστε το Co-op Translator στα δοκιμαστικά σας έγγραφα:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. Ελέγξτε τα μεταφρασμένα αρχεία στους φακέλους `test_docs/translations` και `test_docs/translated_images` για να επαληθεύσετε:
   - Την ποιότητα της μετάφρασης
   - Ότι τα σχόλια μεταδεδομένων είναι σωστά
   - Ότι η αρχική δομή markdown διατηρείται
   - Ότι οι σύνδεσμοι και οι εικόνες λειτουργούν σωστά

Αυτή η χειροκίνητη δοκιμή βοηθά να διασφαλιστεί ότι οι αλλαγές σας λειτουργούν καλά σε πραγματικά σενάρια.

### Μεταβλητές περιβάλλοντος

1. Δημιουργήστε ένα αρχείο `.env` στον ριζικό κατάλογο αντιγράφοντας το παρεχόμενο αρχείο `.env.template`.
1. Συμπληρώστε τις μεταβλητές περιβάλλοντος όπως υποδεικνύεται.

> [!TIP]
>
> ### Επιπλέον επιλογές περιβάλλοντος ανάπτυξης
>
> Εκτός από την τοπική εκτέλεση του έργου, μπορείτε επίσης να χρησιμοποιήσετε τα GitHub Codespaces ή τα VS Code Dev Containers για εναλλακτική ρύθμιση περιβάλλοντος ανάπτυξης.
>
> #### GitHub Codespaces
>
> Μπορείτε να εκτελέσετε αυτά τα δείγματα εικονικά χρησιμοποιώντας τα GitHub Codespaces χωρίς επιπλέον ρυθμίσεις ή εγκαταστάσεις.
>
> Το κουμπί θα ανοίξει μια web-based έκδοση του VS Code στον περιηγητή σας:
>
> 1. Ανοίξτε το πρότυπο (μπορεί να πάρει μερικά λεπτά):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### Τοπική εκτέλεση με VS Code Dev Containers
>
> ⚠️ Αυτή η επιλογή λειτουργεί μόνο αν το Docker Desktop σας έχει τουλάχιστον 16 GB RAM. Αν έχετε λιγότερα από 16 GB RAM, μπορείτε να δοκιμάσετε την [επιλογή GitHub Codespaces](../..) ή να [το ρυθμίσετε τοπικά](../..).
>
> Μια σχετική επιλογή είναι τα VS Code Dev Containers, που ανοίγουν το έργο στο τοπικό σας VS Code χρησιμοποιώντας την [επέκταση Dev Containers](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers):
>
> 1. Ξεκινήστε το Docker Desktop (εγκαταστήστε το αν δεν είναι ήδη εγκατεστημένο)
> 2. Ανοίξτε το έργο:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### Στυλ κώδικα

Χρησιμοποιούμε το [Black](https://github.com/psf/black) ως formatter κώδικα Python για να διατηρούμε συνεπή στυλ κώδικα σε όλο το έργο. Το Black είναι ένας αδιάλλακτος formatter που αναμορφώνει αυτόματα τον κώδικα Python ώστε να συμμορφώνεται με το στυλ του Black.

#### Ρύθμιση

Η ρύθμιση του Black καθορίζεται στο `pyproject.toml` μας:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Εγκατάσταση του Black

Μπορείτε να εγκαταστήσετε το Black είτε με Poetry (συνιστάται) είτε με pip:

##### Χρήση Poetry

Το Black εγκαθίσταται αυτόματα όταν ρυθμίζετε το περιβάλλον ανάπτυξης:
```bash
poetry install
```

##### Χρήση pip

Αν χρησιμοποιείτε pip, μπορείτε να εγκαταστήσετε το Black απευθείας:
```bash
pip install black
```

#### Χρήση του Black

##### Με Poetry

1. Μορφοποιήστε όλα τα αρχεία Python στο έργο:
    ```bash
    poetry run black .
    ```

2. Μορφοποιήστε ένα συγκεκριμένο αρχείο ή φάκελο:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### Με pip

1. Μορφοποιήστε όλα τα αρχεία Python στο έργο:
    ```bash
    black .
    ```

2. Μορφοποιήστε ένα συγκεκριμένο αρχείο ή φάκελο:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> Συνιστούμε να ρυθμίσετε τον επεξεργαστή σας ώστε να μορφοποιεί αυτόματα τον κώδικα με το Black κατά την αποθήκευση. Οι περισσότεροι σύγχρονοι επεξεργαστές υποστηρίζουν αυτή τη λειτουργία μέσω επεκτάσεων ή plugins.

## Εκτέλεση του Co-op Translator

Για να εκτελέσετε το Co-op Translator χρησιμοποιώντας το Poetry στο περιβάλλον σας, ακολουθήστε τα παρακάτω βήματα:

1. Μεταβείτε στον κατάλογο όπου θέλετε να κάνετε δοκιμές μετάφρασης ή δημιουργήστε έναν προσωρινό φάκελο για δοκιμές.

2. Εκτελέστε την παρακάτω εντολή. Αντικαταστήστε το `-l ko` με τον κωδικό γλώσσας στην οποία θέλετε να μεταφράσετε. Η σημαία `-d` υποδηλώνει λειτουργία αποσφαλμάτωσης.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> Βεβαιωθείτε ότι το περιβάλλον Poetry είναι ενεργοποιημένο (poetry shell) πριν εκτελέσετε την εντολή.

## Συμβολή νέας γλώσσας

Καλωσορίζουμε συνεισφορές που προσθέτουν υποστήριξη για νέες γλώσσες. Πριν ανοίξετε ένα PR, παρακαλούμε ολοκληρώστε τα παρακάτω βήματα για να διασφαλίσετε ομαλή αναθεώρηση.

1. Προσθέστε τη γλώσσα στον χάρτη γραμματοσειρών
   - Επεξεργαστείτε το `src/co_op_translator/fonts/font_language_mappings.yml`
   - Προσθέστε μια εγγραφή με:
     - `code`: Κωδικός γλώσσας τύπου ISO (π.χ., `vi`)
     - `name`: Φιλικό προς τον χρήστη όνομα εμφάνισης
     - `font`: Μια γραμματοσειρά που περιλαμβάνεται στο `src/co_op_translator/fonts/` και υποστηρίζει το σενάριο
     - `rtl`: `true` αν είναι δεξιά προς τα αριστερά, αλλιώς `false`

2. Συμπεριλάβετε τα απαιτούμενα αρχεία γραμματοσειράς (αν χρειάζεται)
   - Αν απαιτείται νέα γραμματοσειρά, ελέγξτε τη συμβατότητα άδειας για διανομή ανοιχτού κώδικα
   - Προσθέστε το αρχείο γραμματοσειράς στο `src/co_op_translator/fonts/`

3. Τοπική επαλήθευση
   - Εκτελέστε μεταφράσεις για ένα μικρό δείγμα (Markdown, εικόνες και σημειωματάρια όπως απαιτείται)
   - Επαληθεύστε ότι η έξοδος αποδίδεται σωστά, συμπεριλαμβανομένων των γραμματοσειρών και οποιασδήποτε διάταξης RTL αν ισχύει

4. Ενημερώστε την τεκμηρίωση
   - Βεβαιωθείτε ότι η γλώσσα εμφανίζεται στο `getting_started/supported-languages.md`
   - Δεν απαιτούνται αλλαγές στο `getting_started/README_languages_template.md`, καθώς παράγεται από τη λίστα υποστήριξης

5. Ανοίξτε ένα PR
   - Περιγράψτε τη γλώσσα που προσθέσατε και τυχόν θέματα γραμματοσειράς/άδειας
   - Επισυνάψτε στιγμιότυπα οθόνης της απόδοσης αν είναι δυνατόν

Παράδειγμα εγγραφής YAML:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### Δοκιμή της νέας γλώσσας

Μπορείτε να δοκιμάσετε τη νέα γλώσσα εκτελώντας την παρακάτω εντολή:

```bash
# Δημιουργήστε και ενεργοποιήστε ένα εικονικό περιβάλλον
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Εγκαταστήστε το πακέτο ανάπτυξης
pip install -e .
# Εκτελέστε τη μετάφραση
translate -l "new_lang"
```

## Συντηρητές

### Μήνυμα commit και στρατηγική συγχώνευσης

Για να διασφαλίσουμε συνέπεια και σαφήνεια στο ιστορικό commit του έργου μας, ακολουθούμε συγκεκριμένο πρότυπο μηνύματος commit **για το τελικό μήνυμα commit** όταν χρησιμοποιούμε τη στρατηγική **Squash and Merge**.

Όταν ένα pull request (PR) συγχωνεύεται, τα μεμονωμένα commits θα συμπιεστούν σε ένα μόνο commit. Το τελικό μήνυμα commit πρέπει να ακολουθεί το παρακάτω πρότυπο για να διατηρείται καθαρό και συνεπές ιστορικό.

#### Πρότυπο μηνύματος commit (για squash and merge)

Χρησιμοποιούμε το παρακάτω πρότυπο για τα μηνύματα commit:

```bash
<type>: <description> (#<Αριθμός PR>)
```

- **type**: Καθορίζει την κατηγορία του commit. Χρησιμοποιούμε τους εξής τύπους:
  - `Docs`: Για ενημερώσεις τεκμηρίωσης.
  - `Build`: Για αλλαγές που σχετίζονται με το σύστημα κατασκευής ή εξαρτήσεις, συμπεριλαμβανομένων ενημερώσεων αρχείων ρύθμισης, ροών εργασίας CI ή του Dockerfile.
  - `Core`: Για τροποποιήσεις στον πυρήνα λειτουργικότητας ή χαρακτηριστικών του έργου, ειδικά σε αρχεία στον φάκελο `src/co_op_translator/core`.

- **description**: Μια σύντομη περίληψη της αλλαγής.
- **PR number**: Ο αριθμός του pull request που σχετίζεται με το commit.

**Παραδείγματα**:

- `Docs: Ενημέρωση οδηγιών εγκατάστασης για μεγαλύτερη σαφήνεια (#50)`
- `Core: Βελτίωση χειρισμού μετάφρασης εικόνων (#60)`

> [!NOTE]
> Προς το παρόν, τα πρόθεματα **`Docs`**, **`Core`** και **`Build`** προστίθενται αυτόματα στους τίτλους των PR βάσει των ετικετών που εφαρμόζονται στον τροποποιημένο πηγαίο κώδικα. Εφόσον έχει εφαρμοστεί η σωστή ετικέτα, συνήθως δεν χρειάζεται να ενημερώσετε χειροκίνητα τον τίτλο του PR. Απλώς βεβαιωθείτε ότι όλα είναι σωστά και το πρόθεμα έχει δημιουργηθεί κατάλληλα.

#### Στρατηγική συγχώνευσης

Χρησιμοποιούμε τη στρατηγική **Squash and Merge** ως προεπιλογή για τα pull requests. Αυτή η στρατηγική διασφαλίζει ότι τα μηνύματα commit ακολουθούν το πρότυπό μας, ακόμα κι αν τα μεμονωμένα commits δεν το κάνουν.

**Λόγοι**:

- Καθαρό, γραμμικό ιστορικό έργου.
- Συνέπεια στα μηνύματα commit.
- Μείωση θορύβου από μικρά commits (π.χ., "διόρθωση ορθογραφικού λάθους").

Κατά τη συγχώνευση, βεβαιωθείτε ότι το τελικό μήνυμα commit ακολουθεί το πρότυπο που περιγράφεται παραπάνω.

**Παράδειγμα Squash and Merge**
Αν ένα PR περιέχει τα εξής commits:

- `fix typo`
- `update README`
- `adjust formatting`

Θα πρέπει να συμπιεστούν σε:
`Docs: Βελτίωση σαφήνειας και μορφοποίησης τεκμηρίωσης (#65)`

### Διαδικασία έκδοσης

Αυτή η ενότητα περιγράφει τον απλούστερο τρόπο για τους συντηρητές να δημοσιεύσουν μια νέα έκδοση του Co-op Translator.

#### 1. Αύξηση της έκδοσης στο `pyproject.toml`

1. Αποφασίστε τον επόμενο αριθμό έκδοσης (ακολουθούμε το semantic versioning: `MAJOR.MINOR.PATCH`).
2. Επεξεργαστείτε το `pyproject.toml` και ενημερώστε το πεδίο `version` κάτω από το `[tool.poetry]`.
3. Ανοίξτε ένα αφιερωμένο pull request που αλλάζει μόνο την έκδοση (και τυχόν αυτόματα ενημερωμένα αρχεία κλειδώματος/μεταδεδομένων, αν υπάρχουν).
4. Μετά την αναθεώρηση, χρησιμοποιήστε **Squash and Merge** και βεβαιωθείτε ότι το τελικό μήνυμα commit ακολουθεί το πρότυπο που περιγράφεται παραπάνω.

#### 2. Δημιουργία έκδοσης στο GitHub

1. Μεταβείτε στη σελίδα του αποθετηρίου στο GitHub και ανοίξτε **Releases** → **Draft a new release**.
2. Δημιουργήστε ένα νέο tag (π.χ., `v0.13.0`) από το branch `main`.
3. Ορίστε τον τίτλο της έκδοσης στην ίδια έκδοση (π.χ., `v0.13.0`).
4. Κάντε κλικ στο **Generate release notes** για αυτόματη συμπλήρωση του changelog.
5. Προαιρετικά, επεξεργαστείτε το κείμενο (π.χ., για να τονίσετε νέες υποστηριζόμενες γλώσσες ή σημαντικές αλλαγές).
6. Δημοσιεύστε την έκδοση.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Αποποίηση ευθυνών**:  
Αυτό το έγγραφο έχει μεταφραστεί χρησιμοποιώντας την υπηρεσία αυτόματης μετάφρασης AI [Co-op Translator](https://github.com/Azure/co-op-translator). Παρόλο που επιδιώκουμε την ακρίβεια, παρακαλούμε να λάβετε υπόψη ότι οι αυτόματες μεταφράσεις ενδέχεται να περιέχουν λάθη ή ανακρίβειες. Το πρωτότυπο έγγραφο στη μητρική του γλώσσα πρέπει να θεωρείται η αυθεντική πηγή. Για κρίσιμες πληροφορίες, συνιστάται επαγγελματική ανθρώπινη μετάφραση. Δεν φέρουμε ευθύνη για τυχόν παρεξηγήσεις ή λανθασμένες ερμηνείες που προκύπτουν από τη χρήση αυτής της μετάφρασης.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->