<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:47:48+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "bn"
}
-->
# Co-op Translator দিয়ে আপনার প্রজেক্ট অনুবাদ করুন

**Co-op Translator** একটি কমান্ড-লাইন ইন্টারফেস (CLI) টুল, যা আপনাকে আপনার প্রজেক্টের মার্কডাউন ও ইমেজ ফাইলগুলো একাধিক ভাষায় অনুবাদ করতে সাহায্য করে। এই অংশে টুলটি কীভাবে ব্যবহার করবেন, বিভিন্ন CLI অপশন কীভাবে কাজ করে, এবং বিভিন্ন ব্যবহারিক উদাহরণ দেওয়া হয়েছে।

---

## উদাহরণ পরিস্থিতি ও কমান্ডসমূহ

এখানে **Co-op Translator**-এর কিছু সাধারণ ব্যবহারিক পরিস্থিতি ও সেগুলোর জন্য উপযুক্ত কমান্ড দেওয়া হলো।

### ১. বেসিক অনুবাদ (একটি ভাষায়)

আপনার পুরো প্রজেক্ট (মার্কডাউন ফাইল ও ইমেজ) একটি ভাষায়, যেমন কোরিয়ান ভাষায় অনুবাদ করতে নিচের কমান্ডটি ব্যবহার করুন:

```bash
translate -l "ko"
```

এই কমান্ডটি সব মার্কডাউন ও ইমেজ ফাইল কোরিয়ান ভাষায় অনুবাদ করবে এবং নতুন অনুবাদ যোগ করবে, কোনো বিদ্যমান অনুবাদ ডিলিট করবে না।

#### Phi-3 CookBook-এ উদাহরণ

**Phi-3 CookBook**-এ, আমি নিচের পদ্ধতিতে বিদ্যমান মার্কডাউন ফাইল ও ইমেজের জন্য কোরিয়ান অনুবাদ যোগ করেছি।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### ২. একাধিক ভাষায় অনুবাদ

আপনার প্রজেক্টকে একাধিক ভাষায় (যেমন, স্প্যানিশ, ফ্রেঞ্চ, ও জার্মান) অনুবাদ করতে এই কমান্ডটি ব্যবহার করুন:

```bash
translate -l "es fr de"
```

এই কমান্ডটি প্রজেক্টকে স্প্যানিশ, ফ্রেঞ্চ, ও জার্মান ভাষায় অনুবাদ করবে এবং নতুন অনুবাদ যোগ করবে, বিদ্যমান অনুবাদ ওভাররাইট করবে না।

#### Phi-3 CookBook-এ উদাহরণ

**Phi-3 CookBook**-এ, সর্বশেষ কমিটের পরিবর্তনগুলো পাওয়ার পর, আমি নতুন যোগ হওয়া মার্কডাউন ফাইল ও ইমেজ অনুবাদ করতে নিচের পদ্ধতি ব্যবহার করেছি।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

### ৩. অনুবাদ আপডেট করা (বিদ্যমান অনুবাদ ডিলিট করে)

বিদ্যমান অনুবাদ আপডেট করতে (অর্থাৎ, বর্তমান অনুবাদ ডিলিট করে নতুন অনুবাদ দিয়ে রিপ্লেস করতে), `-u` অপশন ব্যবহার করুন। এটি নির্দিষ্ট ভাষার সব বিদ্যমান অনুবাদ ডিলিট করে আবার অনুবাদ করবে।

```bash
translate -l "ko" -u
```

সতর্কতা: এই কমান্ডটি বিদ্যমান অনুবাদ ডিলিট করার আগে কনফার্মেশন চাইবে।

#### Phi-3 CookBook-এ উদাহরণ

**Phi-3 CookBook**-এ, আমি স্প্যানিশ ভাষায় সব অনুবাদ ফাইল আপডেট করতে এই পদ্ধতি ব্যবহার করেছি। যখন একাধিক মার্কডাউন ডকুমেন্টে বড় পরিবর্তন হয়, তখন এই পদ্ধতি ব্যবহার করা ভালো। তবে, যদি কেবল কয়েকটি অনুবাদ ফাইল আপডেট করতে হয়, তাহলে নির্দিষ্ট ফাইলগুলো ম্যানুয়ালি ডিলিট করে `-a` পদ্ধতিতে আপডেটেড অনুবাদ যোগ করাই বেশি কার্যকর।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### ৫. শুধু ইমেজ অনুবাদ করা

শুধু প্রজেক্টের ইমেজ ফাইলগুলো অনুবাদ করতে `-img` অপশন ব্যবহার করুন:

```bash
translate -l "ko" -img
```

এই কমান্ডটি শুধু ইমেজগুলো কোরিয়ান ভাষায় অনুবাদ করবে, কোনো মার্কডাউন ফাইলে প্রভাব ফেলবে না।

### ৬. শুধু মার্কডাউন ফাইল অনুবাদ করা

শুধু মার্কডাউন ফাইলগুলো অনুবাদ করতে `-md` অপশন ব্যবহার করুন:

```bash
translate -l "ko" -md
```

#### Phi-3 CookBook-এ উদাহরণ

**Phi-3 CookBook**-এ, আমি কোরিয়ান ফাইলগুলোতে অনুবাদজনিত ত্রুটি চেক করতে এবং যেসব ফাইলে সমস্যা পাওয়া গেছে সেগুলো স্বয়ংক্রিয়ভাবে পুনরায় অনুবাদ করতে এই পদ্ধতি ব্যবহার করেছি।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

এই অপশনটি অনুবাদজনিত ত্রুটি চেক করে। বর্তমানে, মূল ও অনুবাদিত ফাইলে লাইনের ব্যবধান ছয়টির বেশি হলে, ফাইলটিকে অনুবাদ ত্রুটিপূর্ণ হিসেবে চিহ্নিত করা হয়। ভবিষ্যতে এই মানদণ্ড আরও নমনীয় করার পরিকল্পনা রয়েছে।

উদাহরণস্বরূপ, এই পদ্ধতি অনুপস্থিত অংশ বা নষ্ট অনুবাদ শনাক্ত করতে কাজে লাগে এবং স্বয়ংক্রিয়ভাবে সেসব ফাইল পুনরায় অনুবাদ করে।

তবে, যদি আপনি আগে থেকেই জানেন কোন ফাইলগুলোতে সমস্যা আছে, তাহলে সেগুলো ম্যানুয়ালি ডিলিট করে `-a` অপশন দিয়ে পুনরায় অনুবাদ করাই বেশি কার্যকর।

### ৮. ডিবাগ মোড

সমস্যা সমাধানের জন্য বিস্তারিত লগিং চালু করতে `-d` অপশন ব্যবহার করুন:

```bash
translate -l "ko" -d
```

এই কমান্ডটি অনুবাদকে ডিবাগ মোডে চালাবে এবং অতিরিক্ত লগিং তথ্য দেবে, যা অনুবাদ প্রক্রিয়ায় সমস্যা শনাক্ত করতে সাহায্য করবে।

#### Phi-3 CookBook-এ উদাহরণ

**Phi-3 CookBook**-এ, আমি দেখেছি অনেক লিঙ্কসহ মার্কডাউন ফাইলে অনুবাদে ফরম্যাটিং সমস্যা হচ্ছিল, যেমন অনুবাদ ভেঙে যাওয়া বা লাইন ব্রেক উপেক্ষা করা। এই সমস্যা বিশ্লেষণ করতে, আমি `-d` অপশন ব্যবহার করেছি যাতে অনুবাদ প্রক্রিয়া কীভাবে চলছে তা দেখা যায়।

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### ৯. সব ভাষায় অনুবাদ

আপনি যদি প্রজেক্টকে সব সাপোর্টেড ভাষায় অনুবাদ করতে চান, তাহলে all কীওয়ার্ড ব্যবহার করুন।

```bash
translate -l "all"
```

এই কমান্ডটি প্রজেক্টকে সব উপলব্ধ ভাষায় অনুবাদ করবে। চালানোর পর, প্রজেক্টের আকার অনুযায়ী অনুবাদে অনেক সময় লাগতে পারে।

> ### অনুবাদিত ফাইল ম্যানুয়ালি ডিলিট করা (ঐচ্ছিক)
> এখন অনুবাদিত ফাইলগুলো স্বয়ংক্রিয়ভাবে শনাক্ত ও ক্লিনআপ হয় যখন সোর্স ফাইল আপডেট হয়।
>
> তবে, আপনি যদি কোনো অনুবাদ ম্যানুয়ালি আপডেট করতে চান—যেমন, নির্দিষ্ট ফাইল আবার করতে বা সিস্টেমের আচরণ ওভাররাইড করতে—তাহলে নিচের কমান্ড দিয়ে সব ভাষার ফোল্ডারে ফাইলটি ডিলিট করতে পারেন।
>
> ### Windows-এ:
> ১. **কমান্ড প্রম্পট ব্যবহার করে**:
>    - Command Prompt খুলুন।
>    - `cd` কমান্ড দিয়ে ফাইলের ফোল্ডারে যান।
>    - নিচের কমান্ডটি ব্যবহার করুন:
>      ```
>      del /s *filename*
>      ```
>      এখানে `filename`-এর জায়গায় আপনার কাঙ্ক্ষিত ফাইলের অংশ লিখুন। `/s` অপশনটি সাবডিরেক্টরিতে খোঁজে।
>
> ২. **PowerShell ব্যবহার করে**:
>    - PowerShell খুলুন।
>    - এই কমান্ডটি চালান:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      `"C:\YourPath"`-এর জায়গায় ফোল্ডার পাথ এবং `filename`-এর জায়গায় নির্দিষ্ট নাম দিন।
>
> ### macOS/Linux-এ:
> ১. **টার্মিনাল ব্যবহার করে**:
>   - টার্মিনাল খুলুন।
>   - `cd` দিয়ে ডিরেক্টরিতে যান।
>   - `find` কমান্ড ব্যবহার করুন:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     এখানে `filename`-এর জায়গায় নির্দিষ্ট নাম দিন।
>
> ডিলিট করার আগে সব ফাইল ভালোভাবে চেক করুন, যাতে ভুলবশত কোনো প্রয়োজনীয় ফাইল ডিলিট না হয়।
>
> প্রয়োজনীয় ফাইলগুলো ডিলিট করার পর, আপনার `translate -l` কমান্ডটি আবার চালান, যাতে সর্বশেষ পরিবর্তনগুলো আপডেট হয়।

---

**অস্বীকৃতি**:
এই নথিটি AI অনুবাদ পরিষেবা [Co-op Translator](https://github.com/Azure/co-op-translator) ব্যবহার করে অনুবাদ করা হয়েছে। আমরা যথাসাধ্য নির্ভুলতা বজায় রাখার চেষ্টা করি, তবে অনুগ্রহ করে মনে রাখবেন যে স্বয়ংক্রিয় অনুবাদে ভুল বা অসঙ্গতি থাকতে পারে। মূল ভাষায় থাকা নথিটিই কর্তৃত্বপূর্ণ উৎস হিসেবে বিবেচিত হবে। গুরুত্বপূর্ণ তথ্যের জন্য পেশাদার মানব অনুবাদ সুপারিশ করা হয়। এই অনুবাদের ব্যবহারের ফলে কোনো ভুল বোঝাবুঝি বা ভুল ব্যাখ্যার জন্য আমরা দায়ী নই।