<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T10:35:12+00:00",
  "source_file": "README.md",
  "language_code": "bn"
}
-->
# কো-অপ ট্রান্সলেটর

_সহজেই আপনার শিক্ষামূলক GitHub কনটেন্টকে একাধিক ভাষায় অনুবাদ করে বিশ্বব্যাপী দর্শকদের কাছে পৌঁছান।_

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 একাধিক ভাষার সমর্থন

#### [Co-op Translator](https://github.com/Azure/Co-op-Translator) দ্বারা সমর্থিত

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[আরবি](../ar/README.md) | [বাংলা](./README.md) | [বুলগেরিয়ান](../bg/README.md) | [বর্মিজ (মায়ানমার)](../my/README.md) | [চীনা (সরলীকৃত)](../zh/README.md) | [চীনা (প্রচলিত, হংকং)](../hk/README.md) | [চীনা (প্রচলিত, ম্যাকাও)](../mo/README.md) | [চীনা (প্রচলিত, তাইওয়ান)](../tw/README.md) | [ক্রোয়েশিয়ান](../hr/README.md) | [চেক](../cs/README.md) | [ড্যানিশ](../da/README.md) | [ডাচ](../nl/README.md) | [এস্তোনিয়ান](../et/README.md) | [ফিনিশ](../fi/README.md) | [ফরাসি](../fr/README.md) | [জার্মান](../de/README.md) | [গ্রিক](../el/README.md) | [হিব্রু](../he/README.md) | [হিন্দি](../hi/README.md) | [হাঙ্গেরিয়ান](../hu/README.md) | [ইন্দোনেশিয়ান](../id/README.md) | [ইতালিয়ান](../it/README.md) | [জাপানি](../ja/README.md) | [কন্নড়](../kn/README.md) | [কোরিয়ান](../ko/README.md) | [লিথুয়ানিয়ান](../lt/README.md) | [মালয়](../ms/README.md) | [মালায়ালাম](../ml/README.md) | [মারাঠি](../mr/README.md) | [নেপালি](../ne/README.md) | [নাইজেরিয়ান পিজিন](../pcm/README.md) | [নরওয়েজিয়ান](../no/README.md) | [ফার্সি (পার্সিয়ান)](../fa/README.md) | [পোলিশ](../pl/README.md) | [পর্তুগিজ (ব্রাজিল)](../br/README.md) | [পর্তুগিজ (পর্তুগাল)](../pt/README.md) | [পাঞ্জাবি (গুরমুখি)](../pa/README.md) | [রোমানিয়ান](../ro/README.md) | [রাশিয়ান](../ru/README.md) | [সার্বিয়ান (সিরিলিক)](../sr/README.md) | [স্লোভাক](../sk/README.md) | [স্লোভেনিয়ান](../sl/README.md) | [স্প্যানিশ](../es/README.md) | [সোয়াহিলি](../sw/README.md) | [সুইডিশ](../sv/README.md) | [টাগালগ (ফিলিপিনো)](../tl/README.md) | [তামিল](../ta/README.md) | [তেলুগু](../te/README.md) | [থাই](../th/README.md) | [তুর্কি](../tr/README.md) | [ইউক্রেনিয়ান](../uk/README.md) | [উর্দু](../ur/README.md) | [ভিয়েতনামী](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## ওভারভিউ

**Co-op Translator** আপনার শিক্ষামূলক GitHub কনটেন্টকে একাধিক ভাষায় সহজেই লোকালাইজ করতে সাহায্য করে।  
আপনি যখন আপনার Markdown ফাইল, ছবি বা নোটবুক আপডেট করবেন, অনুবাদগুলো স্বয়ংক্রিয়ভাবে সিঙ্ক্রোনাইজ থাকে, যা নিশ্চিত করে যে আপনার কনটেন্ট সারা বিশ্বে শিক্ষার্থীদের জন্য সঠিক এবং সর্বশেষ থাকবে।

অনুবাদকৃত কনটেন্ট কিভাবে সাজানো হয় তার একটি উদাহরণ:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.bn.png)

## দ্রুত শুরু

```bash
# একটি ভার্চুয়াল পরিবেশ তৈরি করুন এবং সক্রিয় করুন (প্রস্তাবিত)
python -m venv .venv
# উইন্ডোজ
.venv\Scripts\activate
# ম্যাকওএস/লিনাক্স
source .venv/bin/activate
# প্যাকেজ ইনস্টল করুন
pip install co-op-translator
# অনুবাদ করুন
translate -l "ko ja fr" -md
```
  
ডকার:

```bash
# GHCR থেকে পাবলিক ইমেজ টানুন
docker pull ghcr.io/azure/co-op-translator:latest
# বর্তমান ফোল্ডার মাউন্ট করে এবং .env প্রদান করে চালান (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```
  
## ন্যূনতম সেটআপ

1. একটি `.env` ফাইল তৈরি করুন টেমপ্লেট ব্যবহার করে: [.env.template](../../.env.template)  
2. একটি LLM প্রদানকারী কনফিগার করুন (Azure OpenAI বা OpenAI)  
3. (ঐচ্ছিক) ছবি অনুবাদের জন্য (`-img`), Azure AI Vision কনফিগার করুন  
4. (প্রস্তাবিত) পূর্বের অনুবাদগুলো মুছে ফেলুন যাতে দ্বন্দ্ব না হয় (যেমন, `translations/`)  
5. (প্রস্তাবিত) আপনার README-তে অনুবাদের একটি সেকশন যোগ করুন [README languages template](./getting_started/README_languages_template.md) ব্যবহার করে  
6. দেখুন: [Azure AI সেটআপ](./getting_started/set-up-azure-ai.md)

## ব্যবহার

সমস্ত সমর্থিত টাইপ অনুবাদ করুন:

```bash
translate -l "ko ja"
```
  
শুধুমাত্র Markdown:

```bash
translate -l "de" -md
```
  
Markdown + ছবি:

```bash
translate -l "pt" -md -img
```
  
শুধুমাত্র নোটবুক:

```bash
translate -l "zh" -nb
```
  
আরও ফ্ল্যাগ: [কমান্ড রেফারেন্স](./getting_started/command-reference.md)

## বৈশিষ্ট্যসমূহ

- Markdown, নোটবুক এবং ছবির জন্য স্বয়ংক্রিয় অনুবাদ  
- উৎস পরিবর্তনের সাথে অনুবাদগুলো সিঙ্ক্রোনাইজ রাখে  
- লোকাল (CLI) বা CI (GitHub Actions) এ কাজ করে  
- Azure OpenAI বা OpenAI ব্যবহার করে; ছবির জন্য ঐচ্ছিক Azure AI Vision  
- Markdown ফরম্যাটিং এবং গঠন অক্ষুণ্ণ রাখে

## ডকুমেন্টেশন

- [কমান্ড-লাইন গাইড](./getting_started/command-line-guide/command-line-guide.md)  
- [GitHub Actions গাইড (পাবলিক রিপোজিটরি ও স্ট্যান্ডার্ড সিক্রেট)](./getting_started/github-actions-guide/github-actions-guide-public.md)  
- [GitHub Actions গাইড (Microsoft অর্গানাইজেশন রিপোজিটরি ও অর্গ-লেভেল সেটআপ)](./getting_started/github-actions-guide/github-actions-guide-org.md)  
- [README ভাষার টেমপ্লেট](./getting_started/README_languages_template.md)  
- [সমর্থিত ভাষাসমূহ](./getting_started/supported-languages.md)  
- [অংশগ্রহণ](./CONTRIBUTING.md)  
- [সমস্যা সমাধান](./getting_started/troubleshooting.md)

### Microsoft-নির্দিষ্ট গাইড
> [!NOTE]  
> শুধুমাত্র Microsoft “For Beginners” রিপোজিটরির রক্ষণাবেক্ষকদের জন্য।

- [“অন্যান্য কোর্স” তালিকা আপডেট করা (শুধুমাত্র MS Beginners রিপোজিটরির জন্য)](./getting_started/update-other-courses.md)

## আমাদের সমর্থন করুন এবং বৈশ্বিক শিক্ষাকে এগিয়ে নিন

শিক্ষামূলক কনটেন্ট বিশ্বব্যাপী ভাগাভাগি করার পদ্ধতিতে বিপ্লব ঘটাতে আমাদের সাথে যোগ দিন! [Co-op Translator](https://github.com/azure/co-op-translator) কে GitHub-এ ⭐ দিন এবং ভাষার বাধা ভাঙার আমাদের মিশনকে সমর্থন করুন। আপনার আগ্রহ ও অবদান বড় প্রভাব ফেলে! কোড অবদান এবং ফিচার প্রস্তাব সবসময় স্বাগত।

### Microsoft শিক্ষামূলক কনটেন্ট আপনার ভাষায় অন্বেষণ করুন

- [AZD for Beginners](https://github.com/microsoft/AZD-for-beginners)  
- [Edge AI for Beginners](https://github.com/microsoft/edgeai-for-beginners)  
- [Model Context Protocol (MCP) For Beginners](https://github.com/microsoft/mcp-for-beginners)  
- [AI Agents for Beginners](https://github.com/microsoft/ai-agents-for-beginners)  
- [.NET ব্যবহার করে Generative AI for Beginners](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)  
- [Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners)  
- [Java ব্যবহার করে Generative AI for Beginners](https://github.com/microsoft/generative-ai-for-beginners-java)  
- [ML for Beginners](https://aka.ms/ml-beginners)  
- [Data Science for Beginners](https://aka.ms/datascience-beginners)  
- [AI for Beginners](https://aka.ms/ai-beginners)  
- [Cybersecurity for Beginners](https://github.com/microsoft/Security-101)  
- [Web Dev for Beginners](https://aka.ms/webdev-beginners)  
- [IoT for Beginners](https://aka.ms/iot-beginners)  
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## ভিডিও উপস্থাপনা

👉 নিচের ছবিতে ক্লিক করে YouTube-এ দেখুন।

- **Open at Microsoft**: Co-op Translator কীভাবে ব্যবহার করবেন তার সংক্ষিপ্ত ১৮ মিনিটের পরিচিতি ও দ্রুত গাইড।

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.bn.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## অংশগ্রহণ

এই প্রকল্পে অবদান ও প্রস্তাবনা স্বাগত। Azure Co-op Translator-এ অবদান রাখতে আগ্রহী? অনুগ্রহ করে আমাদের [CONTRIBUTING.md](./CONTRIBUTING.md) দেখুন, যেখানে Co-op Translator কে আরও সহজলভ্য করতে আপনি কীভাবে সাহায্য করতে পারেন তা বর্ণনা করা হয়েছে।

## অবদানকারীরা

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## আচরণবিধি

এই প্রকল্পে [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) গ্রহণ করা হয়েছে।  
অধিক তথ্যের জন্য দেখুন [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) অথবা  
যেকোনো প্রশ্ন বা মন্তব্যের জন্য যোগাযোগ করুন [opencode@microsoft.com](mailto:opencode@microsoft.com) এ।

## দায়িত্বশীল AI

Microsoft আমাদের গ্রাহকদের AI পণ্যগুলি দায়িত্বশীলভাবে ব্যবহারে সহায়তা করতে প্রতিশ্রুতিবদ্ধ, আমাদের শেখাগুলো শেয়ার করে এবং Transparency Notes ও Impact Assessments-এর মতো সরঞ্জামের মাধ্যমে বিশ্বাসভিত্তিক অংশীদারিত্ব গড়ে তোলে। এই রিসোর্সগুলো [https://aka.ms/RAI](https://aka.ms/RAI) এ পাওয়া যায়।  
Microsoft-এর দায়িত্বশীল AI-এর দৃষ্টিভঙ্গি আমাদের AI নীতিমালা — ন্যায়পরায়ণতা, নির্ভরযোগ্যতা ও নিরাপত্তা, গোপনীয়তা ও সুরক্ষা, অন্তর্ভুক্তি, স্বচ্ছতা এবং জবাবদিহিতার উপর ভিত্তি করে গড়ে উঠেছে।

বড় আকারের প্রাকৃতিক ভাষা, ছবি এবং ভাষণ মডেল — যেমন এই নমুনায় ব্যবহৃত মডেলগুলো — কখনো কখনো অন্যায়, অবিশ্বস্ত বা আপত্তিকর আচরণ করতে পারে, যা ক্ষতি করতে পারে। অনুগ্রহ করে ঝুঁকি ও সীমাবদ্ধতা সম্পর্কে অবহিত হতে [Azure OpenAI service Transparency note](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) দেখুন।
এই ঝুঁকিগুলো কমানোর জন্য সুপারিশকৃত পদ্ধতি হলো আপনার আর্কিটেকচারে একটি সেফটি সিস্টেম অন্তর্ভুক্ত করা যা ক্ষতিকর আচরণ সনাক্ত এবং প্রতিরোধ করতে পারে। [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) একটি স্বাধীন সুরক্ষা স্তর প্রদান করে, যা অ্যাপ্লিকেশন এবং সেবাগুলিতে ক্ষতিকর ব্যবহারকারী-উত্পাদিত এবং AI-উত্পাদিত বিষয়বস্তু সনাক্ত করতে সক্ষম। Azure AI Content Safety-তে টেক্সট এবং ইমেজ API রয়েছে যা আপনাকে ক্ষতিকর উপাদান সনাক্ত করতে সাহায্য করে। আমাদের একটি ইন্টারেক্টিভ Content Safety Studio ও রয়েছে যা আপনাকে বিভিন্ন মোডালিটিতে ক্ষতিকর বিষয়বস্তু সনাক্ত করার জন্য নমুনা কোড দেখতে, অন্বেষণ করতে এবং চেষ্টা করতে দেয়। নিম্নলিখিত [কুইকস্টার্ট ডকুমেন্টেশন](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) আপনাকে সার্ভিসে অনুরোধ পাঠানোর প্রক্রিয়ায় গাইড করবে।

আরেকটি বিষয় যা বিবেচনা করতে হবে তা হলো সামগ্রিক অ্যাপ্লিকেশন পারফরম্যান্স। মাল্টি-মোডাল এবং মাল্টি-মডেল অ্যাপ্লিকেশনগুলির ক্ষেত্রে, আমরা পারফরম্যান্স বলতে বুঝি যে সিস্টেমটি আপনি এবং আপনার ব্যবহারকারীরা প্রত্যাশা করেন ঠিক তেমনভাবে কাজ করে, যার মধ্যে ক্ষতিকর আউটপুট তৈরি না করাও অন্তর্ভুক্ত। আপনার সামগ্রিক অ্যাপ্লিকেশনের পারফরম্যান্স মূল্যায়ন করা গুরুত্বপূর্ণ, যা [জেনারেশন কোয়ালিটি এবং ঝুঁকি ও সেফটি মেট্রিক্স](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in) ব্যবহার করে করা যায়।

আপনি আপনার ডেভেলপমেন্ট পরিবেশে [prompt flow SDK](https://microsoft.github.io/promptflow/index.html) ব্যবহার করে আপনার AI অ্যাপ্লিকেশন মূল্যায়ন করতে পারেন। একটি টেস্ট ডেটাসেট বা লক্ষ্য দেওয়া হলে, আপনার জেনারেটিভ AI অ্যাপ্লিকেশনের জেনারেশনগুলি বিল্ট-ইন ইভ্যালুয়েটর বা আপনার পছন্দের কাস্টম ইভ্যালুয়েটর দিয়ে পরিমাণগতভাবে পরিমাপ করা হয়। আপনার সিস্টেম মূল্যায়নের জন্য prompt flow sdk দিয়ে শুরু করতে, আপনি [কুইকস্টার্ট গাইড](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk) অনুসরণ করতে পারেন। একবার আপনি একটি ইভ্যালুয়েশন রান সম্পাদন করলে, আপনি [Azure AI Studio-তে ফলাফলগুলো ভিজ্যুয়ালাইজ করতে পারেন](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results)।

## ট্রেডমার্ক

এই প্রকল্পে প্রকল্প, পণ্য বা সেবার ট্রেডমার্ক বা লোগো থাকতে পারে। Microsoft ট্রেডমার্ক বা লোগোর অনুমোদিত ব্যবহার অবশ্যই [Microsoft-এর ট্রেডমার্ক ও ব্র্যান্ড গাইডলাইনস](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general) অনুসরণ করতে হবে। এই প্রকল্পের সংশোধিত সংস্করণে Microsoft ট্রেডমার্ক বা লোগোর ব্যবহার বিভ্রান্তি সৃষ্টি করা বা Microsoft স্পন্সরশিপ বোঝানো উচিত নয়। তৃতীয় পক্ষের ট্রেডমার্ক বা লোগোর যেকোনো ব্যবহার সেই তৃতীয় পক্ষের নীতিমালা অনুসারে হবে।

## সাহায্য নেওয়া

যদি আপনি আটকে যান বা AI অ্যাপ তৈরি সম্পর্কে কোনো প্রশ্ন থাকে, তাহলে যোগ দিন:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

যদি আপনার পণ্য সম্পর্কিত প্রতিক্রিয়া বা ত্রুটি থাকে, তাহলে যান:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**অস্বীকৃতি**:  
এই নথিটি AI অনুবাদ সেবা [Co-op Translator](https://github.com/Azure/co-op-translator) ব্যবহার করে অনূদিত হয়েছে। আমরা যথাসাধ্য সঠিকতার চেষ্টা করি, তবে স্বয়ংক্রিয় অনুবাদে ত্রুটি বা অসঙ্গতি থাকতে পারে। মূল নথিটি তার নিজস্ব ভাষায়ই কর্তৃত্বপূর্ণ উৎস হিসেবে বিবেচিত হওয়া উচিত। গুরুত্বপূর্ণ তথ্যের জন্য পেশাদার মানব অনুবাদ গ্রহণ করার পরামর্শ দেওয়া হয়। এই অনুবাদের ব্যবহারে সৃষ্ট কোনো ভুল বোঝাবুঝি বা ভুল ব্যাখ্যার জন্য আমরা দায়ী নই।
<!-- CO-OP TRANSLATOR DISCLAIMER END -->