<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T10:34:25+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "bn"
}
-->
# কো-অপ ট্রান্সলেটরে অবদান রাখা

এই প্রকল্পে অবদান এবং পরামর্শ স্বাগত। বেশিরভাগ অবদানের জন্য আপনাকে একটি Contributor License Agreement (CLA) এ সম্মত হতে হবে, যা ঘোষণা করে যে আপনার অবদান ব্যবহারের জন্য আমাদের কাছে যথাযথ অধিকার রয়েছে। বিস্তারিত জানতে https://cla.opensource.microsoft.com দেখুন।

যখন আপনি একটি pull request জমা দেন, একটি CLA বট স্বয়ংক্রিয়ভাবে নির্ধারণ করবে আপনি CLA প্রদান করতে হবে কিনা এবং PR-এ উপযুক্ত চিহ্ন (যেমন, স্ট্যাটাস চেক, মন্তব্য) যোগ করবে। বটের নির্দেশনা অনুসরণ করুন। আমাদের CLA ব্যবহৃত সব রেপোতে আপনাকে একবারই এটি করতে হবে।

## ডেভেলপমেন্ট পরিবেশ সেটআপ

এই প্রকল্পের ডেভেলপমেন্ট পরিবেশ সেটআপের জন্য আমরা Poetry ব্যবহারের পরামর্শ দিই। আমরা `pyproject.toml` ব্যবহার করি প্রকল্পের নির্ভরশীলতা পরিচালনার জন্য, তাই নির্ভরশীলতা ইনস্টল করতে Poetry ব্যবহার করুন।

### ভার্চুয়াল এনভায়রনমেন্ট তৈরি করা

#### pip ব্যবহার করে

```bash
python -m venv .venv
```

#### Poetry ব্যবহার করে

```bash
poetry init
```

### ভার্চুয়াল এনভায়রনমেন্ট সক্রিয় করা

#### pip এবং Poetry উভয়ের জন্য

- উইন্ডোজ:

    ```bash
    .venv\Scripts\activate.bat
    ```

- ম্যাক/লিনাক্স:

    ```bash
    source .venv/bin/activate
    ```

#### Poetry ব্যবহার করে

```bash
poetry shell
```

### প্যাকেজ এবং প্রয়োজনীয় প্যাকেজ ইনস্টল করা

#### Poetry ব্যবহার করে (pyproject.toml থেকে)

```bash
poetry install
```

### ম্যানুয়াল টেস্টিং

PR জমা দেওয়ার আগে, বাস্তব ডকুমেন্টেশনের সাথে অনুবাদ কার্যকারিতা পরীক্ষা করা গুরুত্বপূর্ণ:

1. রুট ডিরেক্টরিতে একটি test ডিরেক্টরি তৈরি করুন:
    ```bash
    mkdir test_docs
    ```

2. অনুবাদ করতে চান এমন কিছু মার্কডাউন ডকুমেন্টেশন এবং ছবি test ডিরেক্টরিতে কপি করুন। উদাহরণস্বরূপ:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. প্যাকেজ লোকালি ইনস্টল করুন:
    ```bash
    pip install -e .
    ```

4. আপনার টেস্ট ডকুমেন্টে Co-op Translator চালান:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. `test_docs/translations` এবং `test_docs/translated_images` এ অনুবাদিত ফাইলগুলো পরীক্ষা করুন:
   - অনুবাদের গুণগত মান
   - মেটাডেটা মন্তব্য সঠিক আছে কিনা
   - মূল মার্কডাউন কাঠামো অক্ষুণ্ণ আছে কিনা
   - লিঙ্ক এবং ছবি সঠিকভাবে কাজ করছে কিনা

এই ম্যানুয়াল টেস্টিং নিশ্চিত করে যে আপনার পরিবর্তনগুলি বাস্তব পরিস্থিতিতে ভালো কাজ করে।

### পরিবেশ ভেরিয়েবল

1. রুট ডিরেক্টরিতে `.env.template` ফাইল থেকে `.env` ফাইল কপি করে তৈরি করুন।
2. নির্দেশনা অনুযায়ী পরিবেশ ভেরিয়েবল পূরণ করুন।

> [!TIP]
>
> ### অতিরিক্ত ডেভেলপমেন্ট পরিবেশ বিকল্প
>
> প্রকল্পটি লোকালি চালানোর পাশাপাশি, বিকল্প ডেভেলপমেন্ট পরিবেশ সেটআপের জন্য GitHub Codespaces বা VS Code Dev Containers ব্যবহার করতে পারেন।
>
> #### GitHub Codespaces
>
> GitHub Codespaces ব্যবহার করে এই স্যাম্পলগুলো ভার্চুয়ালি চালানো যায় এবং অতিরিক্ত সেটআপের প্রয়োজন নেই।
>
> নিচের বোতামটি আপনার ব্রাউজারে একটি ওয়েব-ভিত্তিক VS Code ইনস্ট্যান্স খুলবে:
>
> 1. টেমপ্লেট খুলুন (কিছুক্ষণ সময় লাগতে পারে):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### VS Code Dev Containers ব্যবহার করে লোকালি চালানো
>
> ⚠️ এই বিকল্পটি কাজ করবে যদি আপনার Docker Desktop এ কমপক্ষে ১৬ জিবি RAM বরাদ্দ থাকে। যদি কম থাকে, তাহলে [GitHub Codespaces বিকল্প](../..) ব্যবহার করুন অথবা [লোকালি সেটআপ করুন](../..)।
>
> VS Code Dev Containers ব্যবহার করে প্রকল্পটি আপনার লোকাল VS Code-এ খুলবে, যা [Dev Containers এক্সটেনশন](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers) ব্যবহার করে:
>
> 1. Docker Desktop চালু করুন (যদি না থাকে, ইনস্টল করুন)
> 2. প্রকল্পটি খুলুন:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### কোড স্টাইল

আমরা প্রকল্পে সঙ্গতিপূর্ণ কোড স্টাইল বজায় রাখতে Python কোড ফরম্যাটার হিসেবে [Black](https://github.com/psf/black) ব্যবহার করি। Black একটি কঠোর কোড ফরম্যাটার যা স্বয়ংক্রিয়ভাবে Python কোডকে Black কোড স্টাইল অনুসারে পুনরায় ফরম্যাট করে।

#### কনফিগারেশন

Black এর কনফিগারেশন আমাদের `pyproject.toml` এ উল্লেখ আছে:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Black ইনস্টল করা

Poetry (সুপারিশকৃত) অথবা pip ব্যবহার করে Black ইনস্টল করতে পারেন:

##### Poetry ব্যবহার করে

ডেভেলপমেন্ট পরিবেশ সেটআপ করার সময় Black স্বয়ংক্রিয়ভাবে ইনস্টল হয়:
```bash
poetry install
```

##### pip ব্যবহার করে

pip ব্যবহার করলে সরাসরি Black ইনস্টল করতে পারেন:
```bash
pip install black
```

#### Black ব্যবহার করা

##### Poetry সহ

1. প্রকল্পের সব Python ফাইল ফরম্যাট করুন:
    ```bash
    poetry run black .
    ```

2. নির্দিষ্ট ফাইল বা ডিরেক্টরি ফরম্যাট করুন:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### pip সহ

1. প্রকল্পের সব Python ফাইল ফরম্যাট করুন:
    ```bash
    black .
    ```

2. নির্দিষ্ট ফাইল বা ডিরেক্টরি ফরম্যাট করুন:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> আমরা পরামর্শ দিই আপনার এডিটরকে Black দিয়ে কোড স্বয়ংক্রিয়ভাবে ফরম্যাট করতে সেটআপ করুন। অধিকাংশ আধুনিক এডিটর এক্সটেনশন বা প্লাগইন এর মাধ্যমে এটি সমর্থন করে।

## Co-op Translator চালানো

আপনার পরিবেশে Poetry ব্যবহার করে Co-op Translator চালাতে নিচের ধাপগুলো অনুসরণ করুন:

1. সেই ডিরেক্টরিতে যান যেখানে আপনি অনুবাদ পরীক্ষা করতে চান অথবা পরীক্ষার জন্য একটি অস্থায়ী ফোল্ডার তৈরি করুন।

2. নিচের কমান্ডটি চালান। `-l ko` এর পরিবর্তে আপনি যে ভাষায় অনুবাদ করতে চান তার ভাষা কোড দিন। `-d` ফ্ল্যাগটি ডিবাগ মোড নির্দেশ করে।

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> কমান্ড চালানোর আগে নিশ্চিত করুন আপনার Poetry পরিবেশ সক্রিয় আছে (poetry shell)।

## নতুন ভাষা যোগ করুন

আমরা নতুন ভাষার সমর্থন যোগ করার অবদান স্বাগত জানাই। PR খুলার আগে নিচের ধাপগুলো সম্পন্ন করুন যাতে পর্যালোচনা সহজ হয়।

1. ফন্ট ম্যাপিং-এ ভাষা যোগ করুন
   - `src/co_op_translator/fonts/font_language_mappings.yml` সম্পাদনা করুন
   - একটি এন্ট্রি যোগ করুন:
     - `code`: ISO-সদৃশ ভাষা কোড (যেমন, `vi`)
     - `name`: মানুষের জন্য সহজবোধ্য নাম
     - `font`: `src/co_op_translator/fonts/` এ থাকা একটি ফন্ট যা স্ক্রিপ্ট সমর্থন করে
     - `rtl`: ডান থেকে বাম হলে `true`, না হলে `false`

2. প্রয়োজনীয় ফন্ট ফাইল অন্তর্ভুক্ত করুন (যদি প্রয়োজন হয়)
   - নতুন ফন্টের জন্য ওপেন সোর্স বিতরণের লাইসেন্স সামঞ্জস্য যাচাই করুন
   - ফন্ট ফাইল `src/co_op_translator/fonts/` এ যোগ করুন

3. লোকাল যাচাই
   - ছোট একটি নমুনার অনুবাদ চালান (মার্কডাউন, ছবি, নোটবুক প্রযোজ্য)
   - আউটপুট সঠিকভাবে রেন্ডার হচ্ছে কিনা যাচাই করুন, ফন্ট এবং RTL লেআউট সহ

4. ডকুমেন্টেশন আপডেট করুন
   - ভাষাটি `getting_started/supported-languages.md` এ অন্তর্ভুক্ত করুন
   - `getting_started/README_languages_template.md` পরিবর্তন করার দরকার নেই; এটি স্বয়ংক্রিয়ভাবে তৈরি হয়

5. PR খুলুন
   - যোগ করা ভাষা এবং ফন্ট/লাইসেন্স বিষয়ক বিবরণ দিন
   - সম্ভব হলে রেন্ডার হওয়া আউটপুটের স্ক্রিনশট সংযুক্ত করুন

উদাহরণ YAML এন্ট্রি:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### নতুন ভাষা পরীক্ষা করুন

নিচের কমান্ড চালিয়ে নতুন ভাষা পরীক্ষা করতে পারেন:

```bash
# একটি ভার্চুয়াল পরিবেশ তৈরি করুন এবং সক্রিয় করুন
python -m venv .venv
# উইন্ডোজ
.venv\Scripts\activate
# ম্যাকওএস/লিনাক্স
source .venv/bin/activate
# ডেভেলপমেন্ট প্যাকেজ ইনস্টল করুন
pip install -e .
# অনুবাদ চালান
translate -l "new_lang"
```

## রক্ষণাবেক্ষকগণ

### কমিট মেসেজ এবং মার্জ কৌশল

আমাদের প্রকল্পের কমিট ইতিহাসে সঙ্গতি এবং স্পষ্টতা বজায় রাখতে, আমরা **Squash and Merge** কৌশল ব্যবহার করার সময় **চূড়ান্ত কমিট মেসেজের জন্য** একটি নির্দিষ্ট কমিট মেসেজ ফরম্যাট অনুসরণ করি।

যখন একটি pull request (PR) মার্জ হয়, তখন পৃথক কমিটগুলো একত্রিত হয়ে একটি কমিটে পরিণত হয়। চূড়ান্ত কমিট মেসেজ নিচের ফরম্যাট অনুসরণ করবে যাতে ইতিহাস পরিষ্কার থাকে।

#### কমিট মেসেজ ফরম্যাট (squash and merge এর জন্য)

আমরা কমিট মেসেজের জন্য নিচের ফরম্যাট ব্যবহার করি:

```bash
<type>: <description> (#<PR নম্বর>)
```

- **type**: কমিটের শ্রেণীবিভাগ নির্ধারণ করে। আমরা নিম্নলিখিত টাইপ ব্যবহার করি:
  - `Docs`: ডকুমেন্টেশন আপডেটের জন্য।
  - `Build`: বিল্ড সিস্টেম বা নির্ভরশীলতা সম্পর্কিত পরিবর্তনের জন্য, যেমন কনফিগারেশন ফাইল, CI ওয়ার্কফ্লো, বা Dockerfile আপডেট।
  - `Core`: প্রকল্পের মূল কার্যকারিতা বা ফিচার সংশোধনের জন্য, বিশেষ করে `src/co_op_translator/core` ডিরেক্টরির ফাইলগুলোর জন্য।

- **description**: পরিবর্তনের সংক্ষিপ্ত সারাংশ।
- **PR number**: সংশ্লিষ্ট pull request নম্বর।

**উদাহরণ**:

- `Docs: স্পষ্টতার জন্য ইনস্টলেশন নির্দেশনা আপডেট (#50)`
- `Core: ইমেজ অনুবাদের হ্যান্ডলিং উন্নত করা (#60)`

> [!NOTE]
> বর্তমানে, **`Docs`**, **`Core`**, এবং **`Build`** প্রিফিক্সগুলো স্বয়ংক্রিয়ভাবে PR শিরোনামে যোগ হয় সংশ্লিষ্ট সোর্স কোডের লেবেল অনুযায়ী। সঠিক লেবেল থাকলে সাধারণত আপনাকে ম্যানুয়ালি PR শিরোনাম পরিবর্তন করতে হয় না। শুধু যাচাই করুন সব ঠিক আছে এবং প্রিফিক্স সঠিকভাবে তৈরি হয়েছে।

#### মার্জ কৌশল

আমরা pull request-এর জন্য ডিফল্টভাবে **Squash and Merge** কৌশল ব্যবহার করি। এই কৌশল নিশ্চিত করে কমিট মেসেজ আমাদের ফরম্যাট অনুসারে হয়, যদিও পৃথক কমিটগুলো না হয়।

**কারণসমূহ**:

- পরিষ্কার, লিনিয়ার প্রকল্প ইতিহাস।
- কমিট মেসেজে সঙ্গতি।
- ছোটখাটো কমিট থেকে শব্দদূষণ কমানো (যেমন, "fix typo")।

মার্জ করার সময় নিশ্চিত করুন চূড়ান্ত কমিট মেসেজ উপরের ফরম্যাট অনুসরণ করে।

**Squash and Merge এর উদাহরণ**  
যদি একটি PR-এ নিম্নলিখিত কমিট থাকে:

- `fix typo`
- `update README`
- `adjust formatting`

তাহলে এগুলোকে একত্রিত করে হবে:  
`Docs: Improve documentation clarity and formatting (#65)`

### রিলিজ প্রক্রিয়া

এই অংশটি রক্ষণাবেক্ষকদের জন্য Co-op Translator এর নতুন রিলিজ প্রকাশের সহজতম পদ্ধতি বর্ণনা করে।

#### ১. `pyproject.toml` এ ভার্সন বাড়ানো

1. পরবর্তী ভার্সন নম্বর নির্ধারণ করুন (আমরা semantic versioning অনুসরণ করি: `MAJOR.MINOR.PATCH`)।
2. `pyproject.toml` ফাইল সম্পাদনা করে `[tool.poetry]` এর অধীনে `version` ফিল্ড আপডেট করুন।
3. শুধুমাত্র ভার্সন পরিবর্তন (এবং স্বয়ংক্রিয়ভাবে আপডেট হওয়া লক/মেটাডেটা ফাইল, যদি থাকে) সহ একটি ডেডিকেটেড pull request খুলুন।
4. পর্যালোচনার পর, **Squash and Merge** ব্যবহার করুন এবং নিশ্চিত করুন চূড়ান্ত কমিট মেসেজ উপরের ফরম্যাট অনুসরণ করে।

#### ২. GitHub রিলিজ তৈরি করা

1. GitHub রিপোজিটরি পেজে যান এবং **Releases** → **Draft a new release** খুলুন।
2. `main` ব্রাঞ্চ থেকে একটি নতুন ট্যাগ তৈরি করুন (যেমন, `v0.13.0`)।
3. রিলিজ শিরোনাম একই ভার্সন দিন (যেমন, `v0.13.0`)।
4. **Generate release notes** ক্লিক করে চেঞ্জলগ স্বয়ংক্রিয়ভাবে পূরণ করুন।
5. ইচ্ছা করলে টেক্সট সম্পাদনা করুন (যেমন, নতুন সমর্থিত ভাষা বা গুরুত্বপূর্ণ পরিবর্তন হাইলাইট করতে)।
6. রিলিজ প্রকাশ করুন।

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**অস্বীকৃতি**:  
এই নথিটি AI অনুবাদ সেবা [Co-op Translator](https://github.com/Azure/co-op-translator) ব্যবহার করে অনূদিত হয়েছে। আমরা যথাসাধ্য সঠিকতার চেষ্টা করি, তবে স্বয়ংক্রিয় অনুবাদে ত্রুটি বা অসঙ্গতি থাকতে পারে। মূল নথিটি তার নিজস্ব ভাষায়ই কর্তৃত্বপূর্ণ উৎস হিসেবে বিবেচিত হওয়া উচিত। গুরুত্বপূর্ণ তথ্যের জন্য পেশাদার মানব অনুবাদ গ্রহণ করার পরামর্শ দেওয়া হয়। এই অনুবাদের ব্যবহারে সৃষ্ট কোনো ভুল বোঝাবুঝি বা ভুল ব্যাখ্যার জন্য আমরা দায়ী নই।
<!-- CO-OP TRANSLATOR DISCLAIMER END -->