<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T04:00:34+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "bg"
}
-->
# Ръководство за отстраняване на проблеми с Microsoft Co-op Translator

## Общ преглед
Microsoft Co-Op Translator е мощен инструмент за безпроблемен превод на Markdown документи. Това ръководство ще ви помогне да отстраните често срещани проблеми при използването на инструмента.

## Чести проблеми и решения

### 1. Проблем с Markdown таг
**Проблем:** Преведеният Markdown документ съдържа таг `markdown` най-отгоре, което води до проблеми с визуализацията.

**Решение:** За да решите този проблем, просто изтрийте тага `markdown` от началото на файла. Така Markdown файлът ще се визуализира правилно.

**Стъпки:**
1. Отворете преведения Markdown (`.md`) файл.
2. Намерете тага `markdown` най-отгоре на документа.
3. Изтрийте тага `markdown`.
4. Запазете промените във файла.
5. Отворете отново файла, за да се уверите, че се визуализира правилно.

### 2. Проблем с URL на вградените изображения
**Проблем:** URL адресите на вградените изображения не съответстват на езиковата локализация, което води до грешни или липсващи изображения.

**Решение:** Проверете URL адресите на вградените изображения и се уверете, че съвпадат с езиковата локализация. Всички изображения се намират в папката `translated_images`, като всяко изображение има езиков таг в името на файла.

**Стъпки:**
1. Отворете преведения Markdown документ.
2. Идентифицирайте вградените изображения и техните URL адреси.
3. Проверете дали езиковият таг в името на файла на изображението съвпада с езика на документа.
4. При нужда актуализирайте URL адресите.
5. Запазете промените и отворете отново документа, за да се уверите, че изображенията се визуализират правилно.

### 3. Точност на превода
**Проблем:** Преведеният текст не е достатъчно точен или се нуждае от допълнителна редакция.

**Решение:** Прегледайте преведения документ и направете необходимите редакции за по-добра точност и четимост.

**Стъпки:**
1. Отворете преведения документ.
2. Прегледайте внимателно съдържанието.
3. Направете нужните редакции за по-добър превод.
4. Запазете промените.

## 4. Грешка с разрешения (Permission Error Redacted или 404)

Ако изображения или текст не се превеждат на правилния език и при стартиране в -d debug режим получавате грешка 401, това е класически проблем с удостоверяването — или ключът е невалиден, изтекъл, или не е свързан с региона на endpoint-а.

Стартирайте co-op translator с [-d debug switch](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md), за да разберете по-добре причината за проблема.

- **Съобщение за грешка**: `Access denied due to invalid subscription key or wrong API endpoint.`
- **Възможни причини:**
  - Subscription key е скрит или грешен в заявката.
  - AI Services Key или Subscription Key може да принадлежи на друг Azure ресурс (като Translator или OpenAI), вместо на **Azure AI Vision** ресурс.

 **Тип ресурс**
  - Отидете в [Azure Portal](https://portal.azure.com) или [Azure AI Foundry](https://ai.azure.com) и се уверете, че ресурсът е от тип `Azure AI services` → `Vision`.
  - Валидирайте ключовете и се уверете, че използвате правилния ключ.

## 5. Грешки в конфигурацията (Ново обработване на грешки)

С новата система за селективен превод, Co-op Translator вече дава ясни съобщения за грешка, когато необходимите услуги не са конфигурирани.

### 5.1. Azure AI Service не е конфигуриран за превод на изображения

**Проблем:** Заявили сте превод на изображения (флаг `-img`), но Azure AI Service не е конфигуриран правилно.

**Съобщение за грешка:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**Решение:**
1. **Вариант 1**: Конфигурирайте Azure AI Service
   - Добавете `AZURE_AI_SERVICE_API_KEY` във вашия `.env` файл
   - Добавете `AZURE_AI_SERVICE_ENDPOINT` във вашия `.env` файл
   - Проверете дали услугата е достъпна

2. **Вариант 2**: Премахнете заявката за превод на изображения
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### 5.2. Липсваща необходима конфигурация

**Проблем:** Липсва основна LLM конфигурация.

**Съобщение за грешка:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**Решение:**
1. Проверете дали във вашия `.env` файл има поне една от следните LLM конфигурации:
   - **Azure OpenAI**: `AZURE_OPENAI_API_KEY` и `AZURE_OPENAI_ENDPOINT`
   - **OpenAI**: `OPENAI_API_KEY`
   
   Трябва да е конфигуриран или Azure OpenAI, ИЛИ OpenAI, не и двата едновременно.

### 5.3. Объркване със селективния превод

**Проблем:** Нито един файл не е преведен, въпреки че командата е изпълнена успешно.

**Възможни причини:**
- Грешни флагове за тип файлове (`-md`, `-img`, `-nb`)
- Няма съвпадащи файлове в проекта
- Неправилна структура на директориите

**Решение:**
1. **Използвайте debug режим**, за да видите какво се случва:
   ```bash
   translate -l "ko" -md -d
   ```

2. **Проверете типовете файлове** във вашия проект:
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **Потвърдете комбинациите от флагове:**
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## 6. Миграция от старата система

### 6.1. Режим само за Markdown е премахнат

**Проблем:** Команди, които разчитаха на автоматичен fallback само за markdown, вече не работят както преди.

**Старо поведение:**
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

**Ново поведение:**
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

**Решение:**
- **Бъдете конкретни** какво искате да превеждате:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### 6.2. Неочаквано поведение на връзките

**Проблем:** Връзките в преведените файлове водят към неочаквани места.

**Причина:** Динамичната обработка на връзките се променя според избраните типове файлове.

**Решение:**
1. **Разберете новото поведение на връзките:**
   - Включен `-nb`: Връзките към notebook файлове сочат към преведените версии
   - Изключен `-nb`: Връзките към notebook файлове сочат към оригиналните файлове
   - Включен `-img`: Връзките към изображения сочат към преведените версии
   - Изключен `-img`: Връзките към изображения сочат към оригиналните файлове

2. **Изберете правилната комбинация** според вашия случай:
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## 7. GitHub Action е изпълнен, но не е създаден Pull Request (PR)

**Симптом:** В логовете на workflow-а за `peter-evans/create-pull-request` се вижда:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**Вероятни причини:**
- **Няма открити промени:** Стъпката за превод не е създала разлики (репото вече е актуално).
- **Игнорирани изходи:** `.gitignore` изключва файловете, които очаквате да се комитнат (например `*.ipynb`, `translations/`, `translated_images/`).
- **add-paths не съвпада:** Пътищата, подадени към action-а, не съвпадат с реалните изходни локации.
- **Логика/условия на workflow-а:** Стъпката за превод е приключила преждевременно или е писала в неочаквани директории.

**Как да поправите / проверите:**
1. **Потвърдете, че изходите съществуват:** След превода проверете дали в работната директория има нови/променени файлове в `translations/` и/или `translated_images/`.
   - Ако превеждате notebooks, уверете се, че `.ipynb` файловете са записани под `translations/<lang>/...`.
2. **Прегледайте `.gitignore`:** Не игнорирайте генерираните изходи. Уверете се, че НЕ игнорирате:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (ако превеждате notebooks)
3. **Уверете се, че add-paths съвпада с изходите:** Използвайте стойност на няколко реда и включете и двете папки, ако е необходимо:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **Принудително PR за дебъг:** Временно разрешете празни комити, за да потвърдите, че wiring-ът е коректен:
   ```yaml
   with:
     commit-empty: true
   ```
5. **Стартирайте с debug:** Добавете `-d` към командата за превод, за да видите кои файлове са открити и записани.
6. **Разрешения (GITHUB_TOKEN):** Уверете се, че workflow-ът има права за писане за създаване на комити и PR:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```


## Бърз чеклист за дебъг

Когато отстранявате проблеми с превода:

1. **Използвайте debug режим:** Добавете флаг `-d`, за да видите подробни логове
2. **Проверете флаговете:** Уверете се, че `-md`, `-img`, `-nb` съответстват на вашите намерения
3. **Потвърдете конфигурацията:** Проверете дали във вашия `.env` файл има нужните ключове
4. **Тествайте поетапно:** Започнете само с `-md`, после добавяйте други типове
5. **Проверете структурата на файловете:** Уверете се, че изходните файлове съществуват и са достъпни

За повече информация относно наличните команди и флагове, вижте [Command Reference](./command-reference.md).

---

**Отказ от отговорност**:
Този документ е преведен с помощта на AI услуга за превод [Co-op Translator](https://github.com/Azure/co-op-translator). Въпреки че се стремим към точност, имайте предвид, че автоматизираните преводи могат да съдържат грешки или неточности. Оригиналният документ на неговия роден език трябва да се счита за авторитетен източник. За критична информация се препоръчва професионален човешки превод. Не носим отговорност за недоразумения или погрешни тълкувания, произтичащи от използването на този превод.