<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "822238e4451d04bb152cebb1be6f13c2",
  "translation_date": "2025-11-30T12:24:12+00:00",
  "source_file": "getting_started/command-reference.md",
  "language_code": "bg"
}
-->
# Справочник с команди

CLI на **Co-op Translator** предлага няколко опции за персонализиране на процеса на превод:

Команда                                      | Описание
----------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
translate -l "language_codes"                 | Превежда проекта ви на посочените езици. Пример: translate -l "es fr de" превежда на испански, френски и немски. Използвайте translate -l "all" за превод на всички поддържани езици.
translate -l "language_codes" -u              | Актуализира преводите, като изтрива съществуващите и ги създава наново. Внимание: Това ще изтрие всички текущи преводи за посочените езици.
translate -l "language_codes" -img            | Превежда само файлове с изображения.
translate -l "language_codes" -md             | Превежда само Markdown файлове.
translate -l "language_codes" -nb             | Превежда само Jupyter notebook файлове (.ipynb).
translate -l "language_codes" --fix           | Превежда наново файлове с ниски оценки за увереност, базирани на предишни резултати от оценка.
translate -l "language_codes" -d              | Активира debug режим за подробен лог.
translate -l "language_codes" --save-logs, -s | Запазва DEBUG ниво логове във файлове под <root_dir>/logs/ (конзолата остава контролирана от -d)
translate -l "language_codes" -r "root_dir"   | Задава коренната директория на проекта
translate -l "language_codes" -f              | Използва бърз режим за превод на изображения (до 3 пъти по-бързо, с лек компромис в качеството и подравняването).
translate -l "language_codes" -y              | Автоматично потвърждава всички подкани (полезно за CI/CD процеси)
translate -l "language_codes" --add-disclaimer/--no-disclaimer | Включва или изключва добавянето на секция с отказ от отговорност за машинен превод в преведените markdown и notebooks (по подразбиране: включено).
translate -l "language_codes" --help          | показва помощ с наличните команди в CLI
evaluate -l "language_code"                  | Оценява качеството на превода за конкретен език и предоставя оценки за увереност
evaluate -l "language_code" -c 0.8           | Оценява преводите с персонализиран праг на увереност
evaluate -l "language_code" -f               | Бърз режим на оценка (само на базата на правила, без LLM)
evaluate -l "language_code" -D               | Дълбок режим на оценка (само с LLM, по-задълбочен, но по-бавен)
evaluate -l "language_code" --save-logs, -s  | Запазва DEBUG ниво логове във файлове под <root_dir>/logs/
migrate-links -l "language_codes"             | Преработва преведените Markdown файлове, за да обнови линковете към notebooks (.ipynb). Предпочита преведените notebooks, когато са налични; в противен случай може да използва оригиналните notebooks.
migrate-links -l "language_codes" -r          | Задава коренната директория на проекта (по подразбиране: текущата директория).
migrate-links -l "language_codes" --dry-run   | Показва кои файлове биха се променили, без да записва промени.
migrate-links -l "language_codes" --no-fallback-to-original | Не пренаписва линкове към оригинални notebooks, когато липсват преведени версии (актуализира само ако преводът съществува).
migrate-links -l "language_codes" -d          | Активира debug режим за подробен лог.
migrate-links -l "language_codes" --save-logs, -s | Запазва DEBUG ниво логове във файлове под <root_dir>/logs/
migrate-links -l "all" -y                      | Обработва всички езици и автоматично потвърждава предупреждението.

## Примери за използване

  1. По подразбиране (добавя нови преводи без да изтрива съществуващите):   translate -l "ko"    translate -l "es fr de" -r "./my_project"

  2. Добавя само нови преводи на корейски за изображения (без изтриване на съществуващи преводи):    translate -l "ko" -img

  3. Актуализира всички корейски преводи (Внимание: Изтрива всички съществуващи корейски преводи преди повторен превод):    translate -l "ko" -u

  4. Актуализира само корейските изображения (Внимание: Изтрива всички съществуващи корейски изображения преди повторен превод):    translate -l "ko" -img -u

  5. Добавя нови markdown преводи за корейски без да засяга други преводи:    translate -l "ko" -md

  6. Поправя преводи с ниска увереност на база предишни оценки: translate -l "ko" --fix

  7. Поправя преводи с ниска увереност само за конкретни файлове (markdown): translate -l "ko" --fix -md

  8. Поправя преводи с ниска увереност само за конкретни файлове (изображения): translate -l "ko" --fix -img

  9. Използва бърз режим за превод на изображения:    translate -l "ko" -img -f

  10. Поправя преводи с ниска увереност с персонализиран праг: translate -l "ko" --fix -c 0.8

  11. Пример за debug режим: - translate -l "ko" -d: Активира debug логване.
  12. Запазва логове във файлове: translate -l "ko" -s
  13. DEBUG в конзолата и във файлове: translate -l "ko" -d -s
  14. Превежда без да добавя отказ от отговорност за машинен превод: translate -l "ko" --no-disclaimer

  15. Мигрира линкове към notebooks за корейски преводи (актуализира линковете към преведени notebooks, когато са налични):    migrate-links -l "ko"

  15. Мигрира линкове с dry-run (без запис на файлове):    migrate-links -l "ko" --dry-run

  16. Актуализира линкове само когато има преведени notebooks (без връщане към оригиналните):    migrate-links -l "ko" --no-fallback-to-original

  17. Обработва всички езици с подкана за потвърждение:    migrate-links -l "all"

  18. Обработва всички езици и автоматично потвърждава:    migrate-links -l "all" -y
  19. Запазва логове във файлове за migrate-links:    migrate-links -l "ko ja" -s

### Примери за оценка

> [!WARNING]  
> **Бета функция**: Функционалността за оценка е в бета версия. Тази функция беше пусната за оценка на преведените документи, като методите за оценка и детайлната реализация все още се разработват и могат да се променят.

  1. Оценява корейските преводи: evaluate -l "ko"

  2. Оценява с персонализиран праг на увереност: evaluate -l "ko" -c 0.8

  3. Бърза оценка (само на базата на правила): evaluate -l "ko" -f

  4. Дълбока оценка (само с LLM): evaluate -l "ko" -D

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Отказ от отговорност**:
Този документ е преведен с помощта на AI преводаческа услуга [Co-op Translator](https://github.com/Azure/co-op-translator). Въпреки че се стремим към точност, моля, имайте предвид, че автоматизираните преводи могат да съдържат грешки или неточности. Оригиналният документ на неговия роден език трябва да се счита за авторитетен източник. За критична информация се препоръчва професионален човешки превод. Ние не носим отговорност за каквито и да е недоразумения или неправилни тълкувания, произтичащи от използването на този превод.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->