<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T04:01:02+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "bg"
}
-->
# Преведете своя проект с Co-op Translator

**Co-op Translator** е инструмент с команден ред (CLI), който ви помага да превеждате markdown и изображения във вашия проект на множество езици. Този раздел обяснява как да използвате инструмента, разглежда различните CLI опции и дава примери за различни сценарии.

> [!NOTE]
> За пълен списък с команди и подробни описания, вижте [Command reference](./command-reference.md).

---

## Примерни сценарии и команди

Ето няколко често срещани случая на използване на **Co-op Translator** и подходящите команди за тях.

### 1. Основен превод (един език)

За да преведете целия си проект (markdown файлове и изображения) на един език, например корейски, използвайте следната команда:

```bash
translate -l "ko"
```

Тази команда ще преведе всички markdown и изображения на корейски, като добави новите преводи, без да изтрива съществуващите.

> [!TIP]
>
> Искате да видите кои езикови кодове са налични в **Co-op Translator**? Посетете секцията [Supported Languages](https://github.com/Azure/co-op-translator#supported-languages) в хранилището за повече информация.

#### Пример с Phi-3 CookBook

В **Phi-3 CookBook** използвах следния метод, за да добавя корейски превод на съществуващите markdown файлове и изображения.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. Превод на няколко езика

За да преведете проекта си на няколко езика (например испански, френски и немски), използвайте тази команда:

```bash
translate -l "es fr de"
```

Тази команда ще преведе проекта на испански, френски и немски, като добави новите преводи, без да презаписва съществуващите.

#### Пример с Phi-3 CookBook

В **Phi-3 CookBook**, след като изтеглих последните промени, за да отразя най-новите комити, използвах следния метод, за да преведа новодобавените markdown файлове и изображения.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

> [!NOTE]
> Обикновено се препоръчва да се превежда по един език наведнъж, но в ситуации като тази, когато трябва да се добавят конкретни промени, преводът на няколко езика едновременно може да е по-ефективен.

### 3. Актуализиране на преводи (изтрива съществуващите преводи)

За да актуализирате съществуващите преводи (т.е. да изтриете текущите преводи и да ги замените с нови), използвайте опцията `-u`. Това ще изтрие всички съществуващи преводи за избраните езици и ще ги преведе отново.

```bash
translate -l "ko" -u
```

Внимание: Тази команда ще ви поиска потвърждение, преди да изтрие съществуващите преводи.

#### Пример с Phi-3 CookBook

В **Phi-3 CookBook** използвах следния метод, за да актуализирам всички преведени файлове на испански. Препоръчвам този метод, когато има значителни промени в оригиналното съдържание в няколко markdown документа. Ако има само няколко преведени markdown файла за обновяване, по-ефективно е ръчно да изтриете тези конкретни файлове и след това да използвате метода `-a`, за да добавите обновените преводи.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. Превод само на изображения

За да преведете само изображенията във вашия проект, използвайте опцията `-img`:

```bash
translate -l "ko" -img
```

Тази команда ще преведе само изображенията на корейски, без да засяга markdown файловете.

### 6. Превод само на Markdown файлове

За да преведете само markdown файловете във вашия проект, използвайте опцията `-md`:

```bash
translate -l "ko" -md
```

#### Пример с Phi-3 CookBook

В **Phi-3 CookBook** използвах следния метод, за да проверя за грешки в превода на корейските файлове и автоматично да опитам отново превода на файловете с открити проблеми.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

Тази опция проверява за грешки в превода. В момента, ако разликата в броя на празните редове между оригиналния и преведения файл е повече от шест, файлът се отбелязва като с грешка в превода. Планирам да подобря този критерий за по-голяма гъвкавост в бъдеще.

Например, този метод е полезен за откриване на липсващи части или повредени преводи и автоматично ще опита отново превода на тези файлове.

Ако обаче вече знаете кои файлове са проблемни, по-ефективно е ръчно да изтриете тези файлове и да използвате опцията `-a`, за да ги преведете отново.

### 8. Режим за отстраняване на грешки (Debug Mode)

За да активирате подробно логване за диагностика, използвайте опцията `-d`:

```bash
translate -l "ko" -d
```

Тази команда ще стартира превода в режим за отстраняване на грешки, като предоставя допълнителна информация, която може да ви помогне да откриете проблеми по време на процеса на превод.

#### Пример с Phi-3 CookBook

В **Phi-3 CookBook** се сблъсках с проблем, при който преводите с много връзки в markdown файловете водеха до грешки във форматирането, като счупени преводи и игнорирани празни редове. За да диагностицирам този проблем, използвах опцията `-d`, за да видя как протича процесът на превод.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. Превод на всички езици

Ако искате да преведете проекта на всички поддържани езици, използвайте ключовата дума all.

> [!WARNING]
> Преводът на всички езици наведнъж може да отнеме значително време в зависимост от размера на проекта. Например, преводът на **Phi-3 CookBook** на испански отне около 2 часа. С оглед на мащаба, не е практично един човек да обработва 20 езика. Препоръчва се работата да се раздели между няколко сътрудници, всеки от които да отговаря за един или два езика, и преводите да се обновяват постепенно.

```bash
translate -l "all"
```

Тази команда ще преведе проекта на всички налични езици. Ако продължите, преводът може да отнеме значително време в зависимост от размера на проекта.

> [!TIP]
>
> ### Ръчно изтриване на преведени файлове (по избор)
> Преведените файлове вече се откриват и почистват автоматично, когато изходният файл се обнови.
>
> Ако обаче искате ръчно да обновите превод – например, за да преведете отново конкретен файл или да замените поведението на системата – можете да използвате следната команда, за да изтриете всички версии на файла във всички езикови папки.
>
> ### В Windows:
> 1. **С Command Prompt**:
>    - Отворете Command Prompt.
>    - Отидете до папката, където се намират файловете, с командата `cd`.
>    - Използвайте следната команда, за да изтриете файловете:
>      ```
>      del /s *filename*
>      ```
>      Заменете `filename` с конкретната част от името на файла, която търсите. Опцията `/s` търси и в подпапките.
>
> 2. **С PowerShell**:
>    - Отворете PowerShell.
>    - Стартирайте тази команда:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
>      Заменете `"C:\YourPath"` с пътя до папката и `filename` с конкретното име.
>
> ### В macOS/Linux:
> 1. **С Terminal**:
>   - Отворете Terminal.
>   - Отидете до директорията с `cd`.
>   - Използвайте командата `find`:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
>     Заменете `filename` с конкретното име.
>
> Винаги проверявайте внимателно файловете, преди да ги изтриете, за да избегнете случайна загуба.
>
> След като изтриете файловете, които трябва да бъдат заменени, просто стартирайте отново командата си `translate -l`, за да обновите последните промени по файловете.

---

**Отказ от отговорност**:
Този документ е преведен с помощта на AI услуга за превод [Co-op Translator](https://github.com/Azure/co-op-translator). Въпреки че се стремим към точност, имайте предвид, че автоматизираните преводи могат да съдържат грешки или неточности. Оригиналният документ на неговия роден език трябва да се счита за авторитетен източник. За критична информация се препоръчва професионален човешки превод. Не носим отговорност за недоразумения или погрешни тълкувания, възникнали от използването на този превод.