<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T04:00:55+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "bg"
}
-->
# Инсталиране на пакета Co-op Translator

**Co-op Translator** е инструмент с команден ред (CLI), създаден да ви помогне да превеждате всички markdown файлове и изображения във вашия проект на различни езици. Този урок ще ви покаже как да конфигурирате преводача и да го използвате в различни ситуации.

### Създаване на виртуална среда

Можете да създадете виртуална среда с помощта на `pip` или `Poetry`. Въведете една от следните команди в терминала си.

#### С pip

```bash
python -m venv .venv
```

#### С Poetry

```bash
poetry init
```

### Активиране на виртуалната среда

След като създадете виртуалната среда, трябва да я активирате. Стъпките са различни според операционната система. Въведете следната команда в терминала си.

#### За pip и Poetry

- Windows:

    ```bash
    .venv\Scripts\activate
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### С Poetry

1. Ако сте създали средата с Poetry, въведете следната команда в терминала си, за да я активирате.

    ```bash
    poetry shell
    ```

### Инсталиране на пакета и необходимите зависимости

След като виртуалната среда е създадена и активирана, следващата стъпка е да инсталирате нужните зависимости.

### Бърза инсталация

Инсталирайте Co-Op Translator чрез pip

```
pip install co-op-translator
```
Или

Инсталирайте чрез poetry
```
poetry add co-op-translator
```

#### С pip (от requirements.txt), ако клонирате това репо

> [!NOTE]
> Моля, НЕ правете това, ако инсталирате co-op translator чрез бързата инсталация.

1. Ако използвате pip, въведете следната команда в терминала си. Тя автоматично ще инсталира необходимите пакети, посочени във файла `requirements.txt`:

    ```bash
    pip install -r requirements.txt
    ```

#### С Poetry (от pyproject.toml)

1. Ако използвате Poetry, въведете следната команда в терминала си. Тя автоматично ще инсталира необходимите пакети, посочени във файла `pyproject.toml`:

    ```bash
    poetry install
    ```

---

**Отказ от отговорност**:
Този документ е преведен с помощта на AI услуга за превод [Co-op Translator](https://github.com/Azure/co-op-translator). Въпреки че се стремим към точност, имайте предвид, че автоматизираните преводи могат да съдържат грешки или неточности. Оригиналният документ на неговия роден език трябва да се счита за авторитетен източник. За критична информация се препоръчва професионален човешки превод. Не носим отговорност за недоразумения или погрешни тълкувания, възникнали в резултат на използването на този превод.