<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T12:22:39+00:00",
  "source_file": "README.md",
  "language_code": "bg"
}
-->
# Co-op Translator

_Лесно автоматизирайте превода на вашето образователно съдържание в GitHub на множество езици, за да достигнете до глобална аудитория._

[![Python package](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![License: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![Downloads](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![Downloads](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![Container: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![GitHub contributors](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![GitHub issues](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![GitHub pull-requests](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 Поддръжка на множество езици

#### Поддържано от [Co-op Translator](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[Арабски](../ar/README.md) | [Бенгалски](../bn/README.md) | [Български](./README.md) | [Бирмански (Мианмар)](../my/README.md) | [Китайски (опростен)](../zh/README.md) | [Китайски (традиционен, Хонконг)](../hk/README.md) | [Китайски (традиционен, Макао)](../mo/README.md) | [Китайски (традиционен, Тайван)](../tw/README.md) | [Хърватски](../hr/README.md) | [Чешки](../cs/README.md) | [Датски](../da/README.md) | [Холандски](../nl/README.md) | [Естонски](../et/README.md) | [Фински](../fi/README.md) | [Френски](../fr/README.md) | [Немски](../de/README.md) | [Гръцки](../el/README.md) | [Иврит](../he/README.md) | [Хинди](../hi/README.md) | [Унгарски](../hu/README.md) | [Индонезийски](../id/README.md) | [Италиански](../it/README.md) | [Японски](../ja/README.md) | [Каннада](../kn/README.md) | [Корейски](../ko/README.md) | [Литовски](../lt/README.md) | [Малайски](../ms/README.md) | [Малаялам](../ml/README.md) | [Маратхи](../mr/README.md) | [Непалски](../ne/README.md) | [Нигерийски пиджин](../pcm/README.md) | [Норвежки](../no/README.md) | [Персийски (фарси)](../fa/README.md) | [Полски](../pl/README.md) | [Португалски (Бразилия)](../br/README.md) | [Португалски (Португалия)](../pt/README.md) | [Пенджабски (Гурмукхи)](../pa/README.md) | [Румънски](../ro/README.md) | [Руски](../ru/README.md) | [Сръбски (кирилица)](../sr/README.md) | [Словашки](../sk/README.md) | [Словенски](../sl/README.md) | [Испански](../es/README.md) | [Суахили](../sw/README.md) | [Шведски](../sv/README.md) | [Тагалог (филипински)](../tl/README.md) | [Тамилски](../ta/README.md) | [Телугу](../te/README.md) | [Тайски](../th/README.md) | [Турски](../tr/README.md) | [Украински](../uk/README.md) | [Урду](../ur/README.md) | [Виетнамски](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![GitHub watchers](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![GitHub forks](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![GitHub stars](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![Open in GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## Преглед

**Co-op Translator** ви помага лесно да локализирате вашето образователно съдържание в GitHub на множество езици.
Когато обновявате Markdown файлове, изображения или тетрадки, преводите се синхронизират автоматично, гарантирайки, че съдържанието ви остава точно и актуално за учащи по целия свят.

Пример за организация на преведеното съдържание:

![Example](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.bg.png)

## Бърз старт

```bash
# Създайте и активирайте виртуална среда (препоръчително)
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Инсталирайте пакета
pip install co-op-translator
# Преведи
translate -l "ko ja fr" -md
```

Docker:

```bash
# Изтеглете публичното изображение от GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# Стартирайте с монтирана текуща папка и предоставен .env (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## Минимална настройка

1. Създайте файл `.env` по шаблона: [.env.template](../../.env.template)
2. Конфигурирайте един доставчик на LLM (Azure OpenAI или OpenAI)
3. (По избор) За превод на изображения (`-img`), конфигурирайте Azure AI Vision
4. (Препоръчително) Почистете предишни преводи, за да избегнете конфликти (например `translations/`)
5. (Препоръчително) Добавете секция за превод в README с помощта на [README languages template](./getting_started/README_languages_template.md)
6. Вижте: [Настройка на Azure AI](./getting_started/set-up-azure-ai.md)

## Използване

Преведете всички поддържани типове:

```bash
translate -l "ko ja"
```

Само Markdown:

```bash
translate -l "de" -md
```

Markdown + изображения:

```bash
translate -l "pt" -md -img
```

Само тетрадки:

```bash
translate -l "zh" -nb
```

Още опции: [Команден справочник](./getting_started/command-reference.md)

## Функции

- Автоматизиран превод на Markdown, тетрадки и изображения
- Поддържа преводите синхронизирани с промените в изходния материал
- Работи локално (CLI) или в CI (GitHub Actions)
- Използва Azure OpenAI или OpenAI; по избор Azure AI Vision за изображения
- Запазва форматирането и структурата на Markdown

## Документация

- [Ръководство за командния ред](./getting_started/command-line-guide/command-line-guide.md)
- [Ръководство за GitHub Actions (публични хранилища и стандартни тайни)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [Ръководство за GitHub Actions (хранилища на Microsoft организация и настройки на ниво организация)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [Шаблон за езици в README](./getting_started/README_languages_template.md)
- [Поддържани езици](./getting_started/supported-languages.md)
- [Принос](./CONTRIBUTING.md)
- [Отстраняване на проблеми](./getting_started/troubleshooting.md)

### Ръководство, специфично за Microsoft
> [!NOTE]
> Само за поддържащите хранилищата „За начинаещи“ на Microsoft.

- [Актуализиране на списъка с „други курсове“ (само за хранилищата на MS Beginners)](./getting_started/update-other-courses.md)

## Подкрепете ни и насърчете глобалното обучение

Присъединете се към нас в революцията на споделянето на образователно съдържание по целия свят! Дайте ⭐ на [Co-op Translator](https://github.com/azure/co-op-translator) в GitHub и подкрепете нашата мисия да премахнем езиковите бариери в обучението и технологиите. Вашият интерес и принос имат голямо значение! Винаги са добре дошли кодови приноси и предложения за нови функции.

### Разгледайте образователното съдържание на Microsoft на вашия език

- [AZD за начинаещи](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI за начинаещи](https://github.com/microsoft/edgeai-for-beginners)
- [Model Context Protocol (MCP) за начинаещи](https://github.com/microsoft/mcp-for-beginners)
- [AI агенти за начинаещи](https://github.com/microsoft/ai-agents-for-beginners)
- [Генеративен AI за начинаещи с .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [Генеративен AI за начинаещи](https://github.com/microsoft/generative-ai-for-beginners)
- [Генеративен AI за начинаещи с Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [ML за начинаещи](https://aka.ms/ml-beginners)
- [Data Science за начинаещи](https://aka.ms/datascience-beginners)
- [AI за начинаещи](https://aka.ms/ai-beginners)
- [Киберсигурност за начинаещи](https://github.com/microsoft/Security-101)
- [Уеб разработка за начинаещи](https://aka.ms/webdev-beginners)
- [IoT за начинаещи](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## Видео презентации

👉 Кликнете върху изображението по-долу, за да гледате в YouTube.

- **Open at Microsoft**: Кратко 18-минутно въведение и бързо ръководство за използване на Co-op Translator.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.bg.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## Принос

Този проект приема приноси и предложения. Искате ли да допринесете за Azure Co-op Translator? Моля, вижте нашия [CONTRIBUTING.md](./CONTRIBUTING.md) за насоки как можете да помогнете да направим Co-op Translator по-достъпен.

## Приносители

[![co-op-translator contributors](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## Кодекс на поведение

Този проект е приел [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
За повече информация вижте [Често задавани въпроси за Кодекса на поведение](https://opensource.microsoft.com/codeofconduct/faq/) или
се свържете с [opencode@microsoft.com](mailto:opencode@microsoft.com) при допълнителни въпроси или коментари.

## Отговорен AI

Microsoft се ангажира да помага на клиентите си да използват нашите AI продукти отговорно, споделяйки наученото и изграждайки партньорства, базирани на доверие, чрез инструменти като Transparency Notes и Impact Assessments. Много от тези ресурси са достъпни на [https://aka.ms/RAI](https://aka.ms/RAI).
Подходът на Microsoft към отговорния AI се основава на нашите принципи за справедливост, надеждност и безопасност, поверителност и сигурност, приобщаване, прозрачност и отчетност.

Големи модели за естествен език, изображения и реч – като тези, използвани в този пример – могат потенциално да се държат по начини, които са несправедливи, ненадеждни или обидни, причинявайки вреди. Моля, консултирайте се с [Transparency note на Azure OpenAI service](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text), за да се информирате за рисковете и ограниченията.
Препоръчителният подход за намаляване на тези рискове е да включите система за безопасност във вашата архитектура, която може да открива и предотвратява вредно поведение. [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) предоставя независим слой защита, способен да открива вредно съдържание, генерирано от потребители и от AI, в приложения и услуги. Azure AI Content Safety включва текстови и графични API-та, които ви позволяват да откривате вредни материали. Имаме и интерактивно Content Safety Studio, което ви позволява да разглеждате, изследвате и изпробвате примерен код за откриване на вредно съдържание в различни модалности. Следващата [документация за бърз старт](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) ви води през процеса на изпращане на заявки към услугата.

Друг аспект, който трябва да се вземе предвид, е цялостната производителност на приложението. При мултимодални и мултимоделни приложения, под производителност разбираме, че системата работи според очакванията на вас и вашите потребители, включително да не генерира вредни резултати. Важно е да оцените производителността на цялото си приложение, използвайки [метрики за качество на генериране и рискове и безопасност](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in).

Можете да оцените вашето AI приложение в средата за разработка, използвайки [prompt flow SDK](https://microsoft.github.io/promptflow/index.html). Като предоставите тестов набор от данни или цел, генерираните от вашето генеративно AI приложение резултати се измерват количествено с вградени оценители или с персонализирани оценители по ваш избор. За да започнете с prompt flow sdk за оценка на вашата система, можете да следвате [ръководството за бърз старт](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk). След като изпълните оценъчен цикъл, можете да [визуализирате резултатите в Azure AI Studio](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results).

## Търговски марки

Този проект може да съдържа търговски марки или лога на проекти, продукти или услуги. Употребата на търговски марки или лога на Microsoft е разрешена само при спазване на [Правилата за търговски марки и бранд на Microsoft](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general). Използването на търговски марки или лога на Microsoft в модифицирани версии на този проект не трябва да създава объркване или да предполага спонсорство от Microsoft. Всяко използване на търговски марки или лога на трети страни подлежи на правилата на съответните трети страни.

## Получаване на помощ

Ако се затрудните или имате въпроси относно създаването на AI приложения, присъединете се към:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

Ако имате обратна връзка за продукта или срещнете грешки по време на разработка, посетете:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Отказ от отговорност**:
Този документ е преведен с помощта на AI преводаческа услуга [Co-op Translator](https://github.com/Azure/co-op-translator). Въпреки че се стремим към точност, моля, имайте предвид, че автоматизираните преводи могат да съдържат грешки или неточности. Оригиналният документ на неговия роден език трябва да се счита за авторитетен източник. За критична информация се препоръчва професионален човешки превод. Ние не носим отговорност за каквито и да е недоразумения или неправилни тълкувания, произтичащи от използването на този превод.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->