<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T12:21:45+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "bg"
}
-->
# Принос към Co-op Translator

Този проект приема приноси и предложения. Повечето приноси изискват да се съгласите с
Договор за лицензиране на приносители (CLA), който декларира, че имате правото и наистина предоставяте
правата ни да използваме вашия принос. За подробности посетете https://cla.opensource.microsoft.com.

Когато изпратите pull request, CLA бот автоматично ще определи дали трябва да предоставите
CLA и ще маркира PR съответно (например, проверка на статус, коментар). Просто следвайте инструкциите,
предоставени от бота. Това трябва да направите само веднъж за всички репозитории, използващи нашия CLA.

## Настройка на средата за разработка

За настройка на средата за разработка на този проект препоръчваме да използвате Poetry за управление на зависимости. Използваме `pyproject.toml` за управление на зависимостите на проекта, затова за инсталиране на зависимости трябва да използвате Poetry.

### Създаване на виртуална среда

#### Използване на pip

```bash
python -m venv .venv
```

#### Използване на Poetry

```bash
poetry init
```

### Активиране на виртуалната среда

#### За pip и Poetry

- Windows:

    ```bash
    .venv\Scripts\activate.bat
    ```

- Mac/Linux:

    ```bash
    source .venv/bin/activate
    ```

#### Използване на Poetry

```bash
poetry shell
```

### Инсталиране на пакета и необходимите пакети

#### Използване на Poetry (от pyproject.toml)

```bash
poetry install
```

### Ръчно тестване

Преди да изпратите PR, е важно да тествате функционалността за превод с реална документация:

1. Създайте тестова директория в главната директория:
    ```bash
    mkdir test_docs
    ```

2. Копирайте някаква markdown документация и изображения, които искате да преведете, в тестовата директория. Например:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. Инсталирайте пакета локално:
    ```bash
    pip install -e .
    ```

4. Стартирайте Co-op Translator върху тестовите документи:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. Проверете преведените файлове в `test_docs/translations` и `test_docs/translated_images`, за да се уверите:
   - Качеството на превода
   - Метаданните в коментарите са правилни
   - Оригиналната markdown структура е запазена
   - Връзките и изображенията работят коректно

Това ръчно тестване помага да се гарантира, че промените ви работят добре в реални ситуации.

### Променливи на средата

1. Създайте `.env` файл в главната директория, като копирате предоставения `.env.template` файл.
2. Попълнете променливите на средата според указанията.

> [!TIP]
>
> ### Допълнителни опции за среда за разработка
>
> Освен да стартирате проекта локално, можете да използвате GitHub Codespaces или VS Code Dev Containers за алтернативна настройка на средата за разработка.
>
> #### GitHub Codespaces
>
> Можете да стартирате тези примери виртуално чрез GitHub Codespaces без допълнителни настройки.
>
> Бутонът ще отвори уеб-базирана инстанция на VS Code в браузъра ви:
>
> 1. Отворете шаблона (може да отнеме няколко минути):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### Стартиране локално с VS Code Dev Containers
>
> ⚠️ Тази опция работи само ако Docker Desktop има поне 16 GB RAM. Ако имате по-малко от 16 GB RAM, можете да опитате [GitHub Codespaces](../..) или [да настроите локално](../..).
>
> Свързана опция е VS Code Dev Containers, която отваря проекта във вашия локален VS Code с помощта на [Dev Containers разширението](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers):
>
> 1. Стартирайте Docker Desktop (инсталирайте го, ако не е инсталиран)
> 2. Отворете проекта:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### Стил на кода

Използваме [Black](https://github.com/psf/black) като форматиращ инструмент за Python код, за да поддържаме последователен стил в целия проект. Black е безкомпромисен форматиращ инструмент, който автоматично преформатира Python кода, за да съответства на стила на Black.

#### Конфигурация

Конфигурацията на Black е зададена в нашия `pyproject.toml`:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### Инсталиране на Black

Можете да инсталирате Black чрез Poetry (препоръчително) или pip:

##### Използване на Poetry

Black се инсталира автоматично при настройка на средата за разработка:
```bash
poetry install
```

##### Използване на pip

Ако използвате pip, можете да инсталирате Black директно:
```bash
pip install black
```

#### Използване на Black

##### С Poetry

1. Форматирайте всички Python файлове в проекта:
    ```bash
    poetry run black .
    ```

2. Форматирайте конкретен файл или директория:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### С pip

1. Форматирайте всички Python файлове в проекта:
    ```bash
    black .
    ```

2. Форматирайте конкретен файл или директория:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> Препоръчваме да настроите редактора си да форматира автоматично с Black при запис. Повечето съвременни редактори поддържат това чрез разширения или плъгини.

## Стартиране на Co-op Translator

За да стартирате Co-op Translator с Poetry във вашата среда, следвайте тези стъпки:

1. Отидете в директорията, където искате да тествате преводи, или създайте временна папка за тестове.

2. Изпълнете следната команда. Заменете `-l ko` с кода на езика, на който искате да превеждате. Флагът `-d` указва режим на отстраняване на грешки.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> Уверете се, че вашата Poetry среда е активирана (poetry shell) преди да стартирате командата.

## Принос за нов език

Приемаме приноси, които добавят поддръжка за нови езици. Преди да отворите PR, моля, изпълнете следните стъпки, за да осигурите гладко преглеждане.

1. Добавете езика в картата на шрифтовете
   - Редактирайте `src/co_op_translator/fonts/font_language_mappings.yml`
   - Добавете запис с:
     - `code`: ISO-подобен езиков код (например `vi`)
     - `name`: Човеко-приятелско име за показване
     - `font`: Шрифт, включен в `src/co_op_translator/fonts/`, който поддържа писмото
     - `rtl`: `true`, ако е отдясно наляво, иначе `false`

2. Включете необходимите файлове на шрифтове (ако е нужно)
   - Ако е необходим нов шрифт, проверете съвместимостта на лиценза за отворен код
   - Добавете файла на шрифта в `src/co_op_translator/fonts/`

3. Локална проверка
   - Стартирайте преводи за малък пример (Markdown, изображения и бележници, ако е приложимо)
   - Проверете дали изходът се визуализира правилно, включително шрифтове и евентуално оформление за RTL

4. Актуализирайте документацията
   - Уверете се, че езикът се появява в `getting_started/supported-languages.md`
   - Не е необходимо да променяте `getting_started/README_languages_template.md`; той се генерира от списъка с поддържани езици

5. Отворете PR
   - Опишете добавения език и евентуални съображения за шрифтове/лицензи
   - Прикачете екранни снимки на визуализирания изход, ако е възможно

Примерен YAML запис:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### Тествайте новия език

Можете да тествате новия език, като изпълните следната команда:

```bash
# Създайте и активирайте виртуална среда
python -m venv .venv
# Windows
.venv\Scripts\activate
# macOS/Linux
source .venv/bin/activate
# Инсталирайте пакета за разработка
pip install -e .
# Стартирайте превода
translate -l "new_lang"
```

## Поддържащи

### Формат на съобщението за комит и стратегия за сливане

За да осигурим последователност и яснота в историята на комитите на проекта, следваме специфичен формат на съобщението за комит **за финалното съобщение** при използване на стратегията **Squash and Merge**.

Когато pull request (PR) се слива, отделните комити се обединяват в един комит. Финалното съобщение трябва да следва формата по-долу, за да поддържа чиста и последователна история.

#### Формат на съобщението за комит (за squash and merge)

Използваме следния формат за съобщенията:

```bash
<type>: <description> (#<номер на PR>)
```

- **type**: Определя категорията на комита. Използваме следните типове:
  - `Docs`: За актуализации на документацията.
  - `Build`: За промени, свързани със системата за изграждане или зависимости, включително актуализации на конфигурационни файлове, CI работни потоци или Dockerfile.
  - `Core`: За модификации на основната функционалност или характеристики на проекта, особено файлове в директорията `src/co_op_translator/core`.

- **description**: Кратко резюме на промяната.
- **PR number**: Номерът на свързания pull request.

**Примери**:

- `Docs: Актуализиране на инструкциите за инсталация за по-голяма яснота (#50)`
- `Core: Подобряване на обработката на превод на изображения (#60)`

> [!NOTE]
> В момента префиксите **`Docs`**, **`Core`** и **`Build`** се добавят автоматично към заглавията на PR въз основа на етикетите, приложени към променения изходен код. Докато правилният етикет е приложен, обикновено не е нужно ръчно да променяте заглавието на PR. Просто проверете дали всичко е правилно и префиксът е генериран коректно.

#### Стратегия за сливане

Използваме **Squash and Merge** като стандартна стратегия за pull requests. Тази стратегия гарантира, че съобщенията за комит следват нашия формат, дори ако отделните комити не го правят.

**Причини**:

- Чиста, линейна история на проекта.
- Последователност в съобщенията за комит.
- Намаляване на шума от дребни комити (например "поправка на печатна грешка").

При сливане се уверете, че финалното съобщение следва описания формат.

**Пример за Squash and Merge**
Ако PR съдържа следните комити:

- `поправка на печатна грешка`
- `актуализиране на README`
- `корекция на форматиране`

Те трябва да се обединят в:
`Docs: Подобряване на яснотата и форматирането на документацията (#65)`

### Процес на издаване

Този раздел описва най-простия начин за поддържащите да публикуват ново издание на Co-op Translator.

#### 1. Увеличаване на версията в `pyproject.toml`

1. Изберете следващия номер на версията (следваме семантично версиониране: `MAJOR.MINOR.PATCH`).
2. Редактирайте `pyproject.toml` и актуализирайте полето `version` под `[tool.poetry]`.
3. Отворете отделен pull request, който променя само версията (и евентуално автоматично обновените lock/метаданни файлове, ако има такива).
4. След преглед използвайте **Squash and Merge** и се уверете, че финалното съобщение следва описания формат.

#### 2. Създаване на GitHub Release

1. Отидете на страницата на репозитория в GitHub и отворете **Releases** → **Draft a new release**.
2. Създайте нов таг (например `v0.13.0`) от клон `main`.
3. Задайте заглавие на изданието със същата версия (например `v0.13.0`).
4. Натиснете **Generate release notes**, за да се попълни автоматично changelog.
5. По желание редактирайте текста (например, за да подчертаете новоподдържани езици или важни промени).
6. Публикувайте изданието.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**Отказ от отговорност**:  
Този документ е преведен с помощта на AI преводаческа услуга [Co-op Translator](https://github.com/Azure/co-op-translator). Въпреки че се стремим към точност, моля, имайте предвид, че автоматизираните преводи могат да съдържат грешки или неточности. Оригиналният документ на неговия роден език трябва да се счита за авторитетен източник. За критична информация се препоръчва професионален човешки превод. Ние не носим отговорност за каквито и да е недоразумения или неправилни тълкувания, произтичащи от използването на този превод.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->