<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "6e626bef5ed78a1cc55b0dbf44f01d47",
  "translation_date": "2025-10-15T02:18:16+00:00",
  "source_file": "getting_started/troubleshooting.md",
  "language_code": "ar"
}
-->
# دليل استكشاف الأخطاء لمترجم Microsoft Co-op

## نظرة عامة
يُعد مترجم Microsoft Co-Op أداة قوية لترجمة مستندات Markdown بسلاسة. سيساعدك هذا الدليل في حل المشكلات الشائعة التي قد تواجهك أثناء استخدام الأداة.

## المشاكل الشائعة وحلولها

### 1. مشكلة وسم Markdown
**المشكلة:** يتضمن مستند Markdown المترجم وسم `markdown` في الأعلى، مما يسبب مشاكل في العرض.

**الحل:** لحل هذه المشكلة، احذف ببساطة وسم `markdown` الموجود في أعلى الملف. سيؤدي ذلك إلى عرض ملف Markdown بشكل صحيح.

**الخطوات:**
1. افتح ملف Markdown (`.md`) المترجم.
2. ابحث عن وسم `markdown` في أعلى المستند.
3. احذف وسم `markdown`.
4. احفظ التغييرات في الملف.
5. أعد فتح الملف للتأكد من عرضه بشكل صحيح.

### 2. مشكلة روابط الصور المدمجة
**المشكلة:** روابط الصور المدمجة لا تتوافق مع لغة المستند، مما يؤدي إلى ظهور صور خاطئة أو مفقودة.

**الحل:** تحقق من روابط الصور المدمجة وتأكد من أنها تتوافق مع لغة المستند. جميع الصور موجودة في مجلد `translated_images` وكل صورة تحمل وسم اللغة في اسم الملف.

**الخطوات:**
1. افتح مستند Markdown المترجم.
2. حدد الصور المدمجة وروابطها.
3. تحقق من أن وسم اللغة في اسم ملف الصورة يتوافق مع لغة المستند.
4. حدث الروابط إذا لزم الأمر.
5. احفظ التغييرات وأعد فتح المستند للتأكد من عرض الصور بشكل صحيح.

### 3. دقة الترجمة
**المشكلة:** المحتوى المترجم غير دقيق أو يحتاج إلى تعديل إضافي.

**الحل:** راجع المستند المترجم وقم بالتعديلات اللازمة لتحسين الدقة وسهولة القراءة.

**الخطوات:**
1. افتح المستند المترجم.
2. راجع المحتوى بعناية.
3. قم بالتعديلات اللازمة لتحسين دقة الترجمة.
4. احفظ التغييرات.

## 4. خطأ في الصلاحيات أو 404

إذا لم تتم ترجمة الصور أو النصوص إلى اللغة الصحيحة وعند التشغيل في وضع -d debug تواجه خطأ 401. هذا يشير إلى فشل في المصادقة—إما أن المفتاح غير صالح، أو منتهي الصلاحية، أو غير مرتبط بمنطقة نقطة النهاية.

شغل مترجم co-op مع [مفتاح -d debug](https://github.com/Azure/co-op-translator/blob/main/getting_started/command-reference.md) لفهم السبب الجذري للمشكلة.

- **رسالة الخطأ:** `Access denied due to invalid subscription key or wrong API endpoint.`
- **الأسباب المحتملة:**
  - تم إخفاء مفتاح الاشتراك أو كان غير صحيح في الطلب.
  - مفتاح خدمات الذكاء الاصطناعي أو مفتاح الاشتراك قد يكون مرتبطًا بمورد Azure مختلف (مثل Translator أو OpenAI) بدلاً من مورد **Azure AI Vision**.

 **نوع المورد**
  - انتقل إلى [بوابة Azure](https://portal.azure.com) أو [Azure AI Foundry](https://ai.azure.com) وتأكد أن المورد من نوع `Azure AI services` → `Vision`.
  - تحقق من صحة المفاتيح وتأكد من استخدام المفتاح الصحيح.

## 5. أخطاء التكوين (معالجة الأخطاء الجديدة)

بدءًا من نظام الترجمة الانتقائية الجديد، أصبح مترجم Co-op يقدم رسائل خطأ واضحة عند عدم تكوين الخدمات المطلوبة.

### 5.1. خدمة Azure AI غير مُهيأة لترجمة الصور

**المشكلة:** طلبت ترجمة الصور (علم `-img`) لكن خدمة Azure AI غير مُهيأة بشكل صحيح.

**رسالة الخطأ:**
```
Error: Image translation requested but Azure AI Service is not configured.
Please add AZURE_AI_SERVICE_API_KEY and AZURE_AI_SERVICE_ENDPOINT to your .env file.
Check Azure AI Service availability and configuration.
```

**الحل:**
1. **الخيار الأول:** هيّئ خدمة Azure AI
   - أضف `AZURE_AI_SERVICE_API_KEY` إلى ملف `.env`
   - أضف `AZURE_AI_SERVICE_ENDPOINT` إلى ملف `.env`
   - تحقق من إمكانية الوصول إلى الخدمة

2. **الخيار الثاني:** أزل طلب ترجمة الصور
   ```bash
   # Instead of: translate -l "ko" -img
   # Use: translate -l "ko" -md
   ```

### 5.2. نقص التكوين المطلوب

**المشكلة:** إعدادات LLM الأساسية مفقودة.

**رسالة الخطأ:**
```
Error: No language model configuration found.
Please configure either Azure OpenAI or OpenAI in your .env file.
```

**الحل:**
1. تحقق أن ملف `.env` يحتوي على واحد على الأقل من إعدادات LLM التالية:
   - **Azure OpenAI:** `AZURE_OPENAI_API_KEY` و `AZURE_OPENAI_ENDPOINT`
   - **OpenAI:** `OPENAI_API_KEY`
   
   يجب أن يكون لديك إما Azure OpenAI أو OpenAI مُهيأ، وليس كلاهما.

### 5.3. ارتباك في الترجمة الانتقائية

**المشكلة:** لم تتم ترجمة أي ملفات رغم نجاح الأمر.

**الأسباب المحتملة:**
- أعلام نوع الملف خاطئة (`-md`, `-img`, `-nb`)
- لا توجد ملفات مطابقة في المشروع
- هيكلية المجلدات غير صحيحة

**الحل:**
1. **استخدم وضع debug** لمعرفة ما يحدث:
   ```bash
   translate -l "ko" -md -d
   ```

2. **تحقق من أنواع الملفات** في مشروعك:
   ```bash
   # For markdown files
   find . -name "*.md" -not -path "./translations/*"
   
   # For notebooks
   find . -name "*.ipynb" -not -path "./translations/*"
   
   # For images
   find . -name "*.png" -o -name "*.jpg" -o -name "*.jpeg" -not -path "./translations/*"
   ```

3. **تحقق من تركيبات الأعلام**:
   ```bash
   # Translate everything (default)
   translate -l "ko"
   
   # Translate specific types
   translate -l "ko" -md -img
   ```

## 6. الانتقال من النظام القديم

### 6.1. إيقاف وضع Markdown فقط

**المشكلة:** الأوامر التي كانت تعتمد على وضع Markdown فقط التلقائي لم تعد تعمل كما هو متوقع.

**السلوك القديم:**
```bash
# This used to automatically switch to markdown-only mode
translate -l "ko"  # (when Azure AI Vision was not configured)
```

**السلوك الجديد:**
```bash
# This now produces an error if image translation is requested but not configured
translate -l "ko" -img
```

**الحل:**
- **كن واضحًا** بشأن ما تريد ترجمته:
  ```bash
  translate -l "ko" -md        # Only markdown
  translate -l "ko" -md -img   # Markdown and images
  translate -l "ko"            # Everything (if all services configured)
  ```

### 6.2. سلوك الروابط غير المتوقع

**المشكلة:** الروابط في الملفات المترجمة تشير إلى أماكن غير متوقعة.

**السبب:** معالجة الروابط الديناميكية تتغير حسب أنواع الملفات المختارة.

**الحل:**
1. **افهم السلوك الجديد للروابط:**
   - عند تضمين `-nb`: روابط الدفاتر تشير إلى النسخ المترجمة
   - عند استبعاد `-nb`: روابط الدفاتر تشير إلى الملفات الأصلية
   - عند تضمين `-img`: روابط الصور تشير إلى النسخ المترجمة
   - عند استبعاد `-img`: روابط الصور تشير إلى الملفات الأصلية

2. **اختر التركيبة المناسبة** لحالتك:
   ```bash
   # All internal links point to translated versions
   translate -l "ko" -md -img -nb
   
   # Only markdown translated, other links point to originals
   translate -l "ko" -md
   ```

## 7. تم تشغيل GitHub Action لكن لم يتم إنشاء طلب سحب (PR)

**العَرَض:** سجلات سير العمل لـ `peter-evans/create-pull-request` تظهر:

> Branch 'update-translations' is not ahead of base 'main' and will not be created

**الأسباب المحتملة:**
- **لا توجد تغييرات:** خطوة الترجمة لم تنتج أي اختلافات (المستودع محدث بالفعل).
- **تجاهل المخرجات:** ملف `.gitignore` يستبعد الملفات التي تتوقع إضافتها (مثل `*.ipynb`, `translations/`, `translated_images/`).
- **عدم تطابق add-paths:** المسارات المقدمة للإجراء لا تتطابق مع مواقع المخرجات الفعلية.
- **منطق سير العمل/الشروط:** خطوة الترجمة انتهت مبكرًا أو كتبت في مجلدات غير متوقعة.

**كيفية الإصلاح / التحقق:**
1. **تأكد من وجود المخرجات:** بعد الترجمة، تحقق من وجود ملفات جديدة/معدلة في `translations/` و/أو `translated_images/`.
   - إذا كنت تترجم دفاتر، تأكد من كتابة ملفات `.ipynb` تحت `translations/<lang>/...`.
2. **راجع ملف `.gitignore`:** لا تتجاهل المخرجات المُولدة. تأكد من عدم تجاهل:
   - `translations/`
   - `translated_images/`
   - `*.ipynb` (إذا كنت تترجم دفاتر)
3. **تأكد من تطابق add-paths مع المخرجات:** استخدم قيمة متعددة الأسطر وضمّن كلا المجلدين إذا لزم الأمر:
   ```yaml
   with:
     add-paths: |
       translations/
       translated_images/
   ```
4. **أجبر إنشاء PR لأغراض التصحيح:** اسمح مؤقتًا بإنشاء التزامات فارغة للتأكد من صحة الربط:
   ```yaml
   with:
     commit-empty: true
   ```
5. **شغل مع debug:** أضف `-d` إلى أمر الترجمة لطباعة الملفات التي تم اكتشافها وكتابتها.
6. **الصلاحيات (GITHUB_TOKEN):** تأكد أن سير العمل لديه صلاحيات الكتابة لإنشاء الالتزامات وطلبات السحب:
   ```yaml
   permissions:
     contents: write
     pull-requests: write
   ```

## قائمة التحقق السريعة لاستكشاف الأخطاء

عند استكشاف مشاكل الترجمة:

1. **استخدم وضع debug:** أضف علم `-d` لرؤية السجلات التفصيلية
2. **تحقق من الأعلام:** تأكد أن `-md`, `-img`, `-nb` تتوافق مع هدفك
3. **تحقق من التكوين:** تأكد أن ملف `.env` يحتوي على المفاتيح المطلوبة
4. **اختبر تدريجيًا:** ابدأ بـ `-md` فقط، ثم أضف الأنواع الأخرى
5. **تحقق من هيكلية الملفات:** تأكد من وجود الملفات المصدرية وإمكانية الوصول إليها

لمزيد من المعلومات التفصيلية حول الأوامر والأعلام المتاحة، راجع [مرجع الأوامر](./command-reference.md).

---

**إخلاء المسؤولية**:
تمت ترجمة هذا المستند باستخدام خدمة الترجمة بالذكاء الاصطناعي [Co-op Translator](https://github.com/Azure/co-op-translator). بينما نسعى لتحقيق الدقة، يرجى العلم أن الترجمات الآلية قد تحتوي على أخطاء أو معلومات غير دقيقة. يجب اعتبار المستند الأصلي بلغته الأصلية هو المصدر الرسمي والمعتمد. بالنسبة للمعلومات الهامة، يُنصح بالاستعانة بترجمة بشرية احترافية. نحن غير مسؤولين عن أي سوء فهم أو تفسير خاطئ ينشأ عن استخدام هذه الترجمة.