<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "20943a46b11c6d74814f41a817a6db4c",
  "translation_date": "2025-10-15T02:18:42+00:00",
  "source_file": "getting_started/command-line-guide/translator-your-project.md",
  "language_code": "ar"
}
-->
# ترجم مشروعك باستخدام Co-op Translator

**Co-op Translator** هو أداة سطر أوامر تساعدك على ترجمة ملفات الماركداون والصور في مشروعك إلى عدة لغات. يشرح هذا القسم كيفية استخدام الأداة، ويغطي خيارات سطر الأوامر المختلفة، ويقدم أمثلة لحالات الاستخدام المتنوعة.

---

## أمثلة على السيناريوهات والأوامر

إليك بعض حالات الاستخدام الشائعة لـ **Co-op Translator**، مع الأوامر المناسبة لتشغيلها.

### 1. الترجمة الأساسية (لغة واحدة)

لترجمة مشروعك بالكامل (ملفات الماركداون والصور) إلى لغة واحدة مثل الكورية، استخدم الأمر التالي:

```bash
translate -l "ko"
```

سيقوم هذا الأمر بترجمة جميع ملفات الماركداون والصور إلى الكورية، مع إضافة ترجمات جديدة دون حذف أي ترجمات موجودة.

#### مثال على Phi-3 CookBook

في **Phi-3 CookBook**، استخدمت الطريقة التالية لإضافة الترجمة الكورية للملفات والصور الموجودة.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko"
Translating images: 100%|███████████████████████████████████████████████████| 276/276 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 153/153 [1:43:07<00:00, 241.31s/it]
```

### 2. الترجمة إلى عدة لغات

لترجمة مشروعك إلى عدة لغات (مثلاً الإسبانية والفرنسية والألمانية)، استخدم هذا الأمر:

```bash
translate -l "es fr de"
```

سيقوم هذا الأمر بترجمة المشروع إلى الإسبانية والفرنسية والألمانية، مع إضافة ترجمات جديدة دون الكتابة فوق الترجمات الموجودة.

#### مثال على Phi-3 CookBook

في **Phi-3 CookBook**، بعد سحب آخر التغييرات لعكس أحدث الالتزامات، استخدمت الطريقة التالية لترجمة الملفات والصور الجديدة.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko ja zh tw es fr" -a
Translating images: 100%|███████████████████████████████████████████████████| 273/273 [1:09:56<00:00, 15.37s/it]
Translating markdown files: 100%|████████████████████████████████████████████████| 6/6 [24:07<00:00, 241.31s/it]
```

### 3. تحديث الترجمات (حذف الترجمات الحالية)

لتحديث الترجمات الحالية (أي حذف الترجمات الحالية واستبدالها بأخرى جديدة)، استخدم خيار `-u`. سيؤدي ذلك إلى حذف جميع الترجمات الحالية للغات المحددة وإعادة ترجمتها.

```bash
translate -l "ko" -u
```

تحذير: سيطلب منك هذا الأمر تأكيد قبل المتابعة في حذف الترجمات الحالية.

#### مثال على Phi-3 CookBook

في **Phi-3 CookBook**، استخدمت الطريقة التالية لتحديث جميع الملفات المترجمة إلى الإسبانية. أنصح باستخدام هذه الطريقة عندما تكون هناك تغييرات كبيرة في المحتوى الأصلي عبر عدة مستندات ماركداون. إذا كان هناك عدد قليل فقط من الملفات المترجمة التي تحتاج إلى تحديث، فمن الأفضل حذف تلك الملفات يدويًا ثم استخدام طريقة `-a` لإضافة الترجمات المحدثة.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "es" -u
Warning: The update command will delete all existing translations for 'es' and re-translate everything.
Do you want to continue? Type 'yes' to proceed: yes
Proceeding with update...
Translating images: 100%|████████████████████████████████████████████| 150/150 [43:46<00:00, 15.55s/it]
Translating markdown files: 100%|███████████████████████████████████| 95/95 [1:40:27<00:00, 125.62s/it]
```

### 5. ترجمة الصور فقط

لترجمة ملفات الصور فقط في مشروعك، استخدم خيار `-img`:

```bash
translate -l "ko" -img
```

سيقوم هذا الأمر بترجمة الصور فقط إلى الكورية، دون التأثير على ملفات الماركداون.

### 6. ترجمة ملفات الماركداون فقط

لترجمة ملفات الماركداون فقط في مشروعك، استخدم خيار `-md`:

```bash
translate -l "ko" -md
```

#### مثال على Phi-3 CookBook

في **Phi-3 CookBook**، استخدمت الطريقة التالية للتحقق من أخطاء الترجمة في الملفات الكورية وإعادة محاولة الترجمة تلقائيًا لأي ملفات بها مشاكل.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l"ko" -chk 
Checking translated files for errors in ko...
Checking files for ko: 100%|██████████████████████████████████████████████████| 95/95 [00:01<00:00, 65.47file/s]
Retrying vsc-extension-quickstart.md for ko:   0%|                                     | 0/17 [00:00<?, ?file/s] 
```

يقوم هذا الخيار بالتحقق من أخطاء الترجمة. حاليًا، إذا كان الفرق في عدد الأسطر بين الملف الأصلي والمترجم أكثر من ستة، يتم اعتبار الملف به خطأ في الترجمة. أخطط لتحسين هذا المعيار ليكون أكثر مرونة في المستقبل.

على سبيل المثال، هذه الطريقة مفيدة لاكتشاف الأجزاء المفقودة أو الترجمات التالفة، وستعيد محاولة الترجمة تلقائيًا لتلك الملفات.

ومع ذلك، إذا كنت تعرف بالفعل الملفات التي بها مشاكل، فمن الأفضل حذفها يدويًا واستخدام خيار `-a` لإعادة ترجمتها.

### 8. وضع التصحيح (Debug Mode)

لتفعيل تسجيل مفصل للمساعدة في استكشاف الأخطاء، استخدم خيار `-d`:

```bash
translate -l "ko" -d
```

سيقوم هذا الأمر بتشغيل الترجمة في وضع التصحيح، ويوفر معلومات إضافية تساعدك في تحديد المشاكل أثناء عملية الترجمة.

#### مثال على Phi-3 CookBook

في **Phi-3 CookBook**، واجهت مشكلة حيث أن الترجمات التي تحتوي على العديد من الروابط في ملفات الماركداون سببت أخطاء في التنسيق، مثل ترجمات تالفة وتجاهل فواصل الأسطر. لتشخيص هذه المشكلة، استخدمت خيار `-d` لرؤية كيفية عمل عملية الترجمة.

```bash
(.venv) C:\Users\sms79\dev\Phi-3CookBook>translate -l "ko" -d
DEBUG:openai._base_client:Request options: {'method': 'post', 'url': '/chat/completions', 'headers': {'api-key': 'af04e0bea45747d8a7b8c131c1971044'}, 'files': None, 'json_data': {'messages': [{'role': 'user', 'content': "Translate the following text to ko. NEVER ADD ANY EXTRA CONTENT OUTSIDE THE TRANSLATION. TRANSLATE ONLY WHAT IS GIVEN TO YOU.. MAINTAIN MARKDOWN FORMAT\n\n# Phi-3 Cookbook: Hands-On Examples with Microsoft's Phi-3 Models [![Open and use the samples in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/microsoft/phi-3cookbook) [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%
...
```

### 9. ترجمة جميع اللغات

إذا كنت ترغب في ترجمة المشروع إلى جميع اللغات المدعومة، استخدم كلمة all.

```bash
translate -l "all"
```

سيقوم هذا الأمر بترجمة المشروع إلى جميع اللغات المتاحة. إذا تابعت، قد تستغرق الترجمة وقتًا طويلاً حسب حجم المشروع.

### حذف الملفات المترجمة يدويًا (اختياري)
يتم الآن اكتشاف وتنظيف الملفات المترجمة تلقائيًا عند تحديث الملف الأصلي.

ومع ذلك، إذا أردت تحديث ترجمة معينة يدويًا - على سبيل المثال، لإعادة ترجمة ملف محدد أو تجاوز سلوك النظام - يمكنك استخدام الأمر التالي لحذف جميع نسخ الملف عبر مجلدات اللغات.

#### على Windows:
1. **باستخدام Command Prompt**:
   - افتح Command Prompt.
   - انتقل إلى المجلد الذي توجد فيه الملفات باستخدام أمر `cd`.
   - استخدم الأمر التالي لحذف الملفات:
>      ```
>      del /s *filename*
>      ```
   استبدل `filename` بالجزء المحدد من اسم الملف الذي تبحث عنه. خيار `/s` يبحث في المجلدات الفرعية أيضًا.

2. **باستخدام PowerShell**:
   - افتح PowerShell.
   - شغل هذا الأمر:
>      ```powershell
>      Get-ChildItem -Path "C:\YourPath" -Filter "*filename*" -Recurse | Remove-Item -Force
>      ```
   استبدل `"C:\YourPath"` بمسار المجلد و`filename` بالاسم المحدد.

#### على macOS/Linux:
1. **باستخدام Terminal**:
  - افتح Terminal.
  - انتقل إلى الدليل باستخدام `cd`.
  - استخدم أمر `find`:
>     ```bash
>     find . -type f -name "*filename*" -delete
>     ```
  استبدل `filename` بالاسم المحدد.

دائمًا تحقق من الملفات قبل الحذف لتجنب فقدانها عن طريق الخطأ.

بعد حذف الملفات التي تحتاج إلى استبدالها، فقط أعد تشغيل أمر `translate -l` لتحديث التغييرات الأخيرة على الملفات.

---

**إخلاء المسؤولية**:
تمت ترجمة هذا المستند باستخدام خدمة الترجمة بالذكاء الاصطناعي [Co-op Translator](https://github.com/Azure/co-op-translator). بينما نسعى لتحقيق الدقة، يرجى العلم أن الترجمات الآلية قد تحتوي على أخطاء أو معلومات غير دقيقة. يجب اعتبار المستند الأصلي بلغته الأصلية هو المصدر الموثوق. للمعلومات الحساسة، يُنصح بالاستعانة بترجمة بشرية احترافية. نحن غير مسؤولين عن أي سوء فهم أو تفسير خاطئ ينشأ عن استخدام هذه الترجمة.