<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "510827ad22a2031a50838919c3594828",
  "translation_date": "2025-10-15T02:18:35+00:00",
  "source_file": "getting_started/command-line-guide/install-package.md",
  "language_code": "ar"
}
-->
# تثبيت حزمة Co-op Translator

**Co-op Translator** هو أداة سطر أوامر (CLI) مصممة لمساعدتك في ترجمة جميع ملفات الماركداون والصور في مشروعك إلى عدة لغات. سيرشدك هذا الدليل خلال إعداد المترجم وتشغيله لمختلف الحالات.

### إنشاء بيئة افتراضية

يمكنك إنشاء بيئة افتراضية باستخدام `pip` أو `Poetry`. اكتب أحد الأوامر التالية في الطرفية الخاصة بك.

#### باستخدام pip

```bash
python -m venv .venv
```

#### باستخدام Poetry

```bash
poetry init
```

### تفعيل البيئة الافتراضية

بعد إنشاء البيئة الافتراضية، ستحتاج إلى تفعيلها. تختلف الخطوات حسب نظام التشغيل لديك. اكتب الأمر التالي في الطرفية الخاصة بك.

#### لكل من pip و Poetry

- ويندوز:

    ```bash
    .venv\Scripts\activate
    ```

- ماك/لينكس:

    ```bash
    source .venv/bin/activate
    ```

#### باستخدام Poetry

1. إذا أنشأت البيئة باستخدام Poetry، اكتب الأمر التالي في الطرفية لتفعيلها.

    ```bash
    poetry shell
    ```

### تثبيت الحزمة والحزم المطلوبة

بعد إعداد وتفعيل البيئة الافتراضية، الخطوة التالية هي تثبيت الاعتمادات اللازمة.

### تثبيت سريع

التثبيت عبر Co-Op Translator باستخدام pip

```
pip install co-op-translator
```
أو

التثبيت عبر poetry
```
poetry add co-op-translator
```

#### باستخدام pip (من requirements.txt) إذا قمت باستنساخ هذا المستودع

> [!NOTE]
> الرجاء عدم القيام بذلك إذا قمت بتثبيت co-op translator عبر التثبيت السريع.

1. إذا كنت تستخدم pip، اكتب الأمر التالي في الطرفية الخاصة بك. سيقوم تلقائيًا بتثبيت الحزم المطلوبة المحددة في ملف `requirements.txt`:

    ```bash
    pip install -r requirements.txt
    ```

#### باستخدام Poetry (من pyproject.toml)

1. إذا كنت تستخدم Poetry، اكتب الأمر التالي في الطرفية الخاصة بك. سيقوم تلقائيًا بتثبيت الحزم المطلوبة المحددة في ملف `pyproject.toml`:

    ```bash
    poetry install
    ```

---

**إخلاء المسؤولية**:
تمت ترجمة هذا المستند باستخدام خدمة الترجمة بالذكاء الاصطناعي [Co-op Translator](https://github.com/Azure/co-op-translator). بينما نسعى لتحقيق الدقة، يرجى العلم أن الترجمات الآلية قد تحتوي على أخطاء أو معلومات غير دقيقة. يجب اعتبار المستند الأصلي بلغته الأصلية هو المصدر الرسمي والموثوق. بالنسبة للمعلومات الحساسة أو الهامة، يُنصح بالاستعانة بترجمة بشرية احترافية. نحن غير مسؤولين عن أي سوء فهم أو تفسير خاطئ ينشأ عن استخدام هذه الترجمة.