<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "dac6bc281667816537df51f724a0ff2c",
  "translation_date": "2025-11-30T09:55:56+00:00",
  "source_file": "README.md",
  "language_code": "ar"
}
-->
# مترجم التعاون

_قم بأتمتة ترجمة محتوى GitHub التعليمي الخاص بك بسهولة إلى عدة لغات للوصول إلى جمهور عالمي._

[![حزمة بايثون](https://img.shields.io/pypi/v/co-op-translator?color=4BA3FF)](https://pypi.org/project/co-op-translator/)
[![الرخصة: MIT](https://img.shields.io/github/license/azure/co-op-translator?color=4BA3FF)](https://github.com/azure/co-op-translator/blob/main/LICENSE)
[![التنزيلات](https://static.pepy.tech/badge/co-op-translator)](https://pepy.tech/project/co-op-translator)
[![التنزيلات](https://static.pepy.tech/badge/co-op-translator/month)](https://pepy.tech/project/co-op-translator)
[![الحاوية: GHCR](https://img.shields.io/badge/Container-GHCR-2496ED?logo=docker&logoColor=fff)](https://github.com/azure/co-op-translator/pkgs/container/co-op-translator)
[![نمط الكود: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

[![مساهمو GitHub](https://img.shields.io/github/contributors/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/graphs/contributors/)
[![قضايا GitHub](https://img.shields.io/github/issues/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/issues/)
[![طلبات السحب في GitHub](https://img.shields.io/github/issues-pr/azure/co-op-translator.svg)](https://GitHub.com/azure/co-op-translator/pulls/)
[![طلبات السحب مرحب بها](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](http://makeapullrequest.com)

### 🌐 دعم متعدد اللغات

#### مدعوم من [مترجم التعاون](https://github.com/Azure/Co-op-Translator)

<!-- CO-OP TRANSLATOR LANGUAGES TABLE START -->
[العربية](./README.md) | [البنغالية](../bn/README.md) | [البلغارية](../bg/README.md) | [البورمية (ميانمار)](../my/README.md) | [الصينية (المبسطة)](../zh/README.md) | [الصينية (التقليدية، هونغ كونغ)](../hk/README.md) | [الصينية (التقليدية، ماكاو)](../mo/README.md) | [الصينية (التقليدية، تايوان)](../tw/README.md) | [الكرواتية](../hr/README.md) | [التشيكية](../cs/README.md) | [الدنماركية](../da/README.md) | [الهولندية](../nl/README.md) | [الإستونية](../et/README.md) | [الفنلندية](../fi/README.md) | [الفرنسية](../fr/README.md) | [الألمانية](../de/README.md) | [اليونانية](../el/README.md) | [العبرية](../he/README.md) | [الهندية](../hi/README.md) | [الهنغارية](../hu/README.md) | [الإندونيسية](../id/README.md) | [الإيطالية](../it/README.md) | [اليابانية](../ja/README.md) | [الكانادا](../kn/README.md) | [الكورية](../ko/README.md) | [الليتوانية](../lt/README.md) | [الماليزية](../ms/README.md) | [المالايالامية](../ml/README.md) | [الماراثية](../mr/README.md) | [النيبالية](../ne/README.md) | [النيجيرية بيدجين](../pcm/README.md) | [النرويجية](../no/README.md) | [الفارسية (اللغة الفارسية)](../fa/README.md) | [البولندية](../pl/README.md) | [البرتغالية (البرازيل)](../br/README.md) | [البرتغالية (البرتغال)](../pt/README.md) | [البنجابية (غورموخي)](../pa/README.md) | [الرومانية](../ro/README.md) | [الروسية](../ru/README.md) | [الصربية (السيريلية)](../sr/README.md) | [السلوفاكية](../sk/README.md) | [السلوفينية](../sl/README.md) | [الإسبانية](../es/README.md) | [السواحيلية](../sw/README.md) | [السويدية](../sv/README.md) | [التاغالوغ (الفلبينية)](../tl/README.md) | [التاميلية](../ta/README.md) | [التيلجو](../te/README.md) | [التايلاندية](../th/README.md) | [التركية](../tr/README.md) | [الأوكرانية](../uk/README.md) | [الأردية](../ur/README.md) | [الفيتنامية](../vi/README.md)
<!-- CO-OP TRANSLATOR LANGUAGES TABLE END -->

[![المراقبون على GitHub](https://img.shields.io/github/watchers/azure/co-op-translator.svg?style=social&label=Watch)](https://GitHub.com/azure/co-op-translator/watchers/)
[![التفرعات على GitHub](https://img.shields.io/github/forks/azure/co-op-translator.svg?style=social&label=Fork)](https://GitHub.com/azure/co-op-translator/network/)
[![النجوم على GitHub](https://img.shields.io/github/stars/azure/co-op-translator?style=social&label=Star)](https://GitHub.com/azure/co-op-translator/stargazers/)

[![ديسكورد Microsoft Foundry](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

[![افتح في GitHub Codespaces](https://img.shields.io/static/v1?style=for-the-badge&label=Github%20Codespaces&message=Open&color=24292F&logo=github)](https://codespaces.new/azure/co-op-translator)

## نظرة عامة

**مترجم التعاون** يساعدك على تعريب محتوى GitHub التعليمي الخاص بك إلى عدة لغات بسهولة.
عندما تقوم بتحديث ملفات Markdown أو الصور أو دفاتر الملاحظات، تبقى الترجمات متزامنة تلقائيًا، مما يضمن بقاء المحتوى دقيقًا ومحدثًا للمتعلمين حول العالم.

مثال على كيفية تنظيم المحتوى المترجم:

![مثال](../../translated_images/translation-ex.0c8aa6a7ee0aad2b35cddcc110c719baf0afc640e8c5a45540e6c166b9907d91.ar.png)

## بداية سريعة

```bash
# إنشاء وتفعيل بيئة افتراضية (موصى به)
python -m venv .venv
# ويندوز
.venv\Scripts\activate
# ماك أو إس / لينكس
source .venv/bin/activate
# تثبيت الحزمة
pip install co-op-translator
# ترجمة
translate -l "ko ja fr" -md
```

دوكر:

```bash
# سحب الصورة العامة من GHCR
docker pull ghcr.io/azure/co-op-translator:latest
# التشغيل مع تثبيت المجلد الحالي وتوفير ملف .env (Bash/Zsh)
docker run --rm -it --env-file .env -v "${PWD}:/work" ghcr.io/azure/co-op-translator:latest -l "ko ja fr" -md
```

## الإعداد الأدنى

1. أنشئ ملف `.env` باستخدام القالب: [.env.template](../../.env.template)
2. قم بتكوين مزود LLM واحد (Azure OpenAI أو OpenAI)
3. (اختياري) لترجمة الصور (`-img`)، قم بتكوين Azure AI Vision
4. (موصى به) نظف أي ترجمات سابقة لتجنب التعارضات (مثل `translations/`)
5. (موصى به) أضف قسم الترجمة إلى ملف README باستخدام [قالب لغات README](./getting_started/README_languages_template.md)
6. راجع: [إعداد Azure AI](./getting_started/set-up-azure-ai.md)

## الاستخدام

ترجم جميع الأنواع المدعومة:

```bash
translate -l "ko ja"
```

Markdown فقط:

```bash
translate -l "de" -md
```

Markdown + صور:

```bash
translate -l "pt" -md -img
```

دفاتر الملاحظات فقط:

```bash
translate -l "zh" -nb
```

المزيد من الخيارات: [مرجع الأوامر](./getting_started/command-reference.md)

## الميزات

- ترجمة آلية للـ Markdown، دفاتر الملاحظات، والصور
- يحافظ على تزامن الترجمات مع تغييرات المصدر
- يعمل محليًا (CLI) أو في CI (GitHub Actions)
- يستخدم Azure OpenAI أو OpenAI؛ Azure AI Vision اختياري للصور
- يحافظ على تنسيق وبنية Markdown

## الوثائق

- [دليل سطر الأوامر](./getting_started/command-line-guide/command-line-guide.md)
- [دليل GitHub Actions (المستودعات العامة والأسرار القياسية)](./getting_started/github-actions-guide/github-actions-guide-public.md)
- [دليل GitHub Actions (مستودعات منظمة Microsoft والإعدادات على مستوى المنظمة)](./getting_started/github-actions-guide/github-actions-guide-org.md)
- [قالب لغات README](./getting_started/README_languages_template.md)
- [اللغات المدعومة](./getting_started/supported-languages.md)
- [المساهمة](./CONTRIBUTING.md)
- [استكشاف الأخطاء وإصلاحها](./getting_started/troubleshooting.md)

### دليل خاص بـ Microsoft
> [!NOTE]
> للمشرفين على مستودعات Microsoft "للمبتدئين" فقط.

- [تحديث قائمة "الدورات الأخرى" (لمستودعات MS Beginners فقط)](./getting_started/update-other-courses.md)

## دعمنا وتعزيز التعلم العالمي

انضم إلينا في ثورة كيفية مشاركة المحتوى التعليمي عالميًا! امنح [مترجم التعاون](https://github.com/azure/co-op-translator) ⭐ على GitHub وادعم مهمتنا في إزالة حواجز اللغة في التعلم والتكنولوجيا. اهتمامك ومساهماتك تحدث فرقًا كبيرًا! مساهمات الكود واقتراحات الميزات مرحب بها دائمًا.

### استكشف محتوى Microsoft التعليمي بلغتك

- [AZD للمبتدئين](https://github.com/microsoft/AZD-for-beginners)
- [Edge AI للمبتدئين](https://github.com/microsoft/edgeai-for-beginners)
- [بروتوكول سياق النموذج (MCP) للمبتدئين](https://github.com/microsoft/mcp-for-beginners)
- [وكلاء الذكاء الاصطناعي للمبتدئين](https://github.com/microsoft/ai-agents-for-beginners)
- [الذكاء الاصطناعي التوليدي للمبتدئين باستخدام .NET](https://github.com/microsoft/Generative-AI-for-beginners-dotnet)
- [الذكاء الاصطناعي التوليدي للمبتدئين](https://github.com/microsoft/generative-ai-for-beginners)
- [الذكاء الاصطناعي التوليدي للمبتدئين باستخدام Java](https://github.com/microsoft/generative-ai-for-beginners-java)
- [التعلم الآلي للمبتدئين](https://aka.ms/ml-beginners)
- [علوم البيانات للمبتدئين](https://aka.ms/datascience-beginners)
- [الذكاء الاصطناعي للمبتدئين](https://aka.ms/ai-beginners)
- [الأمن السيبراني للمبتدئين](https://github.com/microsoft/Security-101)
- [تطوير الويب للمبتدئين](https://aka.ms/webdev-beginners)
- [إنترنت الأشياء للمبتدئين](https://aka.ms/iot-beginners)
- [PhiCookBook](https://github.com/microsoft/PhiCookBook)

## عروض الفيديو

👉 انقر على الصورة أدناه للمشاهدة على يوتيوب.

- **Open at Microsoft**: مقدمة سريعة مدتها 18 دقيقة ودليل سريع حول كيفية استخدام مترجم التعاون.

  [![Open at Microsoft](../../translated_images/open-ms-thumbnail.946b356b89bc5f0e33dcebb852f7926b98c33f54c1a49ce01c36ae7f35e2443a.ar.jpg)](https://www.youtube.com/watch?v=jX_swfH_KNU)

## المساهمة

يرحب هذا المشروع بالمساهمات والاقتراحات. هل ترغب في المساهمة في Azure Co-op Translator؟ يرجى مراجعة [CONTRIBUTING.md](./CONTRIBUTING.md) للحصول على إرشادات حول كيفية المساعدة في جعل مترجم التعاون أكثر سهولة.

## المساهمون

[![مساهمو co-op-translator](https://contrib.rocks/image?repo=Azure/co-op-translator)](https://github.com/Azure/co-op-translator/graphs/contributors)

## مدونة السلوك

اعتمد هذا المشروع [مدونة السلوك مفتوحة المصدر من Microsoft](https://opensource.microsoft.com/codeofconduct/).
لمزيد من المعلومات راجع [الأسئلة الشائعة حول مدونة السلوك](https://opensource.microsoft.com/codeofconduct/faq/) أو
تواصل عبر [opencode@microsoft.com](mailto:opencode@microsoft.com) لأي أسئلة أو تعليقات إضافية.

## الذكاء الاصطناعي المسؤول

تلتزم Microsoft بمساعدة عملائنا على استخدام منتجات الذكاء الاصطناعي لدينا بمسؤولية، ومشاركة تجاربنا، وبناء شراكات قائمة على الثقة من خلال أدوات مثل ملاحظات الشفافية وتقييمات التأثير. يمكن العثور على العديد من هذه الموارد على [https://aka.ms/RAI](https://aka.ms/RAI).
نهج Microsoft في الذكاء الاصطناعي المسؤول يستند إلى مبادئنا في الذكاء الاصطناعي التي تشمل العدالة، والموثوقية والسلامة، والخصوصية والأمان، والشمولية، والشفافية، والمساءلة.

يمكن أن تتصرف نماذج اللغة الطبيعية والصور والكلام واسعة النطاق - مثل تلك المستخدمة في هذا المثال - بطرق قد تكون غير عادلة أو غير موثوقة أو مسيئة، مما قد يسبب أضرارًا. يرجى مراجعة [ملاحظة الشفافية لخدمة Azure OpenAI](https://learn.microsoft.com/legal/cognitive-services/openai/transparency-note?tabs=text) للاطلاع على المخاطر والقيود.
النهج الموصى به للتقليل من هذه المخاطر هو تضمين نظام أمان في البنية الخاصة بك يمكنه اكتشاف ومنع السلوك الضار. يوفر [Azure AI Content Safety](https://learn.microsoft.com/azure/ai-services/content-safety/overview) طبقة حماية مستقلة، قادرة على اكتشاف المحتوى الضار الذي ينشئه المستخدمون أو الذكاء الاصطناعي في التطبيقات والخدمات. يتضمن Azure AI Content Safety واجهات برمجة تطبيقات للنصوص والصور تتيح لك اكتشاف المواد الضارة. كما لدينا استوديو تفاعلي لـ Content Safety يسمح لك بعرض واستكشاف وتجربة أمثلة على الشيفرة لاكتشاف المحتوى الضار عبر أنماط مختلفة. ترشدك وثائق [البدء السريع](https://learn.microsoft.com/azure/ai-services/content-safety/quickstart-text?tabs=visual-studio%2Clinux&pivots=programming-language-rest) التالية خلال كيفية إرسال الطلبات إلى الخدمة.

جانب آخر يجب أخذه في الاعتبار هو أداء التطبيق بشكل عام. مع التطبيقات متعددة الأنماط والنماذج، نعتبر الأداء يعني أن النظام يعمل كما تتوقع أنت ومستخدموك، بما في ذلك عدم توليد مخرجات ضارة. من المهم تقييم أداء تطبيقك العام باستخدام [مقاييس جودة التوليد والمخاطر والسلامة](https://learn.microsoft.com/azure/ai-studio/concepts/evaluation-metrics-built-in).

يمكنك تقييم تطبيق الذكاء الاصطناعي الخاص بك في بيئة التطوير باستخدام [prompt flow SDK](https://microsoft.github.io/promptflow/index.html). بناءً على مجموعة بيانات اختبار أو هدف معين، يتم قياس نتائج تطبيق الذكاء الاصطناعي التوليدي الخاص بك بشكل كمي باستخدام مقيمين مدمجين أو مقيمين مخصصين تختارهم. للبدء باستخدام prompt flow sdk لتقييم نظامك، يمكنك اتباع [دليل البدء السريع](https://learn.microsoft.com/azure/ai-studio/how-to/develop/flow-evaluate-sdk). بمجرد تنفيذ تشغيل التقييم، يمكنك [عرض النتائج في Azure AI Studio](https://learn.microsoft.com/azure/ai-studio/how-to/evaluate-flow-results).

## العلامات التجارية

قد يحتوي هذا المشروع على علامات تجارية أو شعارات لمشاريع أو منتجات أو خدمات. يخضع الاستخدام المصرح به لعلامات Microsoft التجارية أو شعاراتها ويجب أن يتبع [إرشادات العلامات التجارية والعلامات التجارية لشركة Microsoft](https://www.microsoft.com/en-us/legal/intellectualproperty/trademarks/usage/general). يجب ألا يسبب استخدام علامات Microsoft التجارية أو شعاراتها في نسخ معدلة من هذا المشروع أي لبس أو يوحي برعاية Microsoft. أي استخدام لعلامات تجارية أو شعارات لأطراف ثالثة يخضع لسياسات تلك الأطراف.

## الحصول على المساعدة

إذا واجهت صعوبة أو كان لديك أي أسئلة حول بناء تطبيقات الذكاء الاصطناعي، انضم إلى:

[![Microsoft Foundry Discord](https://dcbadge.limes.pink/api/server/nTYy5BXMWG)](https://discord.gg/nTYy5BXMWG)

إذا كان لديك ملاحظات على المنتج أو أخطاء أثناء البناء، قم بزيارة:

[![Microsoft Foundry Developer Forum](https://img.shields.io/badge/GitHub-Microsoft_Foundry_Developer_Forum-blue?style=for-the-badge&logo=github&color=000000&logoColor=fff)](https://aka.ms/foundry/forum)

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**إخلاء المسؤولية**:  
تمت ترجمة هذا المستند باستخدام خدمة الترجمة الآلية [Co-op Translator](https://github.com/Azure/co-op-translator). بينما نسعى لتحقيق الدقة، يرجى العلم أن الترجمات الآلية قد تحتوي على أخطاء أو عدم دقة. يجب اعتبار المستند الأصلي بلغته الأصلية المصدر الموثوق به. للمعلومات الهامة، يُنصح بالاعتماد على الترجمة البشرية المهنية. نحن غير مسؤولين عن أي سوء فهم أو تفسير ناتج عن استخدام هذه الترجمة.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->