<!--
CO_OP_TRANSLATOR_METADATA:
{
  "original_hash": "758ca1c5ae0d32c52d2dd59132dcfbf0",
  "translation_date": "2025-11-30T09:55:16+00:00",
  "source_file": "CONTRIBUTING.md",
  "language_code": "ar"
}
-->
# المساهمة في Co-op Translator

يرحب هذا المشروع بالمساهمات والاقتراحات. تتطلب معظم المساهمات موافقتك على اتفاقية ترخيص المساهمين (CLA) التي تُصرح بأن لديك الحق، وأنك بالفعل تمنحنا الحقوق لاستخدام مساهمتك. لمزيد من التفاصيل، قم بزيارة https://cla.opensource.microsoft.com.

عند تقديم طلب سحب (Pull Request)، سيقوم بوت CLA تلقائيًا بتحديد ما إذا كنت بحاجة إلى تقديم اتفاقية CLA وتزيين طلب السحب بشكل مناسب (مثل: فحص الحالة، تعليق). ما عليك سوى اتباع التعليمات التي يقدمها البوت. ستحتاج إلى القيام بذلك مرة واحدة فقط عبر جميع المستودعات التي تستخدم اتفاقية CLA الخاصة بنا.

## إعداد بيئة التطوير

لإعداد بيئة التطوير لهذا المشروع، نوصي باستخدام Poetry لإدارة التبعيات. نستخدم `pyproject.toml` لإدارة تبعيات المشروع، ولذلك، لتثبيت التبعيات، يجب عليك استخدام Poetry.

### إنشاء بيئة افتراضية

#### باستخدام pip

```bash
python -m venv .venv
```

#### باستخدام Poetry

```bash
poetry init
```

### تفعيل البيئة الافتراضية

#### لكل من pip وPoetry

- ويندوز:

    ```bash
    .venv\Scripts\activate.bat
    ```

- ماك/لينكس:

    ```bash
    source .venv/bin/activate
    ```

#### باستخدام Poetry

```bash
poetry shell
```

### تثبيت الحزمة والحزم المطلوبة

#### باستخدام Poetry (من pyproject.toml)

```bash
poetry install
```

### الاختبار اليدوي

قبل تقديم طلب السحب، من المهم اختبار وظيفة الترجمة باستخدام وثائق حقيقية:

1. أنشئ مجلد اختبار في الدليل الجذري:
    ```bash
    mkdir test_docs
    ```

2. انسخ بعض وثائق الماركدوان والصور التي تريد ترجمتها إلى مجلد الاختبار. على سبيل المثال:
    ```bash
    cp /path/to/your/docs/*.md test_docs/
    cp /path/to/your/images/*.png test_docs/
    ```

3. قم بتثبيت الحزمة محليًا:
    ```bash
    pip install -e .
    ```

4. شغّل Co-op Translator على مستندات الاختبار الخاصة بك:
    ```bash
    python -m co_op_translator --language-codes ko --root-dir test_docs
    ```

5. تحقق من الملفات المترجمة في `test_docs/translations` و `test_docs/translated_images` للتحقق من:
   - جودة الترجمة
   - صحة تعليقات البيانات الوصفية
   - الحفاظ على هيكل الماركدوان الأصلي
   - عمل الروابط والصور بشكل صحيح

يساعد هذا الاختبار اليدوي على ضمان أن التغييرات التي أجريتها تعمل بشكل جيد في سيناريوهات العالم الحقيقي.

### متغيرات البيئة

1. أنشئ ملف `.env` في الدليل الجذري عن طريق نسخ ملف `.env.template` المقدم.
2. املأ متغيرات البيئة حسب الإرشادات.

> [!TIP]
>
> ### خيارات إضافية لبيئة التطوير
>
> بالإضافة إلى تشغيل المشروع محليًا، يمكنك أيضًا استخدام GitHub Codespaces أو VS Code Dev Containers كخيارات بديلة لإعداد بيئة التطوير.
>
> #### GitHub Codespaces
>
> يمكنك تشغيل هذه العينات افتراضيًا باستخدام GitHub Codespaces ولا حاجة لأي إعدادات إضافية.
>
> الزر سيفتح نسخة VS Code على الويب في متصفحك:
>
> 1. افتح القالب (قد يستغرق عدة دقائق):
>
>     [![Open in GitHub Codespaces](https://github.com/codespaces/badge.svg)](https://codespaces.new/azure/co-op-translator)
>
> #### التشغيل محليًا باستخدام VS Code Dev Containers
>
> ⚠️ هذا الخيار يعمل فقط إذا كان Docker Desktop مخصصًا له على الأقل 16 جيجابايت من الذاكرة العشوائية. إذا كان لديك أقل من 16 جيجابايت، يمكنك تجربة خيار [GitHub Codespaces](../..) أو [إعداده محليًا](../..).
>
> خيار ذو صلة هو VS Code Dev Containers، الذي سيفتح المشروع في VS Code المحلي باستخدام [امتداد Dev Containers](https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers):
>
> 1. شغّل Docker Desktop (قم بتثبيته إذا لم يكن مثبتًا)
> 2. افتح المشروع:
>
>    [![Open in Dev Containers](https://img.shields.io/static/v1?style=for-the-badge&label=Dev%20Containers&message=Open&color=blue&logo=visualstudiocode)](https://vscode.dev/redirect?url=vscode://ms-vscode-remote.remote-containers/cloneInVolume?url=https://github.com/azure/co-op-translator)


### نمط الكود

نستخدم [Black](https://github.com/psf/black) كمنسق كود بايثون للحفاظ على نمط كود متسق عبر المشروع. Black هو منسق كود صارم يعيد تنسيق كود بايثون تلقائيًا ليتوافق مع نمط Black.

#### التهيئة

تم تحديد تهيئة Black في ملف `pyproject.toml` الخاص بنا:

```toml
[tool.black]
line-length = 88
target-version = ['py310']
include = '\.pyi?$'
```

#### تثبيت Black

يمكنك تثبيت Black باستخدام Poetry (موصى به) أو pip:

##### باستخدام Poetry

يتم تثبيت Black تلقائيًا عند إعداد بيئة التطوير:
```bash
poetry install
```

##### باستخدام pip

إذا كنت تستخدم pip، يمكنك تثبيت Black مباشرة:
```bash
pip install black
```

#### استخدام Black

##### مع Poetry

1. قم بتنسيق جميع ملفات بايثون في المشروع:
    ```bash
    poetry run black .
    ```

2. قم بتنسيق ملف أو مجلد محدد:
    ```bash
    poetry run black path/to/file_or_directory
    ```

##### مع pip

1. قم بتنسيق جميع ملفات بايثون في المشروع:
    ```bash
    black .
    ```

2. قم بتنسيق ملف أو مجلد محدد:
    ```bash
    black path/to/file_or_directory
    ```

> [!TIP]
> نوصي بضبط محررك ليقوم تلقائيًا بتنسيق الكود باستخدام Black عند الحفظ. معظم المحررات الحديثة تدعم ذلك عبر الإضافات أو البلجنات.

## تشغيل Co-op Translator

لتشغيل Co-op Translator باستخدام Poetry في بيئتك، اتبع الخطوات التالية:

1. انتقل إلى الدليل حيث تريد إجراء اختبارات الترجمة أو أنشئ مجلدًا مؤقتًا لأغراض الاختبار.

2. نفذ الأمر التالي. استبدل `-l ko` برمز اللغة التي ترغب في الترجمة إليها. العلم `-d` يشير إلى وضع التصحيح.

    ```bash
    poetry run co-op-translator translate -l ko -d
    ```

> [!NOTE]
> تأكد من تفعيل بيئة Poetry الخاصة بك (poetry shell) قبل تشغيل الأمر.

## المساهمة بلغة جديدة

نرحب بالمساهمات التي تضيف دعمًا للغات جديدة. قبل فتح طلب سحب، يرجى إكمال الخطوات أدناه لضمان مراجعة سلسة.

1. أضف اللغة إلى تعيين الخطوط
   - حرر `src/co_op_translator/fonts/font_language_mappings.yml`
   - أضف إدخالًا يحتوي على:
     - `code`: رمز اللغة على غرار ISO (مثلاً `vi`)
     - `name`: اسم العرض الودي للبشر
     - `font`: خط مرفق في `src/co_op_translator/fonts/` يدعم النص
     - `rtl`: `true` إذا كانت اللغة تكتب من اليمين إلى اليسار، وإلا `false`

2. أدرج ملفات الخطوط المطلوبة (إذا لزم الأمر)
   - إذا كان هناك حاجة لخط جديد، تحقق من توافق الترخيص مع التوزيع مفتوح المصدر
   - أضف ملف الخط إلى `src/co_op_translator/fonts/`

3. التحقق محليًا
   - شغّل الترجمات على عينة صغيرة (ماركدوان، صور، ودفاتر ملاحظات حسب الاقتضاء)
   - تحقق من أن المخرجات تعرض بشكل صحيح، بما في ذلك الخطوط وأي تخطيط RTL إذا كان ذلك مناسبًا

4. تحديث الوثائق
   - تأكد من ظهور اللغة في `getting_started/supported-languages.md`
   - لا حاجة لتغييرات في `getting_started/README_languages_template.md`؛ يتم إنشاؤه من القائمة المدعومة

5. افتح طلب سحب
   - وصف اللغة المضافة وأي اعتبارات تتعلق بالخط أو الترخيص
   - أرفق لقطات شاشة للمخرجات المعروضة إذا أمكن

مثال على إدخال YAML:

```yaml
new_lang(code):
  name: "New Language"
  font: "NotoSans-Medium.ttf"
  rtl: false
```

### اختبار اللغة الجديدة

يمكنك اختبار اللغة الجديدة بتشغيل الأمر التالي:

```bash
# إنشاء وتفعيل بيئة افتراضية
python -m venv .venv
# ويندوز
.venv\Scripts\activate
# ماك أو إس/لينكس
source .venv/bin/activate
# تثبيت حزمة التطوير
pip install -e .
# تشغيل الترجمة
translate -l "new_lang"
```

## القائمون على الصيانة

### رسالة الالتزام واستراتيجية الدمج

لضمان الاتساق والوضوح في سجل الالتزامات الخاص بمشروعنا، نتبع تنسيقًا محددًا لرسائل الالتزام **لرسالة الالتزام النهائية** عند استخدام استراتيجية **Squash and Merge**.

عند دمج طلب سحب (PR)، سيتم دمج الالتزامات الفردية في التزام واحد. يجب أن تتبع رسالة الالتزام النهائية التنسيق أدناه للحفاظ على سجل نظيف ومتسق.

#### تنسيق رسالة الالتزام (لـ squash and merge)

نستخدم التنسيق التالي لرسائل الالتزام:

```bash
<type>: <description> (#<رقم PR>)
```

- **type**: يحدد فئة الالتزام. نستخدم الأنواع التالية:
  - `Docs`: لتحديثات التوثيق.
  - `Build`: للتغييرات المتعلقة بنظام البناء أو التبعيات، بما في ذلك تحديثات ملفات التهيئة، سير عمل CI، أو ملف Dockerfile.
  - `Core`: لتعديلات على الوظائف الأساسية للمشروع أو الميزات، خصوصًا تلك التي تتضمن ملفات في `src/co_op_translator/core`.

- **description**: ملخص موجز للتغيير.
- **PR number**: رقم طلب السحب المرتبط بالالتزام.

**أمثلة**:

- `Docs: تحديث تعليمات التثبيت لتكون أوضح (#50)`
- `Core: تحسين معالجة ترجمة الصور (#60)`

> [!NOTE]
> حاليًا، تُضاف بادئات **`Docs`**، **`Core`**، و**`Build`** تلقائيًا إلى عناوين طلبات السحب بناءً على التصنيفات المطبقة على الكود المصدر المعدل. طالما تم تطبيق التصنيف الصحيح، عادة لا تحتاج إلى تحديث عنوان طلب السحب يدويًا. فقط تحقق من أن كل شيء صحيح وأن البادئة تم إنشاؤها بشكل مناسب.

#### استراتيجية الدمج

نستخدم **Squash and Merge** كاستراتيجيتنا الافتراضية لطلبات السحب. تضمن هذه الاستراتيجية أن رسائل الالتزام تتبع تنسيقنا، حتى لو لم تكن الالتزامات الفردية كذلك.

**الأسباب**:

- سجل مشروع نظيف وخطي.
- اتساق في رسائل الالتزام.
- تقليل الضوضاء من الالتزامات الصغيرة (مثل "تصحيح خطأ مطبعي").

عند الدمج، تأكد من أن رسالة الالتزام النهائية تتبع تنسيق رسالة الالتزام الموضح أعلاه.

**مثال على Squash and Merge**
إذا كان طلب السحب يحتوي على الالتزامات التالية:

- `fix typo`
- `update README`
- `adjust formatting`

يجب دمجها في:
`Docs: تحسين وضوح وتنسيق التوثيق (#65)`

### عملية الإصدار

يصف هذا القسم أبسط طريقة للقائمين على الصيانة لنشر إصدار جديد من Co-op Translator.

#### 1. رفع الإصدار في `pyproject.toml`

1. قرر رقم الإصدار التالي (نتبع الترقيم الدلالي: `MAJOR.MINOR.PATCH`).
2. حرر `pyproject.toml` وقم بتحديث حقل `version` تحت `[tool.poetry]`.
3. افتح طلب سحب مخصص يغير فقط الإصدار (وأي ملفات قفل/بيانات وصفية يتم تحديثها تلقائيًا، إذا وجدت).
4. بعد المراجعة، استخدم **Squash and Merge** وتأكد من أن رسالة الالتزام النهائية تتبع التنسيق الموضح أعلاه.

#### 2. إنشاء إصدار على GitHub

1. اذهب إلى صفحة مستودع GitHub وافتح **Releases** → **Draft a new release**.
2. أنشئ وسمًا جديدًا (مثلاً، `v0.13.0`) من فرع `main`.
3. عيّن عنوان الإصدار إلى نفس رقم الإصدار (مثلاً، `v0.13.0`).
4. انقر على **Generate release notes** لملء سجل التغييرات تلقائيًا.
5. اختياريًا، حرر النص (مثلاً، لتسليط الضوء على اللغات المدعومة حديثًا أو التغييرات المهمة).
6. انشر الإصدار.

---

<!-- CO-OP TRANSLATOR DISCLAIMER START -->
**إخلاء المسؤولية**:  
تمت ترجمة هذا المستند باستخدام خدمة الترجمة الآلية [Co-op Translator](https://github.com/Azure/co-op-translator). بينما نسعى لتحقيق الدقة، يرجى العلم أن الترجمات الآلية قد تحتوي على أخطاء أو عدم دقة. يجب اعتبار المستند الأصلي بلغته الأصلية المصدر الموثوق به. للمعلومات الهامة، يُنصح بالاعتماد على الترجمة البشرية المهنية. نحن غير مسؤولين عن أي سوء فهم أو تفسير ناتج عن استخدام هذه الترجمة.
<!-- CO-OP TRANSLATOR DISCLAIMER END -->