## Purpose

<!-- Describe the intention of the changes being proposed. What problem does it solve or functionality does it add? -->

## Description

<!-- Provide a concise summary of your changes. Why is this change necessary? -->

## Related Issue

<!-- If this PR addresses an issue, please link it here (e.g., Fixes #123) -->

## Does this introduce a breaking change?

When developers merge from main and run the server, azd up, or azd deploy, will this produce an error?
If you're not sure, try it out on an old environment.

- [ ] Yes
- [ ] No

## Type of change

- [ ] Bugfix
- [ ] Feature
- [ ] Code style update (e.g., formatting, local variables)
- [ ] Refactoring (no functional or API changes)
- [ ] Documentation content changes
- [ ] Other... Please describe:

## Checklist

Before submitting your pull request, please confirm the following:

- [ ] **I have thoroughly tested my changes**: I confirm that I have run the code and manually tested all affected areas.
- [ ] **All existing tests pass**: I have run all tests and confirmed that nothing is broken.
- [ ] **I have added new tests** (if applicable): I have written tests that cover the new functionality introduced by my code changes.
- [ ] **I have followed the Co-op Translators coding conventions**: My code adheres to the style guide and coding conventions outlined in the repository.
- [ ] **I have documented my changes** (if applicable): I have updated the documentation to reflect the changes where necessary.

## Additional context

<!-- Add any additional context or screenshots if applicable -->
