# 常见问题

- [常见问题](#常见问题)
  - [软件无法运行/闪退/报错](#软件无法运行闪退报错)
    - [下载/安装问题](#下载安装问题)
    - [运行中闪退](#运行中闪退)
    - [运行库问题（Windows）](#运行库问题windows)
    - [Agent 长时间启动无反应（Windows）](#agent-长时间启动无反应windows)
    - [资源加载问题](#资源加载问题)
    - [连接问题](#连接问题)
      - [1. 确认 ADB 及连接地址正确](#1-确认-adb-及连接地址正确)
      - [2. 关闭现有 ADB 进程](#2-关闭现有-adb-进程)
      - [3. 正确使用多个 ADB](#3-正确使用多个-adb)
      - [4. 更换触控方式](#4-更换触控方式)
      - [5. 改用 MaaPiCli](#5-改用-maapicli)
      - [6. 避免游戏加速器](#6-避免游戏加速器)
      - [7. 重启电脑](#7-重启电脑)
      - [8. 换模拟器](#8-换模拟器)
  - [文件下载速度慢](#文件下载速度慢)
  - [其他问题](#其他问题)

## 软件无法运行/闪退/报错

大部分的问题都能在这个章节解决。  
分成下载/安装问题、运行库问题、Agent 长时间启动无反应、资源加载问题以及连接问题五类。  
其中大部分问题都属于**运行库问题**和**连接问题**。

### 下载/安装问题

完整 MaaGumballs 软件压缩包命名格式为 "MaaGumballs-`平台`-`架构`-`版本`.zip"，其余均为无法单独使用的“零部件”，请仔细阅读。  
~~在大部分情况下，您需要使用 x64 架构的 MaaGumballs，即您需要下载 `MaaGumballs-win-x86_64-vXXX.zip`，而非`MaaGumballs-win-aarch64-vXXX.zip`。~~  
MaaGumballs Windows 已不支持该架构

### 运行中闪退

当您有独立显卡且开启GPU加速时，可能会出现该问题。

> 解决方案:
>
> 使用 MaaPiCli： 将 `config/maa_pi_config.json` 里的 `gpu` 字段的值改成 -2，即禁用 GPU。
>
> 使用 MFAWPF：在[设置]-[性能设置]里将[启用GPU加速]取消勾选

### 运行库问题（Windows）

打开软件有以下特征时，说明需要更新运行库：

1. 使用 MFA 时，出现

    ```plaintext
    MFA 遇到了问题
    “对类型“MFAWPF.Views.MainWindow”的构造函数执行符合指定的绑定约束的调用时引发了异常。”，行号为“14”，行位置为“24”。
    Unable to load DLL 'MaaToolkit' or one of its dependencies: 动态链接库(DLL)初始化例程失败。 (0x8007045A)
    详细信息
    System.Windows.Markup.XamlParseException: “对类型“MFAWPF.Views.MainWindow”的构造函数执行符合指定的绑定约束的调用时引发了异常。”，行号为“14”，行位置为“24”。
    ---> System.DllNotFoundException: Unable to load DLL 'MaaToolkit' or one of its dependencies: 动态链接库(DLL)初始化例程失败。 (0x8007045A)
    ```

2. 在使用 MaaPiCli 时，出现 `应用程序错误：应用程序无法正常启动`

以上一般便是运行库问题，需要[更新运行库](./新手上路.md#2-安装运行库)

若更新运行库后仍然无法解决，以上两种启动方法均**闪退**，且在当前目录不生成任何日志文件，则是其它依赖相关问题。  
请到[项目Issues页面](https://github.com/KhazixW2/MaaGumballs/issues)反馈。

### Agent 长时间启动无反应（Windows）

使用通用 UI（如 MFAAvalonia）时，长时间无反应，或提示 `...No such file or directory`，需要重新下载完整包。

### 资源加载问题

问题出现时提示**资源加载失败**。  
解决方法是删除整个文件夹，然后[重新下载](https://github.com/KhazixW2/MaaGumballs/issues)安装 MaaGB 。

### 连接问题

问题出现时提示**连接模拟器时发生错误**。  
造成连接失败有很多原因，请按下面的步骤一步步尝试。

#### 1. 确认 ADB 及连接地址正确

参阅 [连接设置](./连接设置.md#连接设置)

> [!TIP]
>
> 不要连到别的模拟器/设备去了！

#### 2. 关闭现有 ADB 进程

关闭 MaaGumballs 后查找 `任务管理器` - `详细信息` 中有无名称包含 `adb` 的进程，如有，结束它后重试连接。

#### 3. 正确使用多个 ADB

当 ADB 版本不同时，新启动的进程会关闭旧的进程。因此在需要同时运行多个 ADB，如 MAA、 Android Studio、Alas、手机助手时，请确认它们的版本相同。

#### 4. 更换触控方式

部分模拟器（如蓝叠中国、夜神等）可能 adb 版本较低，可以尝试更换 adb 或**更换触控方式**。

#### 5. 改用 MaaPiCli

若您使用 MFAWPF 连接失败，请尝试改用 MaaPiCli。[使用说明](MaaPiCli.md)

#### 6. 避免游戏加速器

部分加速器在启动加速和停止加速之后，都需要重启 MAA、ADB 和模拟器再连接。

同时使用 UU 加速器 和 MuMu 12 可以参考[官方文档](https://mumu.163.com/help/20240321/35047_1144608.html)。

#### 7. 重启电脑

重启能解决 97% 的问题。（确信

#### 8. 换模拟器

请参阅 [模拟器和设备支持](https://maa.plus/docs/zh-cn/manual/device/)。  
通常来说，建议使用 MuMu12 或雷电9。

## 文件下载速度慢

1. 使用[Mirror酱](Mirror酱.md)更新  
2. 求助群友/到网上查询相关办法。

## 其他问题

当您**确定已经阅读过以上常见问题**并**尝试自行解决无果**后，您可以：

1. 到[项目Issues页面](https://github.com/KhazixW2/MaaGumballs/issues) ，**根据模板要求**提交相关材料。
2. MaaGumballs 交流群 QQ 群：853222152，在**阅读完群公告**后提问。
