# 项目结构

- [项目结构](#项目结构)
  - [`.github`](#github)
    - [`.github/ISSUE_TEMPLATE`](#githubissue_template)
    - [`.github/workflows`](#githubworkflows)
    - [`.github/cliff.toml`](#githubclifftoml)
  - [`.vscode`](#vscode)
  - [`agent`](#agent)
    - [`agent/action`](#agentaction)
      - [`agent/action/fight`](#agentactionfight)
      - [`agent/action/divineForgeLand`](#agentactiondivineforgeland)
    - [`agent/utils`](#agentutils)
    - [`agent/main.py`](#agentmainpy)
    - [`agent/agent_allfile.py`](#agentagent_allfilepy)
  - [`assets`](#assets)
    - [`assets/MaaCommonAssets`](#assetsmaacommonassets)
    - [`assets/resource`](#assetsresource)
      - [`assets/resource/base`](#assetsresourcebase)
        - [`assets/resource/base/image`](#assetsresourcebaseimage)
        - [`assets/resource/base/model`](#assetsresourcebasemodel)
        - [`assets/resource/base/pipeline`](#assetsresourcebasepipeline)
        - [`assets/resource/base/default_pipeline.json`](#assetsresourcebasedefault_pipelinejson)
      - [`assets/resource/4399`](#assetsresource4399)
      - [`assets/resource/bilibili`](#assetsresourcebilibili)
      - [`assets/resource/hk_tw`](#assetsresourcehk_tw)
      - [`assets/resource/huawei`](#assetsresourcehuawei)
      - [`assets/resource/mi`](#assetsresourcemi)
      - [`assets/resource/oppo`](#assetsresourceoppo)
      - [`assets/resource/vivo`](#assetsresourcevivo)
    - [`assets/interface.json`](#assetsinterfacejson)
  - [`docs`](#docs)
    - [`docs/zh_cn`](#docszh_cn)
      - [`docs/zh_cn/dev`](#docszh_cndev)
      - [`docs/zh_cn/manual`](#docszh_cnmanual)
    - [`docs/.markdownlint.yaml`](#docsmarkdownlintyaml)
  - [`tools`](#tools)
    - [`tools/ImageCropper`](#toolsimagecropper)
    - [`tools/ci`](#toolsci)
    - [`tools/configure.py`](#toolsconfigurepy)
    - [`tools/install.py`](#toolsinstallpy)
  - [`.gitignore`](#gitignore)
  - [`.gitmodules`](#gitmodules)
  - [`.pre-commit-config.yaml`](#pre-commit-configyaml)
  - [`.prettierrc`](#prettierrc)
  - [`LICENSE`](#license)
  - [`package-lock.json&package.json`](#package-lockjsonpackagejson)
  - [`README.md`](#readmemd)
  - [`requirements.txt`](#requirementstxt)
  - [`TodoList.md`](#todolistmd)
  - [`logo.ico`](#logoico)

以下为本项目当前实际的项目结构及说明。

## `.github`

GitHub 配置目录。

### `.github/ISSUE_TEMPLATE`

GitHub Issue 模板，包含中英文的 Bug 报告、功能请求和其他问题模板。

### `.github/workflows`

GitHub Actions 工作流配置，包含：

- `check.yml` - 代码检查工作流
- `install.yml` - 安装测试工作流
- `mirrorchyan.yml` - 镜像同步工作流
- `mirrorchyan_release_note.yml` - 发布说明生成工作流

### `.github/cliff.toml`

cliff 配置文件，用于自动生成 release note。

## `.vscode`

VSCode 编辑器配置，包含插件推荐和编辑器设置。

## `agent`

存放 Agent 相关代码，包含游戏自动化脚本的核心逻辑。

### `agent/action`

存放游戏动作模块，包含各种游戏操作的实现：

- `count.py` - 计数相关功能
- `dailyTask.py` - 每日任务模块
- `reward.py` - 奖励领取模块
- `shopping.py` - 购物模块
- `utils.py` - 通用工具函数

#### `agent/action/fight`

战斗相关模块（注意：文件夹名为小写 fight）：

- `checkGrid.py` - 网格检查
- `fightUtils.py` - 战斗工具函数
- `getKeyFromHole.py` - 从洞穴获取钥匙
- `jjc101.py` - 竞技场101层功能
- `tl01_Fighting.py` - TL01战斗模块

#### `agent/action/divineForgeLand`

神锻之地相关模块：

- `floor.py` - 楼层处理
- `someTrick.py` - 一些技巧和策略

### `agent/utils`

通用工具函数模块：

- `__init__.py` - 模块初始化文件
- `logger.py` - 日志记录工具
- `time.py` - 时间处理工具

### `agent/main.py`

Agent 主入口文件，负责启动前的流程处理以及启动 AgentServer。

### `agent/agent_allfile.py`

Agent 总文件，集中导入所有功能模块，方便统一管理和调用。

## `assets`

存放项目资源文件。

### `assets/MaaCommonAssets`

存放 Maa 通用资源，如 OCR 模型等。

### `assets/resource`

存放项目资源文件，按不同平台和服务器分类。

#### `assets/resource/base`

存放基础资源，作为其他平台资源的覆盖基础。

##### `assets/resource/base/image`

存放模板图片，用于图像识别。

##### `assets/resource/base/model`

存放 OCR 模型、神经网络分类模型、神经网络检测模型。参考 [烹饪指南](https://github.com/MaaXYZ/MaaNeuralNetworkCookbook)。

##### `assets/resource/base/pipeline`

JSON 文件，用于描述任务流水线，参考 [任务流水线协议](https://github.com/MaaXYZ/MaaFramework/blob/main/docs/zh_cn/3.1-%E4%BB%BB%E5%8A%A1%E6%B5%81%E6%B0%B4%E7%BA%BF%E5%8D%8F%E8%AE%AE.md) 编写。

##### `assets/resource/base/default_pipeline.json`

设置 pipeline 中默认属性，参考 [default_pipeline.json](https://github.com/MaaXYZ/MaaFramework/blob/main/sample/resource/default_pipeline.json)。

#### `assets/resource/4399`

存放4399平台专用资源。

#### `assets/resource/bilibili`

存放B站服务器专用资源，覆盖基础资源。

#### `assets/resource/hk_tw`

存放港台服务器专用资源。

#### `assets/resource/huawei`

存放华为平台专用资源。

#### `assets/resource/mi`

存放小米平台专用资源。

#### `assets/resource/oppo`

存放OPPO平台专用资源。

#### `assets/resource/vivo`

存放vivo平台专用资源。

### `assets/interface.json`

MaaFramework 的标准化项目结构声明，遵循 [Project Interface 协议](https://github.com/MaaXYZ/MaaFramework/blob/main/docs/zh_cn/3.2-ProjectInterface%E5%8D%8F%E8%AE%AE.md)。

## `docs`

用户手册和开发文档。

### `docs/zh_cn`

中文文档目录。

#### `docs/zh_cn/dev`

开发文档，包含项目结构说明等开发相关文档。

#### `docs/zh_cn/manual`

用户手册，包含功能介绍和使用说明。

### `docs/.markdownlint.yaml`

Markdown 代码风格检查配置。

## `tools`

项目工具集合。

### `tools/ImageCropper`

图像裁剪工具，包含：

- `main.py` - 主程序
- `colormatcher.py` - 颜色匹配
- `roi.py` - 感兴趣区域处理
- `roimage.py` - ROI图像处理
- `requirements.txt` - Python依赖
- `install.bat` / `start.bat` - Windows批处理脚本
- `README.md` - 工具说明

### `tools/ci`

持续集成相关工具：

- `setup_embed_python.py` - Python环境设置脚本
- `setup_pip.py` - pip设置脚本

### `tools/configure.py`

配置工具，将 MaaCommonAssets 复制到 resource 中。

### `tools/install.py`

安装工具，将源码和依赖组装后放入 `install` 目录。

### 其他工具文件

- `check_paths.py` - 路径检查工具
- `check_resource.py` - 资源检查工具
- `interface.schema.json` - 接口模式定义
- `interface_config.schema.json` - 接口配置模式定义
- `pipeline.schema.json` - 流水线模式定义

## `.gitignore`

Git 忽略文件清单。

## `.gitmodules`

Git 子模块配置。

## `.pre-commit-config.yaml`

pre-commit 钩子配置，用于代码提交前的自动检查。

## `.prettierrc`

Prettier 代码格式化配置文件。

## `LICENSE`

开源许可证文件。

## `package-lock.json&package.json`

Node.js 包管理文件，主要用于 Prettier 等前端工具的依赖管理。

## `README.md`

项目说明文档，包含项目介绍、安装和使用方法。

## `requirements.txt`

Python 依赖列表，包含 Agent 运行所需的 Python 包。

## `TodoList.md`

项目待办事项列表。

## `logo.ico`

项目图标文件。
