/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;
import net.minecraftforge.server.command.TextComponentHelper;
import net.minecraftforge.server.timings.ForgeTimings;
import net.minecraftforge.server.timings.TimeTracker;

class CommandTrack
extends CommandTreeBase {
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#####0.00");

    public CommandTrack() {
        this.addSubcommand(new StartTrackingCommand());
        this.addSubcommand(new ResetTrackingCommand());
        this.addSubcommand(new TrackResultsTileEntity());
        this.addSubcommand(new TrackResultsEntity());
        this.addSubcommand(new CommandTreeHelp(this));
    }

    @Override
    public String getName() {
        return "track";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return "commands.forge.tracking.usage";
    }

    private static class StartTrackingCommand
    extends CommandBase {
        private StartTrackingCommand() {
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length != 2) {
                throw new WrongUsageException(this.getUsage(sender), new Object[0]);
            }
            String type = args[0];
            int duration = StartTrackingCommand.parseInt(args[1], 1, 60);
            if ("te".equals(type)) {
                TimeTracker.TILE_ENTITY_UPDATE.reset();
                TimeTracker.TILE_ENTITY_UPDATE.enable(duration);
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.te.enabled", duration));
            } else if ("entity".equals(type)) {
                TimeTracker.ENTITY_UPDATE.reset();
                TimeTracker.ENTITY_UPDATE.enable(duration);
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.entity.enabled", duration));
            } else {
                throw new WrongUsageException(this.getUsage(sender), new Object[0]);
            }
        }

        @Override
        public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return Arrays.asList("te", "entity");
        }

        @Override
        public String getName() {
            return "start";
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 2;
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return "commands.forge.tracking.start.usage";
        }
    }

    private static class ResetTrackingCommand
    extends CommandBase {
        private ResetTrackingCommand() {
        }

        @Override
        public String getName() {
            return "reset";
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return "commands.forge.tracking.reset.usage";
        }

        @Override
        public int getRequiredPermissionLevel() {
            return 2;
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length != 1) {
                throw new WrongUsageException(this.getUsage(sender), new Object[0]);
            }
            String type = args[0];
            if ("te".equals(type)) {
                TimeTracker.TILE_ENTITY_UPDATE.reset();
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.reset", new Object[0]));
            } else if ("entity".equals(type)) {
                TimeTracker.ENTITY_UPDATE.reset();
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.reset", new Object[0]));
            } else {
                throw new WrongUsageException(this.getUsage(sender), new Object[0]);
            }
        }

        @Override
        public List<String> getTabCompletions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            return Arrays.asList("te", "entity");
        }
    }

    private static class TrackResultsTileEntity
    extends TrackResultsBaseCommand<TileEntity> {
        public TrackResultsTileEntity() {
            super(TimeTracker.TILE_ENTITY_UPDATE);
        }

        @Override
        public String getName() {
            return "te";
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return "commands.forge.tracking.te.usage";
        }

        @Override
        protected ITextComponent buildTrackString(ICommandSender sender, ForgeTimings<TileEntity> data) {
            TileEntity te = (TileEntity)data.getObject().get();
            if (te == null) {
                return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.invalid", new Object[0]);
            }
            String name = this.getTileEntityName(te);
            BlockPos pos = te.getPos();
            double averageTimings = data.getAverageTimings();
            String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + this.getTimeSuffix(averageTimings);
            return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.timingEntry", name, this.getWorldName(te.getWorld().provider.getDimension()), pos.getX(), pos.getY(), pos.getZ(), tickTime);
        }

        private String getTileEntityName(TileEntity tileEntity) {
            ResourceLocation registryId = TileEntity.getKey(tileEntity.getClass());
            if (registryId == null) {
                return tileEntity.getClass().getSimpleName();
            }
            return registryId.toString();
        }
    }

    private static class TrackResultsEntity
    extends TrackResultsBaseCommand<Entity> {
        public TrackResultsEntity() {
            super(TimeTracker.ENTITY_UPDATE);
        }

        @Override
        public String getName() {
            return "entity";
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return "commands.forge.tracking.entity.usage";
        }

        @Override
        protected ITextComponent buildTrackString(ICommandSender sender, ForgeTimings<Entity> data) {
            Entity entity = (Entity)data.getObject().get();
            if (entity == null) {
                return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.invalid", new Object[0]);
            }
            BlockPos currentPos = entity.getPosition();
            String world = this.getWorldName(entity.world.provider.getDimension());
            double averageTimings = data.getAverageTimings();
            String tickTime = (averageTimings > 1000.0 ? TIME_FORMAT.format(averageTimings / 1000.0) : TIME_FORMAT.format(averageTimings)) + this.getTimeSuffix(averageTimings);
            return TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.timingEntry", entity.getName(), world, currentPos.getX(), currentPos.getY(), currentPos.getZ(), tickTime);
        }
    }

    private static abstract class TrackResultsBaseCommand<T>
    extends CommandBase {
        private TimeTracker<T> tracker;

        protected TrackResultsBaseCommand(TimeTracker<T> tracker) {
            this.tracker = tracker;
        }

        protected List<ForgeTimings<T>> getSortedTimings() {
            ArrayList<ForgeTimings<T>> list = new ArrayList<ForgeTimings<T>>();
            list.addAll((Collection<ForgeTimings<T>>)this.tracker.getTimingData());
            list.sort(Comparator.comparingDouble(ForgeTimings::getAverageTimings));
            Collections.reverse(list);
            return list;
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            List<ForgeTimings<T>> timingsList = this.getSortedTimings();
            if (timingsList.isEmpty()) {
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tracking.noData", new Object[0]));
            } else {
                timingsList.stream().filter(timings -> timings.getObject().get() != null).limit(10L).forEach(timings -> sender.sendMessage(this.buildTrackString(sender, (ForgeTimings<T>)timings)));
            }
        }

        protected abstract ITextComponent buildTrackString(ICommandSender var1, ForgeTimings<T> var2);

        protected String getTimeSuffix(double time) {
            if (time < 1000.0) {
                return "\u00b5s";
            }
            return "ms";
        }

        protected String getWorldName(int dimId) {
            DimensionType type = DimensionManager.getProviderType(dimId);
            if (type == null) {
                return "Dim " + dimId;
            }
            return type.getName();
        }
    }
}

