/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import java.text.DecimalFormat;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.server.command.TextComponentHelper;

class CommandTps
extends CommandBase {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.000");

    CommandTps() {
    }

    @Override
    public String getName() {
        return "tps";
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return "commands.forge.tps.usage";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public boolean checkPermission(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int dim = 0;
        boolean summary = true;
        if (args.length > 0) {
            dim = CommandTps.parseInt(args[0]);
            summary = false;
        }
        if (summary) {
            for (Integer dimId : DimensionManager.getIDs()) {
                double worldTickTime = (double)CommandTps.mean(server.worldTickTimes.get(dimId)) * 1.0E-6;
                double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
                sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tps.summary", CommandTps.getDimensionPrefix(dimId), TIME_FORMATTER.format(worldTickTime), TIME_FORMATTER.format(worldTPS)));
            }
            double meanTickTime = (double)CommandTps.mean(server.tickTimeArray) * 1.0E-6;
            double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
            sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tps.summary", "Overall", TIME_FORMATTER.format(meanTickTime), TIME_FORMATTER.format(meanTPS)));
        } else {
            double worldTickTime = (double)CommandTps.mean(server.worldTickTimes.get(dim)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            sender.sendMessage(TextComponentHelper.createComponentTranslation(sender, "commands.forge.tps.summary", CommandTps.getDimensionPrefix(dim), TIME_FORMATTER.format(worldTickTime), TIME_FORMATTER.format(worldTPS)));
        }
    }

    private static String getDimensionPrefix(int dimId) {
        DimensionType providerType = DimensionManager.getProviderType(dimId);
        if (providerType == null) {
            return String.format("Dim %2d", dimId);
        }
        return String.format("Dim %2d (%s)", dimId, providerType.getName());
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

