/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.reflect.TypeToken;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IRegistryDelegate;
import net.minecraftforge.registries.RegistryDelegate;

public interface IForgeRegistryEntry<V> {
    public V setRegistryName(ResourceLocation var1);

    @Nullable
    public ResourceLocation getRegistryName();

    public Class<V> getRegistryType();

    public static class Impl<T extends IForgeRegistryEntry<T>>
    implements IForgeRegistryEntry<T> {
        private TypeToken<T> token = new TypeToken<T>(this.getClass()){};
        public final IRegistryDelegate<T> delegate = new RegistryDelegate<Impl>(this, this.token.getRawType());
        private ResourceLocation registryName = null;

        public final T setRegistryName(String name) {
            if (this.getRegistryName() != null) {
                throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + String.valueOf(this.getRegistryName()));
            }
            this.registryName = GameData.checkPrefix(name, true);
            return (T)this;
        }

        @Override
        public final T setRegistryName(ResourceLocation name) {
            return this.setRegistryName(name.toString());
        }

        public final T setRegistryName(String modID, String name) {
            return this.setRegistryName(modID + ":" + name);
        }

        @Override
        @Nullable
        public final ResourceLocation getRegistryName() {
            if (this.delegate.name() != null) {
                return this.delegate.name();
            }
            return this.registryName != null ? this.registryName : null;
        }

        @Override
        public final Class<T> getRegistryType() {
            return this.token.getRawType();
        }
    }
}

