/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreIngredient
extends Ingredient {
    private NonNullList<ItemStack> ores;
    private IntList itemIds = null;
    private ItemStack[] array = null;
    private int lastSizeA = -1;
    private int lastSizeL = -1;

    public OreIngredient(String ore) {
        super(0);
        this.ores = OreDictionary.getOres(ore);
    }

    @Override
    @Nonnull
    public ItemStack[] getMatchingStacks() {
        if (this.array == null || this.lastSizeA != this.ores.size()) {
            NonNullList<ItemStack> lst = NonNullList.create();
            for (ItemStack itemstack : this.ores) {
                if (itemstack.getMetadata() == Short.MAX_VALUE) {
                    itemstack.getItem().getSubItems(CreativeTabs.SEARCH, lst);
                    continue;
                }
                lst.add(itemstack);
            }
            this.array = lst.toArray(new ItemStack[lst.size()]);
            this.lastSizeA = this.ores.size();
        }
        return this.array;
    }

    @Override
    @Nonnull
    public IntList getValidItemStacksPacked() {
        if (this.itemIds == null || this.lastSizeL != this.ores.size()) {
            this.itemIds = new IntArrayList(this.ores.size());
            for (ItemStack itemstack : this.ores) {
                if (itemstack.getMetadata() == Short.MAX_VALUE) {
                    NonNullList<ItemStack> lst = NonNullList.create();
                    itemstack.getItem().getSubItems(CreativeTabs.SEARCH, lst);
                    for (ItemStack item : lst) {
                        this.itemIds.add(RecipeItemHelper.pack(item));
                    }
                    continue;
                }
                this.itemIds.add(RecipeItemHelper.pack(itemstack));
            }
            this.itemIds.sort(IntComparators.NATURAL_COMPARATOR);
            this.lastSizeL = this.ores.size();
        }
        return this.itemIds;
    }

    @Override
    public boolean apply(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (ItemStack target : this.ores) {
            if (!OreDictionary.itemMatches(target, input, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void invalidate() {
        this.itemIds = null;
        this.array = null;
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

