/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreIngredient;

public class OreDictionary {
    private static final boolean DEBUG = false;
    private static boolean hasInit = false;
    private static List<String> idToName = new ArrayList<String>();
    private static Map<String, Integer> nameToId = new HashMap<String, Integer>(128);
    private static List<NonNullList<ItemStack>> idToStack = Lists.newArrayList();
    private static List<NonNullList<ItemStack>> idToStackUn = Lists.newArrayList();
    private static Map<Integer, List<Integer>> stackToId = Maps.newHashMapWithExpectedSize((int)96);
    public static final NonNullList<ItemStack> EMPTY_LIST = NonNullList.create();
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;

    private static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new ItemStack(Blocks.LOG, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("logWood", new ItemStack(Blocks.LOG2, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("plankWood", new ItemStack(Blocks.PLANKS, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("slabWood", new ItemStack(Blocks.WOODEN_SLAB, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("stairWood", Blocks.OAK_STAIRS);
            OreDictionary.registerOre("stairWood", Blocks.SPRUCE_STAIRS);
            OreDictionary.registerOre("stairWood", Blocks.BIRCH_STAIRS);
            OreDictionary.registerOre("stairWood", Blocks.JUNGLE_STAIRS);
            OreDictionary.registerOre("stairWood", Blocks.ACACIA_STAIRS);
            OreDictionary.registerOre("stairWood", Blocks.DARK_OAK_STAIRS);
            OreDictionary.registerOre("fenceWood", Blocks.OAK_FENCE);
            OreDictionary.registerOre("fenceWood", Blocks.SPRUCE_FENCE);
            OreDictionary.registerOre("fenceWood", Blocks.BIRCH_FENCE);
            OreDictionary.registerOre("fenceWood", Blocks.JUNGLE_FENCE);
            OreDictionary.registerOre("fenceWood", Blocks.DARK_OAK_FENCE);
            OreDictionary.registerOre("fenceWood", Blocks.ACACIA_FENCE);
            OreDictionary.registerOre("fenceGateWood", Blocks.OAK_FENCE_GATE);
            OreDictionary.registerOre("fenceGateWood", Blocks.SPRUCE_FENCE_GATE);
            OreDictionary.registerOre("fenceGateWood", Blocks.BIRCH_FENCE_GATE);
            OreDictionary.registerOre("fenceGateWood", Blocks.JUNGLE_FENCE_GATE);
            OreDictionary.registerOre("fenceGateWood", Blocks.DARK_OAK_FENCE_GATE);
            OreDictionary.registerOre("fenceGateWood", Blocks.ACACIA_FENCE_GATE);
            OreDictionary.registerOre("doorWood", Items.ACACIA_DOOR);
            OreDictionary.registerOre("doorWood", Items.BIRCH_DOOR);
            OreDictionary.registerOre("doorWood", Items.DARK_OAK_DOOR);
            OreDictionary.registerOre("doorWood", Items.OAK_DOOR);
            OreDictionary.registerOre("doorWood", Items.JUNGLE_DOOR);
            OreDictionary.registerOre("doorWood", Items.SPRUCE_DOOR);
            OreDictionary.registerOre("stickWood", Items.STICK);
            OreDictionary.registerOre("treeSapling", new ItemStack(Blocks.SAPLING, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new ItemStack(Blocks.LEAVES, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("treeLeaves", new ItemStack(Blocks.LEAVES2, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("vine", Blocks.VINE);
            OreDictionary.registerOre("oreGold", Blocks.GOLD_ORE);
            OreDictionary.registerOre("oreIron", Blocks.IRON_ORE);
            OreDictionary.registerOre("oreLapis", Blocks.LAPIS_ORE);
            OreDictionary.registerOre("oreDiamond", Blocks.DIAMOND_ORE);
            OreDictionary.registerOre("oreRedstone", Blocks.REDSTONE_ORE);
            OreDictionary.registerOre("oreEmerald", Blocks.EMERALD_ORE);
            OreDictionary.registerOre("oreQuartz", Blocks.QUARTZ_ORE);
            OreDictionary.registerOre("oreCoal", Blocks.COAL_ORE);
            OreDictionary.registerOre("ingotIron", Items.IRON_INGOT);
            OreDictionary.registerOre("ingotGold", Items.GOLD_INGOT);
            OreDictionary.registerOre("ingotBrick", Items.BRICK);
            OreDictionary.registerOre("ingotBrickNether", Items.NETHERBRICK);
            OreDictionary.registerOre("nuggetGold", Items.GOLD_NUGGET);
            OreDictionary.registerOre("nuggetIron", Items.IRON_NUGGET);
            OreDictionary.registerOre("gemDiamond", Items.DIAMOND);
            OreDictionary.registerOre("gemEmerald", Items.EMERALD);
            OreDictionary.registerOre("gemQuartz", Items.QUARTZ);
            OreDictionary.registerOre("gemPrismarine", Items.PRISMARINE_SHARD);
            OreDictionary.registerOre("dustPrismarine", Items.PRISMARINE_CRYSTALS);
            OreDictionary.registerOre("dustRedstone", Items.REDSTONE);
            OreDictionary.registerOre("dustGlowstone", Items.GLOWSTONE_DUST);
            OreDictionary.registerOre("gemLapis", new ItemStack(Items.DYE, 1, 4));
            OreDictionary.registerOre("blockGold", Blocks.GOLD_BLOCK);
            OreDictionary.registerOre("blockIron", Blocks.IRON_BLOCK);
            OreDictionary.registerOre("blockLapis", Blocks.LAPIS_BLOCK);
            OreDictionary.registerOre("blockDiamond", Blocks.DIAMOND_BLOCK);
            OreDictionary.registerOre("blockRedstone", Blocks.REDSTONE_BLOCK);
            OreDictionary.registerOre("blockEmerald", Blocks.EMERALD_BLOCK);
            OreDictionary.registerOre("blockQuartz", Blocks.QUARTZ_BLOCK);
            OreDictionary.registerOre("blockCoal", Blocks.COAL_BLOCK);
            OreDictionary.registerOre("cropWheat", Items.WHEAT);
            OreDictionary.registerOre("cropPotato", Items.POTATO);
            OreDictionary.registerOre("cropCarrot", Items.CARROT);
            OreDictionary.registerOre("cropNetherWart", Items.NETHER_WART);
            OreDictionary.registerOre("sugarcane", Items.REEDS);
            OreDictionary.registerOre("blockCactus", Blocks.CACTUS);
            OreDictionary.registerOre("dye", new ItemStack(Items.DYE, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paper", new ItemStack(Items.PAPER));
            OreDictionary.registerOre("slimeball", Items.SLIME_BALL);
            OreDictionary.registerOre("enderpearl", Items.ENDER_PEARL);
            OreDictionary.registerOre("bone", Items.BONE);
            OreDictionary.registerOre("gunpowder", Items.GUNPOWDER);
            OreDictionary.registerOre("string", Items.STRING);
            OreDictionary.registerOre("netherStar", Items.NETHER_STAR);
            OreDictionary.registerOre("leather", Items.LEATHER);
            OreDictionary.registerOre("feather", Items.FEATHER);
            OreDictionary.registerOre("egg", Items.EGG);
            OreDictionary.registerOre("record", Items.RECORD_13);
            OreDictionary.registerOre("record", Items.RECORD_CAT);
            OreDictionary.registerOre("record", Items.RECORD_BLOCKS);
            OreDictionary.registerOre("record", Items.RECORD_CHIRP);
            OreDictionary.registerOre("record", Items.RECORD_FAR);
            OreDictionary.registerOre("record", Items.RECORD_MALL);
            OreDictionary.registerOre("record", Items.RECORD_MELLOHI);
            OreDictionary.registerOre("record", Items.RECORD_STAL);
            OreDictionary.registerOre("record", Items.RECORD_STRAD);
            OreDictionary.registerOre("record", Items.RECORD_WARD);
            OreDictionary.registerOre("record", Items.RECORD_11);
            OreDictionary.registerOre("record", Items.RECORD_WAIT);
            OreDictionary.registerOre("dirt", Blocks.DIRT);
            OreDictionary.registerOre("grass", Blocks.GRASS);
            OreDictionary.registerOre("stone", Blocks.STONE);
            OreDictionary.registerOre("cobblestone", Blocks.COBBLESTONE);
            OreDictionary.registerOre("gravel", Blocks.GRAVEL);
            OreDictionary.registerOre("sand", new ItemStack(Blocks.SAND, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new ItemStack(Blocks.SANDSTONE, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("sandstone", new ItemStack(Blocks.RED_SANDSTONE, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("netherrack", Blocks.NETHERRACK);
            OreDictionary.registerOre("obsidian", Blocks.OBSIDIAN);
            OreDictionary.registerOre("glowstone", Blocks.GLOWSTONE);
            OreDictionary.registerOre("endstone", Blocks.END_STONE);
            OreDictionary.registerOre("torch", Blocks.TORCH);
            OreDictionary.registerOre("workbench", Blocks.CRAFTING_TABLE);
            OreDictionary.registerOre("blockSlime", Blocks.SLIME_BLOCK);
            OreDictionary.registerOre("blockPrismarine", new ItemStack(Blocks.PRISMARINE, 1, BlockPrismarine.EnumType.ROUGH.getMetadata()));
            OreDictionary.registerOre("blockPrismarineBrick", new ItemStack(Blocks.PRISMARINE, 1, BlockPrismarine.EnumType.BRICKS.getMetadata()));
            OreDictionary.registerOre("blockPrismarineDark", new ItemStack(Blocks.PRISMARINE, 1, BlockPrismarine.EnumType.DARK.getMetadata()));
            OreDictionary.registerOre("stoneGranite", new ItemStack(Blocks.STONE, 1, 1));
            OreDictionary.registerOre("stoneGranitePolished", new ItemStack(Blocks.STONE, 1, 2));
            OreDictionary.registerOre("stoneDiorite", new ItemStack(Blocks.STONE, 1, 3));
            OreDictionary.registerOre("stoneDioritePolished", new ItemStack(Blocks.STONE, 1, 4));
            OreDictionary.registerOre("stoneAndesite", new ItemStack(Blocks.STONE, 1, 5));
            OreDictionary.registerOre("stoneAndesitePolished", new ItemStack(Blocks.STONE, 1, 6));
            OreDictionary.registerOre("blockGlassColorless", Blocks.GLASS);
            OreDictionary.registerOre("blockGlass", Blocks.GLASS);
            OreDictionary.registerOre("blockGlass", new ItemStack(Blocks.STAINED_GLASS, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("paneGlassColorless", Blocks.GLASS_PANE);
            OreDictionary.registerOre("paneGlass", Blocks.GLASS_PANE);
            OreDictionary.registerOre("paneGlass", new ItemStack(Blocks.STAINED_GLASS_PANE, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("wool", new ItemStack(Blocks.WOOL, 1, Short.MAX_VALUE));
            OreDictionary.registerOre("chest", Blocks.CHEST);
            OreDictionary.registerOre("chest", Blocks.ENDER_CHEST);
            OreDictionary.registerOre("chest", Blocks.TRAPPED_CHEST);
            OreDictionary.registerOre("chestWood", Blocks.CHEST);
            OreDictionary.registerOre("chestEnder", Blocks.ENDER_CHEST);
            OreDictionary.registerOre("chestTrapped", Blocks.TRAPPED_CHEST);
        }
        HashMap<ItemStack, Object> replacements = new HashMap<ItemStack, Object>();
        replacements.put(new ItemStack(Items.STICK), "stickWood");
        replacements.put(new ItemStack(Blocks.PLANKS, 1, 0), "plankWood");
        replacements.put(new ItemStack(Blocks.PLANKS, 1, 1), "plankWood");
        replacements.put(new ItemStack(Blocks.PLANKS, 1, 2), "plankWood");
        replacements.put(new ItemStack(Blocks.PLANKS, 1, 3), "plankWood");
        replacements.put(new ItemStack(Blocks.PLANKS, 1, 4), "plankWood");
        replacements.put(new ItemStack(Blocks.PLANKS, 1, 5), "plankWood");
        replacements.put(new ItemStack(Blocks.PLANKS, 1, Short.MAX_VALUE), "plankWood");
        replacements.put(new ItemStack(Blocks.WOODEN_SLAB, 1, Short.MAX_VALUE), "slabWood");
        replacements.put(new ItemStack(Items.GOLD_INGOT), "ingotGold");
        replacements.put(new ItemStack(Items.IRON_INGOT), "ingotIron");
        replacements.put(new ItemStack(Items.DIAMOND), "gemDiamond");
        replacements.put(new ItemStack(Items.EMERALD), "gemEmerald");
        replacements.put(new ItemStack(Items.PRISMARINE_SHARD), "gemPrismarine");
        replacements.put(new ItemStack(Items.PRISMARINE_CRYSTALS), "dustPrismarine");
        replacements.put(new ItemStack(Items.REDSTONE), "dustRedstone");
        replacements.put(new ItemStack(Items.GLOWSTONE_DUST), "dustGlowstone");
        replacements.put(new ItemStack(Items.REEDS), "sugarcane");
        replacements.put(new ItemStack(Blocks.CACTUS), "blockCactus");
        replacements.put(new ItemStack(Items.PAPER), "paper");
        replacements.put(new ItemStack(Items.SLIME_BALL), "slimeball");
        replacements.put(new ItemStack(Items.STRING), "string");
        replacements.put(new ItemStack(Items.LEATHER), "leather");
        replacements.put(new ItemStack(Items.ENDER_PEARL), "enderpearl");
        replacements.put(new ItemStack(Items.GUNPOWDER), "gunpowder");
        replacements.put(new ItemStack(Items.NETHER_STAR), "netherStar");
        replacements.put(new ItemStack(Items.FEATHER), "feather");
        replacements.put(new ItemStack(Items.BONE), "bone");
        replacements.put(new ItemStack(Items.EGG), "egg");
        replacements.put(new ItemStack(Blocks.STONE), "stone");
        replacements.put(new ItemStack(Blocks.COBBLESTONE), "cobblestone");
        replacements.put(new ItemStack(Blocks.COBBLESTONE, 1, Short.MAX_VALUE), "cobblestone");
        replacements.put(new ItemStack(Blocks.GLOWSTONE), "glowstone");
        replacements.put(new ItemStack(Blocks.GLASS), "blockGlassColorless");
        replacements.put(new ItemStack(Blocks.PRISMARINE), "prismarine");
        replacements.put(new ItemStack(Blocks.STONE, 1, 1), "stoneGranite");
        replacements.put(new ItemStack(Blocks.STONE, 1, 2), "stoneGranitePolished");
        replacements.put(new ItemStack(Blocks.STONE, 1, 3), "stoneDiorite");
        replacements.put(new ItemStack(Blocks.STONE, 1, 4), "stoneDioritePolished");
        replacements.put(new ItemStack(Blocks.STONE, 1, 5), "stoneAndesite");
        replacements.put(new ItemStack(Blocks.STONE, 1, 6), "stoneAndesitePolished");
        replacements.put(new ItemStack(Blocks.CHEST), "chestWood");
        replacements.put(new ItemStack(Blocks.ENDER_CHEST), "chestEnder");
        replacements.put(new ItemStack(Blocks.TRAPPED_CHEST), "chestTrapped");
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            ItemStack dye = new ItemStack(Items.DYE, 1, i);
            ItemStack wool = new ItemStack(Blocks.WOOL, 1, 15 - i);
            ItemStack block = new ItemStack(Blocks.STAINED_GLASS, 1, 15 - i);
            ItemStack pane = new ItemStack(Blocks.STAINED_GLASS_PANE, 1, 15 - i);
            if (!hasInit) {
                OreDictionary.registerOre("dye" + dyes[i], dye);
                OreDictionary.registerOre("wool" + dyes[i], wool);
                OreDictionary.registerOre("blockGlass" + dyes[i], block);
                OreDictionary.registerOre("paneGlass" + dyes[i], pane);
            }
            replacements.put(dye, "dye" + dyes[i]);
            replacements.put(wool, "wool" + dyes[i]);
            replacements.put(block, "blockGlass" + dyes[i]);
            replacements.put(pane, "paneGlass" + dyes[i]);
        }
        hasInit = true;
        ItemStack[] replaceStacks = replacements.keySet().toArray(new ItemStack[replacements.keySet().size()]);
        ItemStack[] exclusions = new ItemStack[]{new ItemStack(Blocks.LAPIS_BLOCK), new ItemStack(Items.COOKIE), new ItemStack(Blocks.STONEBRICK), new ItemStack(Blocks.STONE_SLAB, 1, Short.MAX_VALUE), new ItemStack(Blocks.STONE_STAIRS), new ItemStack(Blocks.COBBLESTONE_WALL), new ItemStack(Blocks.OAK_FENCE), new ItemStack(Blocks.OAK_FENCE_GATE), new ItemStack(Blocks.OAK_STAIRS), new ItemStack(Blocks.SPRUCE_FENCE), new ItemStack(Blocks.SPRUCE_FENCE_GATE), new ItemStack(Blocks.SPRUCE_STAIRS), new ItemStack(Blocks.BIRCH_FENCE_GATE), new ItemStack(Blocks.BIRCH_FENCE), new ItemStack(Blocks.BIRCH_STAIRS), new ItemStack(Blocks.JUNGLE_FENCE), new ItemStack(Blocks.JUNGLE_FENCE_GATE), new ItemStack(Blocks.JUNGLE_STAIRS), new ItemStack(Blocks.ACACIA_FENCE), new ItemStack(Blocks.ACACIA_FENCE_GATE), new ItemStack(Blocks.ACACIA_STAIRS), new ItemStack(Blocks.DARK_OAK_FENCE), new ItemStack(Blocks.DARK_OAK_FENCE_GATE), new ItemStack(Blocks.DARK_OAK_STAIRS), new ItemStack(Blocks.WOODEN_SLAB, 1, Short.MAX_VALUE), new ItemStack(Blocks.GLASS_PANE), new ItemStack(Blocks.BONE_BLOCK), new ItemStack(Items.BOAT), new ItemStack(Items.SPRUCE_BOAT), new ItemStack(Items.BIRCH_BOAT), new ItemStack(Items.JUNGLE_BOAT), new ItemStack(Items.ACACIA_BOAT), new ItemStack(Items.DARK_OAK_BOAT), new ItemStack(Items.OAK_DOOR), new ItemStack(Items.SPRUCE_DOOR), new ItemStack(Items.BIRCH_DOOR), new ItemStack(Items.JUNGLE_DOOR), new ItemStack(Items.ACACIA_DOOR), new ItemStack(Items.DARK_OAK_DOOR), ItemStack.EMPTY};
        FMLLog.log.info("Starts to replace vanilla recipe ingredients with ore ingredients.");
        int replaced = 0;
        for (IRecipe obj : CraftingManager.REGISTRY) {
            ItemStack output;
            if (obj.getClass() != ShapedRecipes.class && obj.getClass() != ShapelessRecipes.class || !(output = obj.getRecipeOutput()).isEmpty() && OreDictionary.containsMatch(false, new ItemStack[]{output}, exclusions)) continue;
            HashSet replacedIngs = new HashSet();
            NonNullList<Ingredient> lst = obj.getIngredients();
            for (int x = 0; x < lst.size(); ++x) {
                Ingredient ing = lst.get(x);
                ItemStack[] ingredients = ing.getMatchingStacks();
                String oreName = null;
                boolean skip = false;
                for (ItemStack stack : ingredients) {
                    boolean matches = false;
                    for (Map.Entry ent : replacements.entrySet()) {
                        if (!OreDictionary.itemMatches((ItemStack)ent.getKey(), stack, true)) continue;
                        matches = true;
                        if (oreName != null && !oreName.equals(ent.getValue())) {
                            FMLLog.log.info("Invalid recipe found with multiple oredict ingredients in the same ingredient...");
                            skip = true;
                            break;
                        }
                        if (oreName != null) continue;
                        oreName = (String)ent.getValue();
                        break;
                    }
                    if (!matches && oreName != null) {
                        skip = true;
                    }
                    if (skip) break;
                }
                if (skip || oreName == null) continue;
                lst.set(x, new OreIngredient(oreName));
                ++replaced;
            }
        }
        FMLLog.log.info("Replaced {} ore ingredients", (Object)replaced);
    }

    public static int getOreID(String name) {
        Integer val = nameToId.get(name);
        if (val == null) {
            idToName.add(name);
            val = idToName.size() - 1;
            nameToId.put(name, val);
            NonNullList back = NonNullList.create();
            idToStack.add(back);
            idToStackUn.add(back);
        }
        return val;
    }

    public static String getOreName(int id) {
        return id >= 0 && id < idToName.size() ? idToName.get(id) : "Unknown";
    }

    public static int[] getOreIDs(@Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Stack can not be invalid!");
        }
        HashSet<Integer> set = new HashSet<Integer>();
        ResourceLocation registryName = stack.getItem().delegate.name();
        if (registryName == null) {
            FMLLog.log.debug("Attempted to find the oreIDs for an unregistered object ({}). This won't work very well.", (Object)stack);
            return new int[0];
        }
        int id = Item.REGISTRY.getIDForObject((Item)stack.getItem().delegate.get());
        List<Integer> ids = stackToId.get(id);
        if (ids != null) {
            set.addAll(ids);
        }
        if ((ids = stackToId.get(id | stack.getItemDamage() + 1 << 16)) != null) {
            set.addAll(ids);
        }
        Integer[] tmp = set.toArray(new Integer[set.size()]);
        int[] ret = new int[tmp.length];
        for (int x = 0; x < tmp.length; ++x) {
            ret[x] = tmp[x];
        }
        return ret;
    }

    public static NonNullList<ItemStack> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static NonNullList<ItemStack> getOres(String name, boolean alwaysCreateEntry) {
        if (alwaysCreateEntry) {
            return OreDictionary.getOres(OreDictionary.getOreID(name));
        }
        return nameToId.get(name) != null ? OreDictionary.getOres(OreDictionary.getOreID(name)) : EMPTY_LIST;
    }

    public static boolean doesOreNameExist(String name) {
        return nameToId.get(name) != null;
    }

    public static String[] getOreNames() {
        return idToName.toArray(new String[idToName.size()]);
    }

    private static NonNullList<ItemStack> getOres(int id) {
        return idToStackUn.size() > id ? idToStackUn.get(id) : EMPTY_LIST;
    }

    private static boolean containsMatch(boolean strict, ItemStack[] inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMatch(boolean strict, NonNullList<ItemStack> inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(@Nonnull ItemStack target, @Nonnull ItemStack input, boolean strict) {
        if (input.isEmpty() && !target.isEmpty() || !input.isEmpty() && target.isEmpty()) {
            return false;
        }
        return target.getItem() == input.getItem() && (target.getMetadata() == Short.MAX_VALUE && !strict || target.getMetadata() == input.getMetadata());
    }

    public static void registerOre(String name, Item ore) {
        OreDictionary.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, Block ore) {
        OreDictionary.registerOre(name, new ItemStack(ore));
    }

    public static void registerOre(String name, @Nonnull ItemStack ore) {
        OreDictionary.registerOreImpl(name, ore);
    }

    private static void registerOreImpl(String name, @Nonnull ItemStack ore) {
        ArrayList ids;
        int hash;
        if ("Unknown".equals(name)) {
            return;
        }
        if (ore.isEmpty()) {
            FMLLog.bigWarning("Invalid registration attempt for an Ore Dictionary item with name {} has occurred. The registration has been denied to prevent crashes. The mod responsible for the registration needs to correct this.", name);
            return;
        }
        int oreID = OreDictionary.getOreID(name);
        ResourceLocation registryName = ore.getItem().delegate.name();
        if (registryName == null) {
            ModContainer modContainer = Loader.instance().activeModContainer();
            String modContainerName = modContainer == null ? null : modContainer.getName();
            FMLLog.bigWarning("A broken ore dictionary registration with name {} has occurred. It adds an item (type: {}) which is currently unknown to the game registry. This dictionary item can only support a single value when registered with ores like this, and NO I am not going to turn this spam off. Just register your ore dictionary entries after the GameRegistry.\nTO USERS: YES this is a BUG in the mod " + modContainerName + " report it to them!", name, ore.getItem().getClass());
            hash = -1;
        } else {
            hash = Item.REGISTRY.getIDForObject((Item)ore.getItem().delegate.get());
        }
        if (ore.getItemDamage() != Short.MAX_VALUE) {
            hash |= ore.getItemDamage() + 1 << 16;
        }
        if ((ids = stackToId.get(hash)) != null && ids.contains(oreID)) {
            return;
        }
        if (ids == null) {
            ids = Lists.newArrayList();
            stackToId.put(hash, ids);
        }
        ids.add(oreID);
        ore = ore.copy();
        idToStack.get(oreID).add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    public static void rebakeMap() {
        stackToId.clear();
        for (int id = 0; id < idToStack.size(); ++id) {
            NonNullList<ItemStack> ores = idToStack.get(id);
            if (ores == null) continue;
            for (ItemStack ore : ores) {
                int hash;
                ResourceLocation name = ore.getItem().delegate.name();
                if (name == null) {
                    FMLLog.log.debug("Defaulting unregistered ore dictionary entry for ore dictionary {}: type {} to -1", (Object)OreDictionary.getOreName(id), ore.getItem().getClass());
                    hash = -1;
                } else {
                    hash = Item.REGISTRY.getIDForObject((Item)ore.getItem().delegate.get());
                }
                if (ore.getItemDamage() != Short.MAX_VALUE) {
                    hash |= ore.getItemDamage() + 1 << 16;
                }
                List ids = stackToId.computeIfAbsent(hash, k -> Lists.newArrayList());
                ids.add(id);
            }
        }
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        private final String Name;
        private final ItemStack Ore;

        public OreRegisterEvent(String name, @Nonnull ItemStack ore) {
            this.Name = name;
            this.Ore = ore;
        }

        public String getName() {
            return this.Name;
        }

        @Nonnull
        public ItemStack getOre() {
            return this.Ore;
        }
    }
}

