/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items.wrapper;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class EntityEquipmentInvWrapper
implements IItemHandlerModifiable {
    protected final EntityLivingBase entity;
    protected final List<EntityEquipmentSlot> slots;

    public EntityEquipmentInvWrapper(EntityLivingBase entity, EntityEquipmentSlot.Type slotType) {
        this.entity = entity;
        ArrayList<EntityEquipmentSlot> slots = new ArrayList<EntityEquipmentSlot>();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            if (slot.getSlotType() != slotType) continue;
            slots.add(slot);
        }
        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.entity.getItemStackFromSlot(this.validateSlotIndex(slot));
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        EntityEquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.entity.getItemStackFromSlot(equipmentSlot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.entity.setItemStackToSlot(equipmentSlot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        EntityEquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        ItemStack existing = this.entity.getItemStackFromSlot(equipmentSlot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.entity.setItemStackToSlot(equipmentSlot, ItemStack.EMPTY);
            }
            return existing;
        }
        if (!simulate) {
            this.entity.setItemStackToSlot(equipmentSlot, ItemHandlerHelper.copyStackWithSize(existing, existing.getCount() - toExtract));
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        EntityEquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        return equipmentSlot.getSlotType() == EntityEquipmentSlot.Type.ARMOR ? 1 : 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        EntityEquipmentSlot equipmentSlot = this.validateSlotIndex(slot);
        if (ItemStack.areItemStacksEqual(this.entity.getItemStackFromSlot(equipmentSlot), stack)) {
            return;
        }
        this.entity.setItemStackToSlot(equipmentSlot, stack);
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return IItemHandlerModifiable.super.isItemValid(slot, stack);
    }

    protected EntityEquipmentSlot validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
        return this.slots.get(slot);
    }
}

