/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class VanillaInventoryCodeHooks {
    @Nullable
    public static Boolean extractHook(IHopper dest) {
        Pair<IItemHandler, Object> itemHandlerResult = VanillaInventoryCodeHooks.getItemHandler(dest, EnumFacing.UP);
        if (itemHandlerResult == null) {
            return null;
        }
        IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractItem = handler.extractItem(i, 1, true);
            if (extractItem.isEmpty()) continue;
            for (int j = 0; j < dest.getSizeInventory(); ++j) {
                ItemStack destStack = dest.getStackInSlot(j);
                if (!dest.isItemValidForSlot(j, extractItem) || !destStack.isEmpty() && (destStack.getCount() >= destStack.getMaxStackSize() || destStack.getCount() >= dest.getInventoryStackLimit() || !ItemHandlerHelper.canItemStacksStack(extractItem, destStack))) continue;
                extractItem = handler.extractItem(i, 1, false);
                if (destStack.isEmpty()) {
                    dest.setInventorySlotContents(j, extractItem);
                } else {
                    destStack.grow(1);
                    dest.setInventorySlotContents(j, destStack);
                }
                dest.markDirty();
                return true;
            }
        }
        return false;
    }

    public static boolean dropperInsertHook(World world, BlockPos pos, TileEntityDispenser dropper, int slot, @Nonnull ItemStack stack) {
        ItemStack dispensedStack;
        EnumFacing enumfacing = world.getBlockState(pos).getValue(BlockDropper.FACING);
        BlockPos blockpos = pos.offset(enumfacing);
        Pair<IItemHandler, Object> destinationResult = VanillaInventoryCodeHooks.getItemHandler(world, blockpos.getX(), blockpos.getY(), blockpos.getZ(), enumfacing.getOpposite());
        if (destinationResult == null) {
            return true;
        }
        IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
        Object destination = destinationResult.getValue();
        ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots(dropper, destination, itemHandler, dispensedStack = stack.copy().splitStack(1));
        if (remainder.isEmpty()) {
            remainder = stack.copy();
            remainder.shrink(1);
        } else {
            remainder = stack.copy();
        }
        dropper.setInventorySlotContents(slot, remainder);
        return false;
    }

    public static boolean insertHook(TileEntityHopper hopper) {
        EnumFacing hopperFacing = BlockHopper.getFacing(hopper.getBlockMetadata());
        Pair<IItemHandler, Object> destinationResult = VanillaInventoryCodeHooks.getItemHandler(hopper, hopperFacing);
        if (destinationResult == null) {
            return false;
        }
        IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
        Object destination = destinationResult.getValue();
        if (VanillaInventoryCodeHooks.isFull(itemHandler)) {
            return false;
        }
        for (int i = 0; i < hopper.getSizeInventory(); ++i) {
            if (hopper.getStackInSlot(i).isEmpty()) continue;
            ItemStack originalSlotContents = hopper.getStackInSlot(i).copy();
            ItemStack insertStack = hopper.decrStackSize(i, 1);
            ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots(hopper, destination, itemHandler, insertStack);
            if (remainder.isEmpty()) {
                return true;
            }
            hopper.setInventorySlotContents(i, originalSlotContents);
        }
        return false;
    }

    private static ItemStack putStackInInventoryAllSlots(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.isEmpty(); ++slot) {
            stack = VanillaInventoryCodeHooks.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).isEmpty()) {
            TileEntityHopper destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = VanillaInventoryCodeHooks.isEmpty(destInventory);
            if (itemstack.isEmpty()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.EMPTY;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack(itemstack, stack)) {
                int originalSize = stack.getCount();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).getCount();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof TileEntityHopper && !(destinationHopper = (TileEntityHopper)destination).mayTransfer()) {
                int k = 0;
                if (source instanceof TileEntityHopper && destinationHopper.getLastUpdateTime() >= ((TileEntityHopper)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationHopper.setTransferCooldown(8 - k);
            }
        }
        return stack;
    }

    @Nullable
    private static Pair<IItemHandler, Object> getItemHandler(IHopper hopper, EnumFacing hopperFacing) {
        double x = hopper.getXPos() + (double)hopperFacing.getXOffset();
        double y = hopper.getYPos() + (double)hopperFacing.getYOffset();
        double z = hopper.getZPos() + (double)hopperFacing.getZOffset();
        return VanillaInventoryCodeHooks.getItemHandler(hopper.getWorld(), x, y, z, hopperFacing.getOpposite());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() == stackInSlot.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.getCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<IItemHandler, Object> getItemHandler(World worldIn, double x, double y, double z, EnumFacing side) {
        TileEntity tileentity;
        int k;
        int j;
        ImmutablePair destination = null;
        int i = MathHelper.floor(x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.floor(y), k = MathHelper.floor(z));
        IBlockState state = worldIn.getBlockState(blockpos);
        Block block = state.getBlock();
        if (block.hasTileEntity(state) && (tileentity = worldIn.getTileEntity(blockpos)) != null && tileentity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler capability = tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            destination = ImmutablePair.of((Object)capability, (Object)tileentity);
        }
        return destination;
    }
}

