/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher.libraries;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.libraries.Artifact;
import net.minecraftforge.fml.relauncher.libraries.LibraryManager;
import net.minecraftforge.fml.relauncher.libraries.SnapshotJson;

public class Repository {
    static final Map<String, Repository> cache = new LinkedHashMap<String, Repository>();
    private final String name;
    private final File root;

    public static Repository create(File root) throws IOException {
        return Repository.create(root, root.getCanonicalPath());
    }

    public static Repository create(File root, String name) {
        return cache.computeIfAbsent(name, f -> new Repository(root, name));
    }

    public static Repository replace(File root, String name) {
        return cache.put(name, new Repository(root, name));
    }

    public static Repository get(String name) {
        return cache.get(name);
    }

    public static Artifact resolveAll(Artifact artifact) {
        Artifact ret = null;
        for (Repository repo : cache.values()) {
            Artifact tmp = repo.resolve(artifact);
            if (tmp == null) continue;
            if (!artifact.isSnapshot()) {
                return tmp;
            }
            ret = ret == null || ret.compareTo(tmp) < 0 ? tmp : ret;
        }
        return ret;
    }

    protected Repository(File root) throws IOException {
        this(root, root.getCanonicalPath());
    }

    protected Repository(File root, String name) {
        this.root = root;
        this.name = name;
        if (name == null) {
            throw new IllegalArgumentException("Invalid Repository Name, for " + String.valueOf(root));
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Repository && ((Repository)o).name.equals(this.name);
    }

    public Artifact resolve(Artifact artifact) {
        if (!artifact.isSnapshot()) {
            return this.getFile(artifact.getPath()).exists() ? artifact : null;
        }
        File meta = this.getFile(artifact.getFolder() + File.separatorChar + "maven-metadata.json");
        if (!meta.exists()) {
            return null;
        }
        SnapshotJson json = SnapshotJson.create(this.getFile(artifact.getFolder() + File.separatorChar + "maven-metadata.json"));
        if (json.getLatest() == null) {
            return null;
        }
        Artifact ret = new Artifact(artifact, this, json.getLatest());
        while (json.getLatest() != null && !this.getFile(ret.getPath()).exists()) {
            if (!json.remove(json.getLatest())) {
                throw new IllegalStateException("Something went wrong, Latest (" + json.getLatest() + ") did not point to an entry in the json list: " + meta.getAbsolutePath());
            }
            ret = new Artifact(artifact, this, json.getLatest());
        }
        return this.getFile(ret.getPath()).exists() ? ret : null;
    }

    public File getFile(String path) {
        return new File(this.root, path);
    }

    public File archive(Artifact artifact, File file, byte[] manifest) {
        File target = artifact.getFile();
        try {
            if (target.exists()) {
                FMLLog.log.debug("Maven file already exists for {}({}) at {}, deleting duplicate.", (Object)file.getName(), (Object)artifact.toString(), (Object)target.getAbsolutePath());
                file.delete();
            } else {
                FMLLog.log.debug("Moving file {}({}) to maven repo at {}.", (Object)file.getName(), (Object)artifact.toString(), (Object)target.getAbsolutePath());
                Files.move((File)file, (File)target);
                if (artifact.isSnapshot()) {
                    SnapshotJson json = SnapshotJson.create(artifact.getSnapshotMeta());
                    json.add(new SnapshotJson.Entry(artifact.getTimestamp(), Files.hash((File)target, (HashFunction)Hashing.md5()).toString()));
                    json.write(artifact.getSnapshotMeta());
                }
                if (!LibraryManager.DISABLE_EXTERNAL_MANIFEST) {
                    File meta_target = new File(target.getAbsolutePath() + ".meta");
                    Files.write((byte[])manifest, (File)meta_target);
                }
            }
            return target;
        }
        catch (IOException e) {
            FMLLog.log.error(FMLLog.log.getMessageFactory().newMessage("Error moving file {} to {}", new Object[]{file, target.getAbsolutePath()}), (Throwable)e);
            return file;
        }
    }

    public void filterLegacy(List<File> list) {
    }
}

