/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class VillagerRegistry {
    @GameRegistry.ObjectHolder(value="minecraft:farmer")
    public static final VillagerProfession FARMER = null;
    private static final VillagerRegistry INSTANCE = new VillagerRegistry();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    RegistryNamespaced<ResourceLocation, VillagerProfession> REGISTRY = GameData.getWrapper(VillagerProfession.class);
    private boolean hasInit = false;

    private VillagerRegistry() {
        this.init();
    }

    public static VillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    public static void addExtraVillageComponents(List<StructureVillagePieces.PieceWeight> list, Random random, int i) {
        List<StructureVillagePieces.PieceWeight> parts = list;
        for (IVillageCreationHandler handler : VillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i));
        }
    }

    public static StructureVillagePieces.Village getVillageComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        return VillagerRegistry.instance().villageCreationHandlers.get(villagePiece.villagePieceClass).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, facing, p5);
    }

    private void register(VillagerProfession prof, int id) {
        this.REGISTRY.register(id, prof.name, prof);
    }

    private void init() {
        if (this.hasInit) {
            return;
        }
        VillagerProfession prof = new VillagerProfession("minecraft:farmer", "minecraft:textures/entity/villager/farmer.png", "minecraft:textures/entity/zombie_villager/zombie_farmer.png");
        this.register(prof, 0);
        new VillagerCareer(prof, "farmer").init(VanillaTrades.trades[0][0]);
        new VillagerCareer(prof, "fisherman").init(VanillaTrades.trades[0][1]);
        new VillagerCareer(prof, "shepherd").init(VanillaTrades.trades[0][2]);
        new VillagerCareer(prof, "fletcher").init(VanillaTrades.trades[0][3]);
        prof = new VillagerProfession("minecraft:librarian", "minecraft:textures/entity/villager/librarian.png", "minecraft:textures/entity/zombie_villager/zombie_librarian.png");
        this.register(prof, 1);
        new VillagerCareer(prof, "librarian").init(VanillaTrades.trades[1][0]);
        new VillagerCareer(prof, "cartographer").init(VanillaTrades.trades[1][1]);
        prof = new VillagerProfession("minecraft:priest", "minecraft:textures/entity/villager/priest.png", "minecraft:textures/entity/zombie_villager/zombie_priest.png");
        this.register(prof, 2);
        new VillagerCareer(prof, "cleric").init(VanillaTrades.trades[2][0]);
        prof = new VillagerProfession("minecraft:smith", "minecraft:textures/entity/villager/smith.png", "minecraft:textures/entity/zombie_villager/zombie_smith.png");
        this.register(prof, 3);
        new VillagerCareer(prof, "armor").init(VanillaTrades.trades[3][0]);
        new VillagerCareer(prof, "weapon").init(VanillaTrades.trades[3][1]);
        new VillagerCareer(prof, "tool").init(VanillaTrades.trades[3][2]);
        prof = new VillagerProfession("minecraft:butcher", "minecraft:textures/entity/villager/butcher.png", "minecraft:textures/entity/zombie_villager/zombie_butcher.png");
        this.register(prof, 4);
        new VillagerCareer(prof, "butcher").init(VanillaTrades.trades[4][0]);
        new VillagerCareer(prof, "leather").init(VanillaTrades.trades[4][1]);
        prof = new VillagerProfession("minecraft:nitwit", "minecraft:textures/entity/villager/villager.png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
        this.register(prof, 5);
        new VillagerCareer(prof, "nitwit").init(VanillaTrades.trades[5][0]);
    }

    public static void setRandomProfession(EntityVillager entity, Random rand) {
        entity.setProfession((VillagerProfession)VillagerRegistry.INSTANCE.REGISTRY.getRandomObject(rand));
    }

    public static void setRandomProfession(EntityZombieVillager entity, Random rand) {
        entity.setForgeProfession((VillagerProfession)VillagerRegistry.INSTANCE.REGISTRY.getRandomObject(rand));
    }

    public static void onSetProfession(EntityVillager entity, int network) {
        VillagerProfession prof = VillagerRegistry.INSTANCE.REGISTRY.getObjectById(network);
        if (prof == null || VillagerRegistry.INSTANCE.REGISTRY.getIDForObject(prof) != network) {
            throw new RuntimeException("Attempted to set villager profession to unregistered profession: " + network + " " + String.valueOf(prof));
        }
        if (prof != entity.getProfessionForge()) {
            entity.setProfession(prof);
        }
    }

    public static void onSetProfession(EntityZombieVillager entity, int network) {
        VillagerProfession prof = VillagerRegistry.INSTANCE.REGISTRY.getObjectById(network);
        if (prof == null && network != -1 || VillagerRegistry.INSTANCE.REGISTRY.getIDForObject(prof) != network) {
            throw new RuntimeException("Attempted to set villager profession to unregistered profession: " + network + " " + String.valueOf(prof));
        }
        if (prof != entity.getForgeProfession()) {
            entity.setForgeProfession(prof);
        }
    }

    @Deprecated
    public static VillagerProfession getById(int network) {
        return VillagerRegistry.INSTANCE.REGISTRY.getObjectById(network);
    }

    @Deprecated
    public static int getId(@Nullable VillagerProfession prof) {
        return VillagerRegistry.INSTANCE.REGISTRY.getIDForObject(prof);
    }

    public static class VillagerProfession
    extends IForgeRegistryEntry.Impl<VillagerProfession> {
        private ResourceLocation name;
        private ResourceLocation texture;
        private ResourceLocation zombie;
        private List<VillagerCareer> careers = Lists.newArrayList();

        public VillagerProfession(String name, String texture, String zombie) {
            this.name = new ResourceLocation(name);
            this.texture = new ResourceLocation(texture);
            this.zombie = new ResourceLocation(zombie);
            this.setRegistryName(this.name);
        }

        private void register(VillagerCareer career) {
            Validate.isTrue((!this.careers.contains(career) ? 1 : 0) != 0, (String)"Attempted to register career that is already registered.", (Object[])new Object[0]);
            Validate.isTrue((career.profession == this ? 1 : 0) != 0, (String)"Attempted to register career for the wrong profession.", (Object[])new Object[0]);
            career.id = this.careers.size();
            this.careers.add(career);
        }

        public ResourceLocation getSkin() {
            return this.texture;
        }

        public ResourceLocation getZombieSkin() {
            return this.zombie;
        }

        public VillagerCareer getCareer(int id) {
            for (VillagerCareer car : this.careers) {
                if (car.id != id) continue;
                return car;
            }
            return this.careers.get(0);
        }

        public int getRandomCareer(Random rand) {
            return this.careers.get((int)rand.nextInt((int)this.careers.size())).id;
        }
    }

    public static interface IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight var1, StructureVillagePieces.Start var2, List<StructureComponent> var3, Random var4, int var5, int var6, int var7, EnumFacing var8, int var9);
    }

    public static class VillagerCareer {
        private VillagerProfession profession;
        private String name;
        private int id;
        private List<List<EntityVillager.ITradeList>> trades = Lists.newArrayList();

        public VillagerCareer(VillagerProfession parent, String name) {
            this.profession = parent;
            this.name = name;
            parent.register(this);
        }

        public String getName() {
            return this.name;
        }

        public VillagerCareer addTrade(int level, EntityVillager.ITradeList ... trades) {
            ArrayList levelTrades;
            if (level <= 0) {
                throw new IllegalArgumentException("Levels start at 1");
            }
            ArrayList arrayList = levelTrades = level <= this.trades.size() ? this.trades.get(level - 1) : null;
            if (levelTrades == null) {
                while (this.trades.size() < level) {
                    levelTrades = Lists.newArrayList();
                    this.trades.add(levelTrades);
                }
            }
            if (levelTrades == null) {
                levelTrades = Lists.newArrayList();
                this.trades.set(level - 1, levelTrades);
            }
            for (EntityVillager.ITradeList t : trades) {
                levelTrades.add(t);
            }
            return this;
        }

        @Nullable
        public List<EntityVillager.ITradeList> getTrades(int level) {
            return level >= 0 && level < this.trades.size() ? Collections.unmodifiableList(this.trades.get(level)) : null;
        }

        private VillagerCareer init(EntityVillager.ITradeList[][] trades) {
            for (int x = 0; x < trades.length; ++x) {
                this.trades.add(Lists.newArrayList((Object[])trades[x]));
            }
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VillagerCareer)) {
                return false;
            }
            VillagerCareer oc = (VillagerCareer)o;
            return this.name.equals(oc.name) && this.profession == oc.profession;
        }
    }

    private static class VanillaTrades {
        private static final EntityVillager.ITradeList[][][][] trades = EntityVillager.GET_TRADES_DONT_USE();

        private VanillaTrades() {
        }
    }
}

