/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityEntry
extends IForgeRegistryEntry.Impl<EntityEntry> {
    private Class<? extends Entity> cls;
    private String name;
    private EntityList.EntityEggInfo egg;
    Function<World, ? extends Entity> factory;

    public EntityEntry(Class<? extends Entity> cls, String name) {
        this.cls = cls;
        this.name = name;
        this.init();
    }

    protected void init() {
        this.factory = new EntityEntryBuilder.ConstructorFactory<Entity>(this.cls){

            @Override
            protected String describeEntity() {
                return String.valueOf(EntityEntry.this.getRegistryName());
            }
        };
    }

    public Class<? extends Entity> getEntityClass() {
        return this.cls;
    }

    public String getName() {
        return this.name;
    }

    public EntityList.EntityEggInfo getEgg() {
        return this.egg;
    }

    public void setEgg(EntityList.EntityEggInfo egg) {
        this.egg = egg;
        if (this.getRegistryName() != null) {
            EntityList.ENTITY_EGGS.put(this.getRegistryName(), egg);
        }
    }

    public Entity newInstance(World world) {
        return this.factory.apply(world);
    }
}

