/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;

public class ByteBufUtils {
    public static int varIntByteCount(int toCount) {
        return (toCount & 0xFFFFFF80) == 0 ? 1 : ((toCount & 0xFFFFC000) == 0 ? 2 : ((toCount & 0xFFE00000) == 0 ? 3 : ((toCount & 0xF0000000) == 0 ? 4 : 5)));
    }

    public static int readVarInt(ByteBuf buf, int maxSize) {
        byte b0;
        Validate.isTrue((maxSize < 6 && maxSize > 0 ? 1 : 0) != 0, (String)"Varint length is between 1 and 5, not %d", (long)maxSize);
        int i = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= maxSize) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static int readVarShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeVarShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static void writeVarInt(ByteBuf to, int toWrite, int maxSize) {
        Validate.isTrue((ByteBufUtils.varIntByteCount(toWrite) <= maxSize ? 1 : 0) != 0, (String)"Integer is too big for %d bytes", (long)maxSize);
        while ((toWrite & 0xFFFFFF80) != 0) {
            to.writeByte(toWrite & 0x7F | 0x80);
            toWrite >>>= 7;
        }
        to.writeByte(toWrite);
    }

    public static String readUTF8String(ByteBuf from) {
        int len = ByteBufUtils.readVarInt(from, 2);
        String str = from.toString(from.readerIndex(), len, StandardCharsets.UTF_8);
        from.readerIndex(from.readerIndex() + len);
        return str;
    }

    public static void writeUTF8String(ByteBuf to, String string) {
        byte[] utf8Bytes = string.getBytes(StandardCharsets.UTF_8);
        Validate.isTrue((ByteBufUtils.varIntByteCount(utf8Bytes.length) < 3 ? 1 : 0) != 0, (String)"The string is too long for this encoding.", (Object[])new Object[0]);
        ByteBufUtils.writeVarInt(to, utf8Bytes.length, 2);
        to.writeBytes(utf8Bytes);
    }

    public static void writeItemStack(ByteBuf to, ItemStack stack) {
        PacketBuffer pb = new PacketBuffer(to);
        pb.writeItemStack(stack);
    }

    public static ItemStack readItemStack(ByteBuf from) {
        PacketBuffer pb = new PacketBuffer(from);
        try {
            return pb.readItemStack();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeTag(ByteBuf to, NBTTagCompound tag) {
        PacketBuffer pb = new PacketBuffer(to);
        pb.writeCompoundTag(tag);
    }

    @Nullable
    public static NBTTagCompound readTag(ByteBuf from) {
        PacketBuffer pb = new PacketBuffer(from);
        try {
            return pb.readCompoundTag();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void writeRegistryEntry(@Nonnull ByteBuf out, @Nonnull T entry) {
        ForgeRegistry registry = (ForgeRegistry)GameRegistry.findRegistry(entry.getRegistryType());
        ByteBufUtils.writeUTF8String(out, RegistryManager.ACTIVE.getName(registry).toString());
        ByteBufUtils.writeVarInt(out, registry.getID(entry), 5);
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry<T>> T readRegistryEntry(@Nonnull ByteBuf in, @Nonnull IForgeRegistry<T> registry) {
        String registryName = ByteBufUtils.readUTF8String(in);
        int id = ByteBufUtils.readVarInt(in, 5);
        ResourceLocation expectedRegistryName = RegistryManager.ACTIVE.getName(registry);
        if (!expectedRegistryName.toString().equals(registryName)) {
            throw new IllegalArgumentException("Registry mismatch: " + registryName + " != " + String.valueOf(expectedRegistryName));
        }
        Object thing = ((ForgeRegistry)registry).getRaw(id);
        if (thing == null) {
            throw new IllegalArgumentException("Unknown ID " + id + " for registry " + String.valueOf(expectedRegistryName) + " received.");
        }
        return (T)thing;
    }

    public static <T extends IForgeRegistryEntry<T>> void writeRegistryEntries(@Nonnull ByteBuf out, @Nonnull Collection<T> entries) {
        ByteBufUtils.writeVarInt(out, entries.size(), 5);
        Iterator<T> it = entries.iterator();
        if (it.hasNext()) {
            IForgeRegistryEntry first = (IForgeRegistryEntry)it.next();
            ForgeRegistry registry = (ForgeRegistry)GameRegistry.findRegistry(first.getRegistryType());
            ByteBufUtils.writeUTF8String(out, RegistryManager.ACTIVE.getName(registry).toString());
            ByteBufUtils.writeVarInt(out, registry.getID(first), 5);
            while (it.hasNext()) {
                int id = registry.getID((IForgeRegistryEntry)it.next());
                if (id == -1) {
                    throw new IllegalArgumentException("Unregistered IForgeRegistryEntry in collection " + String.valueOf(entries) + ".");
                }
                ByteBufUtils.writeVarInt(out, id, 5);
            }
        }
    }

    @Nonnull
    public static <T extends IForgeRegistryEntry<T>> List<T> readRegistryEntries(@Nonnull ByteBuf in, @Nonnull IForgeRegistry<T> registry) {
        int size = ByteBufUtils.readVarInt(in, 5);
        if (size == 0) {
            return ImmutableList.of();
        }
        String registryName = ByteBufUtils.readUTF8String(in);
        ResourceLocation expectedRegistryName = RegistryManager.ACTIVE.getName(registry);
        if (!expectedRegistryName.toString().equals(registryName)) {
            throw new IllegalArgumentException("Registry mismatch: " + registryName + " != " + String.valueOf(expectedRegistryName));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            int id = ByteBufUtils.readVarInt(in, 5);
            Object thing = ((ForgeRegistry)registry).getRaw(id);
            if (thing == null) {
                throw new IllegalArgumentException("Unknown ID " + id + " for registry " + String.valueOf(expectedRegistryName) + " received.");
            }
            b.add(thing);
        }
        return b.build();
    }

    public static String getContentDump(ByteBuf buffer) {
        int j;
        int i;
        int currentLength = buffer.readableBytes();
        StringBuffer returnString = new StringBuffer(currentLength * 3 + currentLength + currentLength / 4 + 30);
        for (i = 0; i < currentLength; ++i) {
            if (i != 0 && i % 16 == 0) {
                returnString.append('\t');
                for (j = i - 16; j < i; ++j) {
                    if (buffer.getByte(j) < 32 || buffer.getByte(j) > 127) {
                        returnString.append('.');
                        continue;
                    }
                    returnString.append((char)buffer.getByte(j));
                }
                returnString.append("\n");
            }
            returnString.append(Integer.toString((buffer.getByte(i) & 0xF0) >> 4, 16) + Integer.toString((buffer.getByte(i) & 0xF) >> 0, 16));
            returnString.append(' ');
        }
        if (i != 0 && i % 16 != 0) {
            for (j = 0; j < (16 - i % 16) * 3; ++j) {
                returnString.append(' ');
            }
        }
        returnString.append('\t');
        for (j = i > 0 && i % 16 == 0 ? i - 16 : i - i % 16; i >= 0 && j < i; ++j) {
            if (buffer.getByte(j) < 32 || buffer.getByte(j) > 127) {
                returnString.append('.');
                continue;
            }
            returnString.append((char)buffer.getByte(j));
        }
        returnString.append('\n');
        returnString.append("Length: " + currentLength);
        return returnString.toString();
    }
}

