/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.GuiWrongMinecraft;
import net.minecraftforge.fml.client.IDisplayableError;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WrongMinecraftVersionException
extends EnhancedRuntimeException
implements IDisplayableError {
    private static final long serialVersionUID = 1L;
    public ModContainer mod;
    private String mcVersion;

    public WrongMinecraftVersionException(ModContainer mod, String mcver) {
        super(String.format("Wrong Minecraft version for %s", mod.getModId()));
        this.mod = mod;
        this.mcVersion = mcver;
    }

    @Override
    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
        stream.println("Wrong Minecraft Versions!");
        stream.println("Mod: " + this.mod.getModId());
        stream.println("Location: " + this.mod.getSource().toString());
        stream.println("Expected: " + this.mod.acceptableMinecraftVersionRange().toString());
        stream.println("Current: " + this.mcVersion);
        stream.println("");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen createGui() {
        return new GuiWrongMinecraft(this);
    }
}

