/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.client.GuiModsMissing;
import net.minecraftforge.fml.client.IDisplayableError;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MissingModsException
extends EnhancedRuntimeException
implements IDisplayableError {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    @Deprecated
    public final Set<ArtifactVersion> missingMods;
    private final List<MissingModInfo> missingModsInfos;
    private final String modName;

    public MissingModsException(String id, String name) {
        this(new HashSet<ArtifactVersion>(), id, name);
    }

    @Deprecated
    public MissingModsException(Set<ArtifactVersion> missingMods, String id, String name) {
        this.id = id;
        this.name = name;
        this.missingMods = missingMods;
        this.missingModsInfos = new ArrayList<MissingModInfo>();
        for (ArtifactVersion artifactVersion : missingMods) {
            this.missingModsInfos.add(new MissingModInfo(artifactVersion, null, true));
        }
        this.modName = name;
    }

    @Override
    public String getMessage() {
        Set missingMods = this.missingModsInfos.stream().map(MissingModInfo::getAcceptedVersion).collect(Collectors.toSet());
        return String.format("Mod %s (%s) requires %s", this.id, this.name, missingMods);
    }

    public void addMissingMod(ArtifactVersion acceptedVersion, @Nullable ArtifactVersion currentVersion, boolean required) {
        MissingModInfo missingModInfo = new MissingModInfo(acceptedVersion, currentVersion, required);
        this.missingModsInfos.add(missingModInfo);
        this.missingMods.add(acceptedVersion);
    }

    public String getModName() {
        return this.modName;
    }

    public List<MissingModInfo> getMissingModInfos() {
        return Collections.unmodifiableList(this.missingModsInfos);
    }

    @Override
    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
        stream.println("Missing Mods:");
        for (MissingModInfo info : this.missingModsInfos) {
            ArtifactVersion acceptedVersion = info.getAcceptedVersion();
            ArtifactVersion currentVersion = info.getCurrentVersion();
            String currentString = currentVersion != null ? currentVersion.getVersionString() : "missing";
            stream.println(String.format("\t%s : need %s: have %s", acceptedVersion.getVersionString(), acceptedVersion.getRangeString(), currentString));
        }
        stream.println("");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen createGui() {
        return new GuiModsMissing(this);
    }

    public static class MissingModInfo {
        private final ArtifactVersion acceptedVersion;
        @Nullable
        private final ArtifactVersion currentVersion;
        private final boolean required;

        private MissingModInfo(ArtifactVersion acceptedVersion, @Nullable ArtifactVersion currentVersion, boolean required) {
            Preconditions.checkNotNull((Object)acceptedVersion, (Object)"acceptedVersion");
            this.acceptedVersion = acceptedVersion;
            this.currentVersion = currentVersion;
            this.required = required;
        }

        @Nullable
        public ArtifactVersion getCurrentVersion() {
            return this.currentVersion;
        }

        public ArtifactVersion getAcceptedVersion() {
            return this.acceptedVersion;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

