/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.handshake.client.C00Handshake;
import net.minecraft.network.login.server.SPacketDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WorldAccessContainer;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.thread.SidedThreadGroup;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private List<String> brandings;
    private List<String> brandingsNoMC;
    private List<ICrashCallable> crashCallables = Lists.newArrayList((Object[])new ICrashCallable[]{Loader.instance().getCallableCrashInformation()});
    private Set<SaveHandler> handlerSet = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
    private WeakReference<SaveHandler> handlerToCheck;
    private EventBus eventBus = MinecraftForge.EVENT_BUS;
    private volatile CountDownLatch exitLatch = null;

    private FMLCommonHandler() {
        this.registerCrashCallable(new ICrashCallable(this){

            @Override
            public String call() {
                return "0.3.35-alpha";
            }

            @Override
            public String getLabel() {
                return "Cleanroom Version";
            }
        });
        this.registerCrashCallable(new ICrashCallable(this){

            @Override
            public String call() {
                StringBuilder builder = new StringBuilder();
                Joiner joiner = Joiner.on((String)"\n  ");
                for (String coreMod : CoreModManager.getTransformers().keySet()) {
                    builder.append("\n").append(coreMod).append("\n  ").append(joiner.join((Iterable)CoreModManager.getTransformers().get(coreMod)));
                }
                return builder.toString();
            }

            @Override
            public String getLabel() {
                return "Loaded coremods (and transformers)";
            }
        });
    }

    @Deprecated
    public EventBus bus() {
        return this.eventBus;
    }

    public List<String> beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        MinecraftForge.initialize();
        return ImmutableList.of();
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        if (mod instanceof String) {
            return Loader.instance().getIndexedModList().get(mod);
        }
        return (ModContainer)Loader.instance().getReversedModObjectList().get(mod);
    }

    @Deprecated
    public Logger getFMLLogger() {
        return FMLLog.log;
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public Side getEffectiveSide() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        return group instanceof SidedThreadGroup ? ((SidedThreadGroup)group).getSide() : Side.CLIENT;
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLLog.log.error("Something raised an exception. The message was '{}'. 'stopGame' is {}", (Object)message, (Object)stopGame, (Object)exception);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder brd = ImmutableList.builder();
            brd.add((Object)Loader.instance().getMCVersionString());
            brd.add((Object)Loader.instance().getMCPVersionString());
            brd.add((Object)"Cleanroom 0.3.35-alpha");
            if (this.sidedDelegate != null) {
                brd.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            }
            if (Loader.instance().getFMLBrandingProperties().containsKey("fmlbranding")) {
                brd.add((Object)Loader.instance().getFMLBrandingProperties().get("fmlbranding"));
            }
            int tModCount = Loader.instance().getModList().size();
            int aModCount = Loader.instance().getActiveModList().size();
            brd.add((Object)String.format("%d mod%s loaded, %d mod%s active", tModCount, tModCount != 1 ? "s" : "", aModCount, aModCount != 1 ? "s" : ""));
            this.brandings = brd.build();
            this.brandingsNoMC = this.brandings.subList(1, this.brandings.size());
        }
    }

    public List<String> getBrandings(boolean includeMC) {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return includeMC ? ImmutableList.copyOf(this.brandings) : ImmutableList.copyOf(this.brandingsNoMC);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void onPostServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.END));
    }

    public void onPostWorldTick(World world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.END, world));
    }

    public void onPreServerTick() {
        this.bus().post(new TickEvent.ServerTickEvent(TickEvent.Phase.START));
    }

    public void onPreWorldTick(World world) {
        this.bus().post(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.START, world));
    }

    public boolean handleServerAboutToStart(MinecraftServer server) {
        return Loader.instance().serverAboutToStart(server);
    }

    public boolean handleServerStarting(MinecraftServer server) {
        return Loader.instance().serverStarting(server);
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
        this.sidedDelegate.allowLogins();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public File getSavesDirectory() {
        return this.sidedDelegate.getSavesDirectory();
    }

    public MinecraftServer getMinecraftServerInstance() {
        return this.sidedDelegate.getServer();
    }

    public void showGuiScreen(Object clientGuiElement) {
        this.sidedDelegate.showGuiScreen(clientGuiElement);
    }

    public void queryUser(StartupQuery query) throws InterruptedException {
        this.sidedDelegate.queryUser(query);
    }

    public void onServerStart(MinecraftServer dedicatedServer) {
        FMLServerHandler.instance();
        this.sidedDelegate.beginServerLoading(dedicatedServer);
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public void onPreClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.START));
    }

    public void onPostClientTick() {
        this.bus().post(new TickEvent.ClientTickEvent(TickEvent.Phase.END));
    }

    public void onRenderTickStart(float timer) {
        Animation.setClientPartialTickTime(timer);
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.START, timer));
    }

    public void onRenderTickEnd(float timer) {
        this.bus().post(new TickEvent.RenderTickEvent(TickEvent.Phase.END, timer));
    }

    public void onPlayerPreTick(EntityPlayer player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.START, player));
    }

    public void onPlayerPostTick(EntityPlayer player) {
        this.bus().post(new TickEvent.PlayerTickEvent(TickEvent.Phase.END, player));
    }

    public void registerCrashCallable(ICrashCallable callable) {
        this.crashCallables.add(callable);
    }

    public void enhanceCrashReport(CrashReport crashReport, CrashReportCategory category) {
        for (ICrashCallable call : this.crashCallables) {
            category.addDetail(call.getLabel(), call);
        }
    }

    public void handleWorldDataSave(SaveHandler handler, WorldInfo worldInfo, NBTTagCompound tagCompound) {
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            NBTTagCompound dataForWriting = wac.getDataForWriting(handler, worldInfo);
            tagCompound.setTag(mc.getModId(), dataForWriting);
        }
    }

    public void handleWorldDataLoad(SaveHandler handler, WorldInfo worldInfo, NBTTagCompound tagCompound) {
        if (this.getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (this.handlerSet.contains(handler)) {
            return;
        }
        this.handlerSet.add(handler);
        this.handlerToCheck = new WeakReference<SaveHandler>(handler);
        HashMap additionalProperties = Maps.newHashMap();
        worldInfo.setAdditionalProperties(additionalProperties);
        for (ModContainer mc : Loader.instance().getModList()) {
            WorldAccessContainer wac;
            if (!(mc instanceof InjectedModContainer) || (wac = ((InjectedModContainer)mc).getWrappedWorldAccessContainer()) == null) continue;
            wac.readData(handler, worldInfo, additionalProperties, tagCompound.getCompoundTag(mc.getModId()));
        }
    }

    public void confirmBackupLevelDatUse(SaveHandler handler) {
        if (this.handlerToCheck == null || this.handlerToCheck.get() != handler) {
            this.handlerToCheck = null;
            return;
        }
        String text = "Forge Mod Loader detected that the backup level.dat is being used.\n\nThis may happen due to a bug or corruption, continuing can damage\nyour world beyond repair or lose data / progress.\n\nIt's recommended to create a world backup before continuing.\n";
        boolean confirmed = StartupQuery.confirm(text);
        if (!confirmed) {
            StartupQuery.abort();
        }
    }

    public boolean isDisplayCloseRequested() {
        return this.sidedDelegate != null && this.sidedDelegate.isDisplayCloseRequested();
    }

    public boolean shouldServerBeKilledQuietly() {
        if (this.sidedDelegate == null) {
            return false;
        }
        return this.sidedDelegate.shouldServerShouldBeKilledQuietly();
    }

    public void expectServerStopped() {
        this.exitLatch = new CountDownLatch(1);
    }

    public void handleExit(int retVal) {
        CountDownLatch latch = this.exitLatch;
        if (latch != null) {
            try {
                FMLLog.log.info("Waiting for the server to terminate/save.");
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    FMLLog.log.warn("The server didn't stop within 10 seconds, exiting anyway.");
                } else {
                    FMLLog.log.info("Server terminated.");
                }
            }
            catch (InterruptedException e) {
                FMLLog.log.warn("Interrupted wait, exiting.");
            }
        }
        System.exit(retVal);
    }

    public void handleServerStopped() {
        CountDownLatch latch;
        this.sidedDelegate.serverStopped();
        MinecraftServer server = this.getMinecraftServerInstance();
        Loader.instance().serverStopped();
        if (server != null) {
            ObfuscationReflectionHelper.setPrivateValue(MinecraftServer.class, server, Boolean.valueOf(false), "field_71316_v");
        }
        if ((latch = this.exitLatch) != null) {
            latch.countDown();
            this.exitLatch = null;
        }
    }

    public String getModName() {
        ArrayList modNames = Lists.newArrayListWithExpectedSize((int)3);
        modNames.add("fml");
        modNames.add("forge");
        modNames.add("cleanroom");
        if (Loader.instance().getFMLBrandingProperties().containsKey("snooperbranding")) {
            modNames.add(Loader.instance().getFMLBrandingProperties().get("snooperbranding"));
        }
        return Joiner.on((char)',').join((Iterable)modNames);
    }

    public void addModToResourcePack(ModContainer container) {
        this.sidedDelegate.addModAsResource(container);
    }

    public String getCurrentLanguage() {
        return this.sidedDelegate.getCurrentLanguage();
    }

    public void bootstrap() {
    }

    public NetworkManager getClientToServerNetworkManager() {
        return this.sidedDelegate.getClientToServerNetworkManager();
    }

    public void fireMouseInput() {
        this.bus().post(new InputEvent.MouseInputEvent());
    }

    public void fireKeyInput() {
        this.bus().post(new InputEvent.KeyInputEvent());
    }

    public void firePlayerChangedDimensionEvent(EntityPlayer player, int fromDim, int toDim) {
        this.bus().post(new PlayerEvent.PlayerChangedDimensionEvent(player, fromDim, toDim));
    }

    public void firePlayerLoggedIn(EntityPlayer player) {
        this.bus().post(new PlayerEvent.PlayerLoggedInEvent(player));
    }

    public void firePlayerLoggedOut(EntityPlayer player) {
        this.bus().post(new PlayerEvent.PlayerLoggedOutEvent(player));
    }

    public void firePlayerRespawnEvent(EntityPlayer player, boolean endConquered) {
        this.bus().post(new PlayerEvent.PlayerRespawnEvent(player, endConquered));
    }

    public void firePlayerItemPickupEvent(EntityPlayer player, EntityItem item, ItemStack clone) {
        this.bus().post(new PlayerEvent.ItemPickupEvent(player, item, clone));
    }

    public void firePlayerCraftingEvent(EntityPlayer player, ItemStack crafted, IInventory craftMatrix) {
        this.bus().post(new PlayerEvent.ItemCraftedEvent(player, crafted, craftMatrix));
    }

    public void firePlayerSmeltedEvent(EntityPlayer player, ItemStack smelted) {
        this.bus().post(new PlayerEvent.ItemSmeltedEvent(player, smelted));
    }

    public INetHandler getClientPlayHandler() {
        return this.sidedDelegate.getClientPlayHandler();
    }

    public void fireNetRegistrationEvent(NetworkManager manager, Set<String> channelSet, String channel, Side side) {
        this.sidedDelegate.fireNetRegistrationEvent(this.bus(), manager, channelSet, channel, side);
    }

    public boolean shouldAllowPlayerLogins() {
        return this.sidedDelegate.shouldAllowPlayerLogins();
    }

    public void fireServerConnectionEvent(NetworkManager manager) {
        this.bus().post(new FMLNetworkEvent.ServerConnectionFromClientEvent(manager));
    }

    public boolean handleServerHandshake(C00Handshake packet, NetworkManager manager) {
        if (!this.shouldAllowPlayerLogins()) {
            TextComponentString text = new TextComponentString("Server is still starting! Please wait before reconnecting.");
            if (packet.getRequestedState() != EnumConnectionState.STATUS) {
                FMLLog.log.info("Disconnecting Player: {}", (Object)text.getUnformattedText());
                manager.sendPacket(new SPacketDisconnect(text));
            }
            manager.closeChannel(text);
            return false;
        }
        if (packet.getRequestedState() == EnumConnectionState.LOGIN && !NetworkRegistry.INSTANCE.isVanillaAccepted(Side.CLIENT) && !packet.hasFMLMarker()) {
            manager.setConnectionState(EnumConnectionState.LOGIN);
            TextComponentString text = new TextComponentString("This server has mods that require FML/Forge to be installed on the client. Contact your server admin for more details.");
            Collection<String> modNames = NetworkRegistry.INSTANCE.getRequiredMods(Side.CLIENT);
            FMLLog.log.info("Disconnecting Player: This server has mods that require FML/Forge to be installed on the client: {}", modNames);
            manager.sendPacket(new SPacketDisconnect(text));
            manager.closeChannel(text);
            return false;
        }
        manager.channel().attr(NetworkRegistry.FML_MARKER).set((Object)packet.hasFMLMarker());
        return true;
    }

    public void processWindowMessages() {
        if (this.sidedDelegate == null) {
            return;
        }
        this.sidedDelegate.processWindowMessages();
    }

    public void exitJava(int exitCode, boolean hardExit) {
        FMLLog.log.warn("Java has been asked to exit (code {})", (Object)exitCode);
        if (hardExit) {
            FMLLog.log.warn("This is an abortive exit and could cause world corruption or other things");
        }
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        FMLLog.log.warn("Exit trace:");
        for (int i = 2; i < stack.length; ++i) {
            FMLLog.log.warn("\t{}", (Object)stack[i]);
        }
        if (hardExit) {
            Runtime.getRuntime().halt(exitCode);
        } else {
            Runtime.getRuntime().exit(exitCode);
        }
    }

    public IThreadListener getWorldThread(INetHandler net) {
        return this.sidedDelegate.getWorldThread(net);
    }

    public static void callFuture(FutureTask<?> task) {
        try {
            task.run();
            task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            FMLLog.log.fatal("Exception caught executing FutureTask: {}", (Object)e.toString(), (Object)e);
        }
    }

    @Nullable
    public InputStream loadLanguage(Map<String, String> table, InputStream inputstream) throws IOException {
        byte[] data = IOUtils.toByteArray((InputStream)inputstream);
        boolean isEnhanced = false;
        for (String line : IOUtils.readLines((InputStream)new ByteArrayInputStream(data), (Charset)StandardCharsets.UTF_8)) {
            if (line.isEmpty() || line.charAt(0) != '#' || !(line = line.substring(1).trim()).equals("PARSE_ESCAPES")) continue;
            isEnhanced = true;
            break;
        }
        if (!isEnhanced) {
            return new ByteArrayInputStream(data);
        }
        Properties props = new Properties();
        props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            table.put((String)e.getKey(), (String)e.getValue());
        }
        props.clear();
        return null;
    }

    public String stripSpecialChars(String message) {
        return this.sidedDelegate != null ? this.sidedDelegate.stripSpecialChars(message) : message;
    }

    public void reloadRenderers() {
        this.sidedDelegate.reloadRenderers();
    }

    public void fireSidedRegistryEvents() {
        this.sidedDelegate.fireSidedRegistryEvents();
    }

    public CompoundDataFixer getDataFixer() {
        return this.sidedDelegate.getDataFixer();
    }

    public boolean isDisplayVSyncForced() {
        return this.sidedDelegate.isDisplayVSyncForced();
    }

    public void resetClientRecipeBook() {
        this.sidedDelegate.resetClientRecipeBook();
    }

    public void reloadSearchTrees() {
        this.sidedDelegate.reloadSearchTrees();
    }

    public void reloadCreativeSettings() {
        this.sidedDelegate.reloadCreativeSettings();
    }
}

