/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiUnicodeGlyphButton
extends GuiButtonExt {
    public String glyph;
    public float glyphScale;

    public GuiUnicodeGlyphButton(int id, int xPos, int yPos, int width, int height, String displayString, String glyph, float glyphScale) {
        super(id, xPos, yPos, width, height, displayString);
        this.glyph = glyph;
        this.glyphScale = glyphScale;
    }

    @Override
    public void drawButton(Minecraft mc, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int k = this.getHoverState(this.hovered);
            GuiUtils.drawContinuousTexturedBox(GuiButton.BUTTON_TEXTURES, this.x, this.y, 0, 46 + k * 20, this.width, this.height, 200, 20, 2, 3, 2, 2, this.zLevel);
            this.mouseDragged(mc, mouseX, mouseY);
            int color = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                color = this.packedFGColour;
            } else if (!this.enabled) {
                color = 0xA0A0A0;
            } else if (this.hovered) {
                color = 0xFFFFA0;
            }
            Object buttonText = this.displayString;
            int glyphWidth = (int)((float)mc.fontRenderer.getStringWidth(this.glyph) * this.glyphScale);
            int strWidth = mc.fontRenderer.getStringWidth((String)buttonText);
            int ellipsisWidth = mc.fontRenderer.getStringWidth("...");
            int totalWidth = strWidth + glyphWidth;
            if (totalWidth > this.width - 6 && totalWidth > ellipsisWidth) {
                buttonText = mc.fontRenderer.trimStringToWidth((String)buttonText, this.width - 6 - ellipsisWidth).trim() + "...";
            }
            strWidth = mc.fontRenderer.getStringWidth((String)buttonText);
            totalWidth = glyphWidth + strWidth;
            GlStateManager.pushMatrix();
            GlStateManager.scale(this.glyphScale, this.glyphScale, 1.0f);
            this.drawCenteredString(mc.fontRenderer, this.glyph, (int)((float)(this.x + this.width / 2 - strWidth / 2) / this.glyphScale - (float)glyphWidth / (2.0f * this.glyphScale) + 2.0f), (int)(((float)this.y + (float)(this.height - 8) / this.glyphScale / 2.0f - 1.0f) / this.glyphScale), color);
            GlStateManager.popMatrix();
            this.drawCenteredString(mc.fontRenderer, (String)buttonText, (int)((float)(this.x + this.width / 2) + (float)glyphWidth / this.glyphScale), this.y + (this.height - 8) / 2, color);
        }
    }
}

