/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiSelectString;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiSelectStringEntries
extends GuiListExtended {
    public GuiSelectString owningScreen;
    public Minecraft mc;
    public IConfigElement configElement;
    public List<IGuiSelectStringListEntry> listEntries;
    public final Map<Object, String> selectableValues;
    public int selectedIndex = -1;
    public int maxEntryWidth = 0;

    public GuiSelectStringEntries(GuiSelectString owningScreen, Minecraft mc, IConfigElement configElement, Map<Object, String> selectableValues) {
        super(mc, owningScreen.width, owningScreen.height, owningScreen.titleLine2 != null ? (owningScreen.titleLine3 != null ? 43 : 33) : 23, owningScreen.height - 32, 11);
        this.owningScreen = owningScreen;
        this.mc = mc;
        this.configElement = configElement;
        this.selectableValues = selectableValues;
        this.setShowSelectionBox(true);
        this.listEntries = new ArrayList<IGuiSelectStringListEntry>();
        int index = 0;
        ArrayList<Map.Entry<Object, String>> sortedList = new ArrayList<Map.Entry<Object, String>>(selectableValues.entrySet());
        Collections.sort(sortedList, new EntryComparator());
        for (Map.Entry entry : sortedList) {
            this.listEntries.add(new ListEntry(this, entry));
            if (mc.fontRenderer.getStringWidth((String)entry.getValue()) > this.maxEntryWidth) {
                this.maxEntryWidth = mc.fontRenderer.getStringWidth((String)entry.getValue());
            }
            if (owningScreen.currentValue.equals(entry.getKey())) {
                this.selectedIndex = index;
            }
            ++index;
        }
    }

    @Override
    protected void elementClicked(int index, boolean doubleClick, int mouseX, int mouseY) {
        this.selectedIndex = index;
        this.owningScreen.currentValue = this.listEntries.get(index).getValue();
    }

    @Override
    protected boolean isSelected(int index) {
        return index == this.selectedIndex;
    }

    @Override
    protected int getScrollBarX() {
        return this.width / 2 + this.maxEntryWidth / 2 + 5;
    }

    @Override
    public int getListWidth() {
        return this.maxEntryWidth + 5;
    }

    @Override
    public IGuiSelectStringListEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    @Override
    protected int getSize() {
        return this.listEntries.size();
    }

    public boolean isChanged() {
        return this.owningScreen.beforeValue != null ? !this.owningScreen.beforeValue.equals(this.owningScreen.currentValue) : this.owningScreen.currentValue != null;
    }

    public boolean isDefault() {
        return this.owningScreen.currentValue != null ? this.owningScreen.currentValue.equals(this.configElement.getDefault()) : this.configElement.getDefault() == null;
    }

    public void saveChanges() {
        if (this.owningScreen.slotIndex != -1 && this.owningScreen.parentScreen != null && this.owningScreen.parentScreen instanceof GuiConfig && ((GuiConfig)this.owningScreen.parentScreen).entryList.getListEntry(this.owningScreen.slotIndex) instanceof GuiConfigEntries.SelectValueEntry) {
            GuiConfigEntries.SelectValueEntry entry = (GuiConfigEntries.SelectValueEntry)((GuiConfig)this.owningScreen.parentScreen).entryList.getListEntry(this.owningScreen.slotIndex);
            entry.setValueFromChildScreen(this.owningScreen.currentValue);
        } else {
            this.configElement.set(this.owningScreen.currentValue);
        }
    }

    public static class EntryComparator
    implements Comparator<Map.Entry<Object, String>> {
        @Override
        public int compare(Map.Entry<Object, String> o1, Map.Entry<Object, String> o2) {
            int compare = o1.getValue().toLowerCase(Locale.US).compareTo(o2.getValue().toLowerCase(Locale.US));
            if (compare == 0) {
                compare = o1.getKey().toString().toLowerCase(Locale.US).compareTo(o2.getKey().toString().toLowerCase(Locale.US));
            }
            return compare;
        }
    }

    public static class ListEntry
    implements IGuiSelectStringListEntry {
        protected final GuiSelectStringEntries owningList;
        protected final Map.Entry<Object, String> value;

        public ListEntry(GuiSelectStringEntries owningList, Map.Entry<Object, String> value) {
            this.owningList = owningList;
            this.value = value;
        }

        @Override
        public void drawEntry(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            this.owningList.mc.fontRenderer.drawString(this.value.getValue(), x + 1, y, slotIndex == this.owningList.selectedIndex ? 0xFFFFFF : 0xE0E0E0);
        }

        @Override
        public boolean mousePressed(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        @Override
        public void mouseReleased(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        @Override
        public Object getValue() {
            return this.value.getKey();
        }

        @Override
        public void updatePosition(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }

    public static interface IGuiSelectStringListEntry
    extends GuiListExtended.IGuiListEntry {
        public Object getValue();
    }
}

