/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.GuiErrorBase;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;

public class GuiModsMissing
extends GuiErrorBase {
    private MissingModsException modsMissing;

    public GuiModsMissing(MissingModsException modsMissing) {
        this.modsMissing = modsMissing;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        List<MissingModsException.MissingModInfo> missingModsVersions = this.modsMissing.getMissingModInfos();
        int offset = Math.max(85 - missingModsVersions.size() * 10, 10);
        String modMissingDependenciesText = I18n.format("fml.messages.mod.missing.dependencies.compatibility", String.valueOf((Object)TextFormatting.BOLD) + this.modsMissing.getModName() + String.valueOf((Object)TextFormatting.RESET));
        this.drawCenteredString(this.fontRenderer, modMissingDependenciesText, this.width / 2, offset, 0xFFFFFF);
        offset += 5;
        for (MissingModsException.MissingModInfo versionInfo : missingModsVersions) {
            ModContainer acceptedMod;
            DefaultArtifactVersion dav;
            ArtifactVersion acceptedVersion = versionInfo.getAcceptedVersion();
            String acceptedModId = acceptedVersion.getLabel();
            ArtifactVersion currentVersion = versionInfo.getCurrentVersion();
            String missingReason = currentVersion == null ? I18n.format("fml.messages.mod.missing.dependencies.missing", new Object[0]) : I18n.format("fml.messages.mod.missing.dependencies.you.have", currentVersion.getVersionString());
            String acceptedModVersionString = acceptedVersion.getRangeString();
            if (acceptedVersion instanceof DefaultArtifactVersion && (dav = (DefaultArtifactVersion)acceptedVersion).getRange() != null) {
                acceptedModVersionString = dav.getRange().toStringFriendly();
            }
            String acceptedModName = (acceptedMod = Loader.instance().getIndexedModList().get(acceptedModId)) != null ? acceptedMod.getName() : acceptedModId;
            String versionInfoText = String.format(String.valueOf((Object)TextFormatting.BOLD) + "%s " + String.valueOf((Object)TextFormatting.RESET) + "%s (%s)", acceptedModName, acceptedModVersionString, missingReason);
            String message = versionInfo.isRequired() ? I18n.format("fml.messages.mod.missing.dependencies.requires", versionInfoText) : I18n.format("fml.messages.mod.missing.dependencies.compatible.with", versionInfoText);
            this.drawCenteredString(this.fontRenderer, message, this.width / 2, offset += 10, 0xEEEEEE);
        }
        super.drawScreen(mouseX, mouseY, partialTicks);
    }
}

