/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.GuiSlotModList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.lwjgl.input.Mouse;

public class GuiModList
extends GuiScreen {
    private GuiScreen mainMenu;
    private GuiSlotModList modList;
    private GuiScrollingList modInfo;
    private int selected = -1;
    private ModContainer selectedMod;
    private int listWidth;
    private ArrayList<ModContainer> mods;
    private GuiButton configModButton;
    private GuiButton disableModButton;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private GuiTextField search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public GuiModList(GuiScreen mainMenu) {
        this.mainMenu = mainMenu;
        this.mods = new ArrayList();
        FMLClientHandler.instance().addSpecialModEntries(this.mods);
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod.getMetadata() != null && mod.getMetadata().parentMod == null && !Strings.isNullOrEmpty((String)mod.getMetadata().parent)) {
                String parentMod = mod.getMetadata().parent;
                ModContainer parentContainer = Loader.instance().getIndexedModList().get(parentMod);
                if (parentContainer != null) {
                    mod.getMetadata().parentMod = parentContainer;
                    parentContainer.getMetadata().childMods.add(mod);
                    continue;
                }
            } else if (mod.getMetadata() != null && mod.getMetadata().parentMod != null) continue;
            this.mods.add(mod);
        }
    }

    @Override
    public void initGui() {
        int slotHeight = 25;
        for (ModContainer mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().getStringWidth(mod.getName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().getStringWidth(mod.getVersion()) + 5 + slotHeight);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.modList = new GuiSlotModList(this, this.mods, this.listWidth, slotHeight);
        this.buttonList.add(new GuiButton(6, (this.modList.right + this.width) / 2 - 100, this.height - 38, I18n.format("gui.done", new Object[0])));
        this.configModButton = new GuiButton(20, 10, this.height - 49, this.listWidth, 20, "Config");
        this.disableModButton = new GuiButton(21, 10, this.height - 27, this.listWidth, 20, "Disable");
        this.buttonList.add(this.configModButton);
        this.buttonList.add(this.disableModButton);
        this.search = new GuiTextField(0, this.getFontRenderer(), 12, this.modList.bottom + 17, this.modList.listWidth - 4, 14);
        this.search.setFocused(true);
        this.search.setCanLoseFocus(true);
        int width = this.modList.listWidth / this.numButtons;
        int x = 10;
        int y = 10;
        GuiButton normalSort = new GuiButton(SortType.NORMAL.buttonID, x, y, width - this.buttonMargin, 20, I18n.format("fml.menu.mods.normal", new Object[0]));
        normalSort.enabled = false;
        this.buttonList.add(normalSort);
        this.buttonList.add(new GuiButton(SortType.A_TO_Z.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "A-Z"));
        this.buttonList.add(new GuiButton(SortType.Z_TO_A.buttonID, x += width + this.buttonMargin, y, width - this.buttonMargin, 20, "Z-A"));
        this.updateCache();
    }

    @Override
    protected void mouseClicked(int x, int y, int button) throws IOException {
        super.mouseClicked(x, y, button);
        this.search.mouseClicked(x, y, button);
        if (button == 1 && x >= this.search.x && x < this.search.x + this.search.width && y >= this.search.y && y < this.search.y + this.search.height) {
            this.search.setText("");
        }
    }

    @Override
    protected void keyTyped(char c, int keyCode) throws IOException {
        super.keyTyped(c, keyCode);
        this.search.textboxKeyTyped(c, keyCode);
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.search.updateCursorCounter();
        if (!this.search.getText().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            Collections.sort(this.mods, this.sortType);
            this.selected = this.modList.selectedIndex = this.mods.indexOf(this.selectedMod);
            this.sorted = true;
        }
    }

    private void reloadMods() {
        ArrayList<ModContainer> mods = this.modList.getMods();
        mods.clear();
        for (ModContainer m : Loader.instance().getModList()) {
            if (!m.getName().toLowerCase().contains(this.search.getText().toLowerCase()) || m.getMetadata() != null && m.getMetadata().parentMod != null) continue;
            mods.add(m);
        }
        this.mods = mods;
        this.lastFilterText = this.search.getText();
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.enabled) {
            SortType type = SortType.getTypeForButton(button);
            if (type != null) {
                for (GuiButton b : this.buttonList) {
                    if (SortType.getTypeForButton(b) == null) continue;
                    b.enabled = true;
                }
                button.enabled = false;
                this.sorted = false;
                this.sortType = type;
                this.mods = this.modList.getMods();
            } else {
                switch (button.id) {
                    case 6: {
                        this.mc.displayGuiScreen(this.mainMenu);
                        return;
                    }
                    case 20: {
                        try {
                            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
                            GuiScreen newScreen = guiFactory.createConfigGui(this);
                            this.mc.displayGuiScreen(newScreen);
                        }
                        catch (Exception e) {
                            FMLLog.log.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selectedMod.getModId(), (Object)e);
                        }
                        return;
                    }
                }
            }
        }
        super.actionPerformed(button);
    }

    public int drawLine(String line, int offset, int shifty) {
        this.fontRenderer.drawString(line, offset, shifty, 14151146);
        return shifty + 10;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.modList.drawScreen(mouseX, mouseY, partialTicks);
        if (this.modInfo != null) {
            this.modInfo.drawScreen(mouseX, mouseY, partialTicks);
        }
        int left = (this.width - this.listWidth - 38) / 2 + this.listWidth + 30;
        this.drawCenteredString(this.fontRenderer, "Mod List", left, 16, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTicks);
        String text = I18n.format("fml.menu.mods.search", new Object[0]);
        int x = (10 + this.modList.right) / 2 - this.getFontRenderer().getStringWidth(text) / 2;
        this.getFontRenderer().drawString(text, x, this.modList.bottom + 5, 0xFFFFFF);
        this.search.drawTextBox();
    }

    @Override
    public void handleMouseInput() throws IOException {
        int mouseX = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int mouseY = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        super.handleMouseInput();
        if (this.modInfo != null) {
            this.modInfo.handleMouseInput(mouseX, mouseY);
        }
        this.modList.handleMouseInput(mouseX, mouseY);
    }

    Minecraft getMinecraftInstance() {
        return this.mc;
    }

    FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public void selectModIndex(int index) {
        if (index == this.selected) {
            return;
        }
        this.selected = index;
        this.selectedMod = index >= 0 && index <= this.mods.size() ? this.mods.get(this.selected) : null;
        this.updateCache();
    }

    public boolean modIndexSelected(int index) {
        return index == this.selected;
    }

    private void updateCache() {
        String logoFile;
        this.configModButton.visible = false;
        this.disableModButton.visible = false;
        this.modInfo = null;
        if (this.selectedMod == null) {
            return;
        }
        ResourceLocation logoPath = null;
        Dimension logoDims = new Dimension(0, 0);
        ArrayList<String> lines = new ArrayList<String>();
        ModMetadata metadata = this.selectedMod.getMetadata();
        if (metadata != null && !(logoFile = metadata.logoFile).isEmpty()) {
            TextureManager tm = this.mc.getTextureManager();
            IResourcePack pack = FMLClientHandler.instance().getResourcePackFor(this.selectedMod.getModId());
            try {
                BufferedImage logo = null;
                if (pack != null) {
                    logo = pack.getPackImage();
                } else {
                    InputStream logoResource = this.getClass().getResourceAsStream(logoFile);
                    if (logoResource != null) {
                        logo = TextureUtil.readBufferedImage(logoResource);
                    }
                }
                if (logo != null) {
                    logoPath = tm.getDynamicTextureLocation("modlogo", new DynamicTexture(logo));
                    logoDims = new Dimension(logo.getWidth(), logo.getHeight());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (metadata != null && !metadata.autogenerated) {
            this.disableModButton.visible = true;
            this.disableModButton.enabled = true;
            this.disableModButton.packedFGColour = 0;
            ModContainer.Disableable disableable = this.selectedMod.canBeDisabled();
            if (disableable == ModContainer.Disableable.RESTART) {
                this.disableModButton.packedFGColour = 0xFF3377;
            } else if (disableable != ModContainer.Disableable.YES) {
                this.disableModButton.enabled = false;
            }
            IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(this.selectedMod);
            this.configModButton.visible = true;
            this.configModButton.enabled = false;
            if (guiFactory != null) {
                this.configModButton.enabled = guiFactory.hasConfigGui();
            }
            lines.add(metadata.name);
            if (this.selectedMod.getDisplayVersion().isEmpty()) {
                lines.add(String.format("Version: %s", this.selectedMod.getVersion()));
            } else if (this.selectedMod.getVersion().equals(this.selectedMod.getDisplayVersion())) {
                lines.add(String.format("Version: %s", this.selectedMod.getDisplayVersion()));
            } else {
                lines.add(String.format("Version: %s (%s)", this.selectedMod.getDisplayVersion(), this.selectedMod.getVersion()));
            }
            lines.add(String.format("Mod ID: '%s' Mod State: %s", new Object[]{this.selectedMod.getModId(), Loader.instance().getModState(this.selectedMod)}));
            if (!metadata.credits.isEmpty()) {
                lines.add("Credits: " + metadata.credits);
            }
            if (!metadata.getAuthorList().isEmpty()) {
                lines.add("Authors: " + metadata.getAuthorList());
            }
            if (!metadata.url.isEmpty()) {
                lines.add("URL: " + metadata.url);
            }
            if (!metadata.childMods.isEmpty()) {
                lines.add("Child mods: " + metadata.getChildModList());
            }
        } else {
            lines.add(String.valueOf((Object)TextFormatting.WHITE) + this.selectedMod.getName());
            lines.add(String.valueOf((Object)TextFormatting.WHITE) + "Version: " + this.selectedMod.getVersion());
            lines.add(String.valueOf((Object)TextFormatting.WHITE) + "Mod State: " + String.valueOf((Object)Loader.instance().getModState(this.selectedMod)));
        }
        ForgeVersion.CheckResult vercheck = ForgeVersion.getCleanResult(this.selectedMod);
        if (vercheck != null && (vercheck.status == ForgeVersion.Status.OUTDATED || vercheck.status == ForgeVersion.Status.BETA_OUTDATED || vercheck.status == ForgeVersion.Status.BETA || vercheck.status == ForgeVersion.Status.AHEAD)) {
            lines.add(null);
            if (vercheck.status == ForgeVersion.Status.BETA) {
                lines.add(String.valueOf((Object)TextFormatting.GOLD) + "This version is a beta version");
            } else if (vercheck.status == ForgeVersion.Status.AHEAD) {
                lines.add(String.valueOf((Object)TextFormatting.LIGHT_PURPLE) + "This version is ahead of the latest version found (" + String.valueOf((Object)TextFormatting.LIGHT_PURPLE) + vercheck.latestFound + ")");
            } else if (vercheck.status == ForgeVersion.Status.BETA_OUTDATED) {
                lines.add(String.valueOf((Object)TextFormatting.GOLD) + "Beta update (" + String.valueOf((Object)TextFormatting.GOLD) + vercheck.latestFound + ") available: " + (vercheck.homepage == null ? "" : vercheck.homepage));
            } else {
                lines.add(String.valueOf((Object)TextFormatting.GREEN) + "Update (" + String.valueOf((Object)TextFormatting.GREEN) + vercheck.latestFound + ") available: " + (vercheck.homepage == null ? "" : vercheck.homepage));
            }
            if (!vercheck.changes.isEmpty()) {
                lines.add(null);
                lines.add("Changes:");
                for (Map.Entry<ComparableVersion, String> entry : vercheck.changes.entrySet()) {
                    lines.add("  " + String.valueOf(entry.getKey()) + ":");
                    lines.add(entry.getValue());
                    lines.add(null);
                }
            }
        }
        if (metadata != null && !metadata.autogenerated) {
            lines.add(null);
            lines.add(metadata.description);
        } else {
            lines.add(null);
            lines.add(String.valueOf((Object)TextFormatting.RED) + "No mod information found");
            lines.add(String.valueOf((Object)TextFormatting.RED) + "Ask the mod author to provide a mcmod.info file");
        }
        this.modInfo = new Info(this.width - this.listWidth - 30, lines, logoPath, logoDims);
    }

    private static enum SortType implements Comparator<ModContainer>
    {
        NORMAL(24),
        A_TO_Z(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        @Nullable
        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.id) continue;
                return t;
            }
            return null;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(ModContainer o1, ModContainer o2) {
            String name1 = StringUtils.stripControlCodes(o1.getName()).toLowerCase();
            String name2 = StringUtils.stripControlCodes(o2.getName()).toLowerCase();
            return this.compare(name1, name2);
        }
    }

    private class Info
    extends GuiScrollingList {
        @Nullable
        private ResourceLocation logoPath;
        private Dimension logoDims;
        private List<ITextComponent> lines;

        public Info(int width, @Nullable List<String> lines, ResourceLocation logoPath, Dimension logoDims) {
            super(GuiModList.this.getMinecraftInstance(), width, GuiModList.this.height, 32, GuiModList.this.height - 88 + 4, GuiModList.this.listWidth + 20, 60, GuiModList.this.width, GuiModList.this.height);
            this.lines = null;
            this.lines = this.resizeContent(lines);
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        @Override
        protected int getSize() {
            return 0;
        }

        @Override
        protected void elementClicked(int index, boolean doubleClick) {
        }

        @Override
        protected boolean isSelected(int index) {
            return false;
        }

        @Override
        protected void drawBackground() {
        }

        @Override
        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        }

        private List<ITextComponent> resizeContent(List<String> lines) {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks(line, false);
                int maxTextLength = this.listWidth - 8;
                if (maxTextLength < 0) continue;
                ret.addAll(GuiUtilRenderComponents.splitText(chat, maxTextLength, GuiModList.this.fontRenderer, false, true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = 0;
            if (this.logoPath != null) {
                double scaleX = (double)this.logoDims.width / 200.0;
                double scaleY = (double)this.logoDims.height / 65.0;
                double scale = 1.0;
                if (scaleX > 1.0 || scaleY > 1.0) {
                    scale = 1.0 / Math.max(scaleX, scaleY);
                }
                this.logoDims.width = (int)((double)this.logoDims.width * scale);
                this.logoDims.height = (int)((double)this.logoDims.height * scale);
                height += this.logoDims.height;
                height += 10;
            }
            if ((height += this.lines.size() * 10) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
            int top = relativeY;
            if (this.logoPath != null) {
                GlStateManager.enableBlend();
                GuiModList.this.mc.renderEngine.bindTexture(this.logoPath);
                BufferBuilder wr = tess.getBuffer();
                int offset = this.left + this.listWidth / 2 - this.logoDims.width / 2;
                wr.begin(7, DefaultVertexFormats.POSITION_TEX);
                wr.pos(offset, top + this.logoDims.height, GuiModList.this.zLevel).tex(0.0, 1.0).endVertex();
                wr.pos(offset + this.logoDims.width, top + this.logoDims.height, GuiModList.this.zLevel).tex(1.0, 1.0).endVertex();
                wr.pos(offset + this.logoDims.width, top, GuiModList.this.zLevel).tex(1.0, 0.0).endVertex();
                wr.pos(offset, top, GuiModList.this.zLevel).tex(0.0, 0.0).endVertex();
                tess.draw();
                GlStateManager.disableBlend();
                top += this.logoDims.height + 10;
            }
            for (ITextComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.enableBlend();
                    GuiModList.this.fontRenderer.drawStringWithShadow(line.getFormattedText(), this.left + 4, top, 0xFFFFFF);
                    GlStateManager.disableAlpha();
                    GlStateManager.disableBlend();
                }
                top += 10;
            }
        }

        @Override
        protected void clickHeader(int x, int y) {
            int offset = y;
            if (this.logoPath != null) {
                offset -= this.logoDims.height + 10;
            }
            if (offset <= 0) {
                return;
            }
            int lineIdx = offset / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            ITextComponent line = this.lines.get(lineIdx);
            if (line != null) {
                int k = -4;
                for (ITextComponent part : line) {
                    if (!(part instanceof TextComponentString) || (k += GuiModList.this.fontRenderer.getStringWidth(((TextComponentString)part).getText())) < x) continue;
                    GuiModList.this.handleComponentClick(part);
                    break;
                }
            }
        }
    }
}

