/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability;

import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class CapabilityFluidHandler {
    @CapabilityInject(value=IFluidHandler.class)
    public static Capability<IFluidHandler> FLUID_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IFluidHandlerItem.class)
    public static Capability<IFluidHandlerItem> FLUID_HANDLER_ITEM_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IFluidHandler.class, new DefaultFluidHandlerStorage(), () -> new FluidTank(1000));
        CapabilityManager.INSTANCE.register(IFluidHandlerItem.class, new DefaultFluidHandlerStorage(), () -> new FluidHandlerItemStack(new ItemStack(Items.BUCKET), 1000));
    }

    private static class DefaultFluidHandlerStorage<T extends IFluidHandler>
    implements Capability.IStorage<T> {
        private DefaultFluidHandlerStorage() {
        }

        @Override
        public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
            if (!(instance instanceof IFluidTank)) {
                throw new RuntimeException("IFluidHandler instance does not implement IFluidTank");
            }
            NBTTagCompound nbt = new NBTTagCompound();
            IFluidTank tank = (IFluidTank)instance;
            FluidStack fluid = tank.getFluid();
            if (fluid != null) {
                fluid.writeToNBT(nbt);
            } else {
                nbt.setString("Empty", "");
            }
            nbt.setInteger("Capacity", tank.getCapacity());
            return nbt;
        }

        @Override
        public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
            if (!(instance instanceof FluidTank)) {
                throw new RuntimeException("IFluidHandler instance is not instance of FluidTank");
            }
            NBTTagCompound tags = (NBTTagCompound)nbt;
            FluidTank tank = (FluidTank)instance;
            tank.setCapacity(tags.getInteger("Capacity"));
            tank.readFromNBT(tags);
        }
    }
}

