/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class UniversalBucket
extends Item {
    private final int capacity;
    @Nonnull
    private final ItemStack empty;
    private final boolean nbtSensitive;

    public UniversalBucket() {
        this(1000, new ItemStack(Items.BUCKET), false);
    }

    public UniversalBucket(int capacity, @Nonnull ItemStack empty, boolean nbtSensitive) {
        this.capacity = capacity;
        this.empty = empty;
        this.nbtSensitive = nbtSensitive;
        this.setMaxStackSize(1);
        this.setCreativeTab(CreativeTabs.MISC);
        BlockDispenser.DISPENSE_BEHAVIOR_REGISTRY.putObject(this, DispenseFluidContainer.getInstance());
    }

    @Override
    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return !this.getEmpty().isEmpty();
    }

    @Override
    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        if (!this.getEmpty().isEmpty()) {
            return this.getEmpty().copy();
        }
        return super.getContainerItem(itemStack);
    }

    @Override
    public void getSubItems(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (!this.isInCreativeTab(tab)) {
            return;
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            FluidStack fs;
            ItemStack stack;
            FluidBucketWrapper fluidHandler;
            if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || fluid.getName().equals("milk") || (fluidHandler = new FluidBucketWrapper(stack = new ItemStack(this))).fill(fs = new FluidStack(fluid, this.getCapacity()), true) != fs.amount) continue;
            ItemStack filled = fluidHandler.getContainer();
            subItems.add(filled);
        }
    }

    @Override
    @Nonnull
    public String getItemStackDisplayName(@Nonnull ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            if (!this.getEmpty().isEmpty()) {
                return this.getEmpty().getDisplayName();
            }
            return super.getItemStackDisplayName(stack);
        }
        String unloc = this.getUnlocalizedNameInefficiently(stack);
        if (I18n.canTranslate(unloc + "." + fluidStack.getFluid().getName())) {
            return I18n.translateToLocal(unloc + "." + fluidStack.getFluid().getName());
        }
        return I18n.translateToLocalFormatted(unloc + ".name", fluidStack.getLocalizedName());
    }

    @Override
    @Nonnull
    public ActionResult<ItemStack> onItemRightClick(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        ItemStack itemstack = player.getHeldItem(hand);
        FluidStack fluidStack = this.getFluid(itemstack);
        if (fluidStack == null) {
            return ActionResult.newResult(EnumActionResult.PASS, itemstack);
        }
        RayTraceResult mop = this.rayTrace(world, player, false);
        ActionResult<ItemStack> ret = ForgeEventFactory.onBucketUse(player, world, itemstack, mop);
        if (ret != null) {
            return ret;
        }
        if (mop == null || mop.typeOfHit != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult(EnumActionResult.PASS, itemstack);
        }
        BlockPos clickPos = mop.getBlockPos();
        if (world.isBlockModifiable(player, clickPos) && player.canPlayerEdit(targetPos = clickPos.offset(mop.sideHit), mop.sideHit, itemstack) && (result = FluidUtil.tryPlaceFluid(player, world, targetPos, itemstack, fluidStack)).isSuccess() && !player.capabilities.isCreativeMode) {
            ItemStack emptyStack;
            player.addStat(StatList.getObjectUseStats(this));
            itemstack.shrink(1);
            ItemStack drained = result.getResult();
            ItemStack itemStack = emptyStack = !drained.isEmpty() ? drained.copy() : new ItemStack(this);
            if (itemstack.isEmpty()) {
                return ActionResult.newResult(EnumActionResult.SUCCESS, emptyStack);
            }
            ItemHandlerHelper.giveItemToPlayer(player, emptyStack);
            return ActionResult.newResult(EnumActionResult.SUCCESS, itemstack);
        }
        return ActionResult.newResult(EnumActionResult.FAIL, itemstack);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFillBucket(FillBucketEvent event) {
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack emptyBucket = event.getEmptyBucket();
        if (emptyBucket.isEmpty() || !emptyBucket.isItemEqual(this.getEmpty()) || this.isNbtSensitive() && ItemStack.areItemStackTagsEqual(emptyBucket, this.getEmpty())) {
            return;
        }
        RayTraceResult target = event.getTarget();
        if (target == null || target.typeOfHit != RayTraceResult.Type.BLOCK) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = target.getBlockPos();
        ItemStack singleBucket = emptyBucket.copy();
        singleBucket.setCount(1);
        FluidActionResult filledResult = FluidUtil.tryPickUpFluid(singleBucket, event.getEntityPlayer(), world, pos, target.sideHit);
        if (filledResult.isSuccess()) {
            event.setResult(Event.Result.ALLOW);
            event.setFilledBucket(filledResult.getResult());
        } else {
            event.setCanceled(true);
        }
    }

    @Deprecated
    @Nonnull
    public static ItemStack getFilledBucket(@Nonnull UniversalBucket item, Fluid fluid) {
        return FluidUtil.getFilledBucket(new FluidStack(fluid, 1000));
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        return FluidStack.loadFluidStackFromNBT(container.getTagCompound());
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Nonnull
    public ItemStack getEmpty() {
        return this.empty;
    }

    public boolean isNbtSensitive() {
        return this.nbtSensitive;
    }

    @Override
    @Nullable
    public String getCreatorModId(@Nonnull ItemStack itemStack) {
        FluidStack fluidStack = this.getFluid(itemStack);
        String modId = FluidRegistry.getModId(fluidStack);
        return modId != null ? modId : super.getCreatorModId(itemStack);
    }

    @Override
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, NBTTagCompound nbt) {
        return new FluidBucketWrapper(stack);
    }
}

