/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class DispenseFluidContainer
extends BehaviorDefaultDispenseItem {
    private static final DispenseFluidContainer INSTANCE = new DispenseFluidContainer();
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    public static DispenseFluidContainer getInstance() {
        return INSTANCE;
    }

    private DispenseFluidContainer() {
    }

    @Override
    @Nonnull
    public ItemStack dispenseStack(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        if (FluidUtil.getFluidContained(stack) != null) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    @Nonnull
    private ItemStack fillContainer(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        World world = source.getWorld();
        EnumFacing dispenserFacing = source.getBlockState().getValue(BlockDispenser.FACING);
        BlockPos blockpos = source.getBlockPos().offset(dispenserFacing);
        FluidActionResult actionResult = FluidUtil.tryPickUpFluid(stack, null, world, blockpos, dispenserFacing.getOpposite());
        ItemStack resultStack = actionResult.getResult();
        if (!actionResult.isSuccess() || resultStack.isEmpty()) {
            return super.dispenseStack(source, stack);
        }
        if (stack.getCount() == 1) {
            return resultStack;
        }
        if (((TileEntityDispenser)source.getBlockTileEntity()).addItemStack(resultStack) < 0) {
            this.dispenseBehavior.dispense(source, resultStack);
        }
        ItemStack stackCopy = stack.copy();
        stackCopy.shrink(1);
        return stackCopy;
    }

    @Nonnull
    private ItemStack dumpContainer(IBlockSource source, @Nonnull ItemStack stack) {
        FluidActionResult result;
        ItemStack singleStack = stack.copy();
        singleStack.setCount(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler(singleStack);
        if (fluidHandler == null) {
            return super.dispenseStack(source, stack);
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        EnumFacing dispenserFacing = source.getBlockState().getValue(BlockDispenser.FACING);
        BlockPos blockpos = source.getBlockPos().offset(dispenserFacing);
        FluidActionResult fluidActionResult = result = fluidStack != null ? FluidUtil.tryPlaceFluid(null, source.getWorld(), blockpos, stack, fluidStack) : FluidActionResult.FAILURE;
        if (result.isSuccess()) {
            ItemStack drainedStack = result.getResult();
            if (drainedStack.getCount() == 1) {
                return drainedStack;
            }
            if (!drainedStack.isEmpty() && ((TileEntityDispenser)source.getBlockTileEntity()).addItemStack(drainedStack) < 0) {
                this.dispenseBehavior.dispense(source, drainedStack);
            }
            ItemStack stackCopy = drainedStack.copy();
            stackCopy.shrink(1);
            return stackCopy;
        }
        return this.dispenseBehavior.dispense(source, stack);
    }
}

