/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class BlockFluidFinite
extends BlockFluidBase {
    public BlockFluidFinite(Fluid fluid, Material material, MapColor mapColor) {
        super(fluid, material, mapColor);
    }

    public BlockFluidFinite(Fluid fluid, Material material) {
        this(fluid, material, material.getMaterialMapColor());
    }

    @Override
    public int getQuantaValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock().isAir(state, world, pos)) {
            return 0;
        }
        if (state.getBlock() != this) {
            return -1;
        }
        return state.getValue(LEVEL) + 1;
    }

    @Override
    public boolean canCollideCheck(@Nonnull IBlockState state, boolean fullHit) {
        return fullHit;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return this.quantaPerBlock - 1;
    }

    @Override
    public void updateTick(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        int quantaRemaining;
        boolean changed = false;
        int prevRemaining = quantaRemaining = state.getValue(LEVEL) + 1;
        if ((quantaRemaining = this.tryToFlowVerticallyInto(world, pos, quantaRemaining)) < 1) {
            return;
        }
        if (quantaRemaining != prevRemaining) {
            changed = true;
            if (quantaRemaining == 1) {
                world.setBlockState(pos, state.withProperty(LEVEL, quantaRemaining - 1), 2);
                return;
            }
        } else if (quantaRemaining == 1) {
            return;
        }
        int lowerThan = quantaRemaining - 1;
        int total = quantaRemaining;
        int count = 1;
        for (EnumFacing side : EnumFacing.Plane.HORIZONTAL) {
            int quanta;
            BlockPos off = pos.offset(side);
            if (this.displaceIfPossible(world, off)) {
                world.setBlockToAir(off);
            }
            if ((quanta = this.getQuantaValueBelow(world, off, lowerThan)) < 0) continue;
            ++count;
            total += quanta;
        }
        if (count == 1) {
            if (changed) {
                world.setBlockState(pos, state.withProperty(LEVEL, quantaRemaining - 1), 2);
            }
            return;
        }
        int each = total / count;
        int rem = total % count;
        for (EnumFacing side : EnumFacing.Plane.HORIZONTAL) {
            BlockPos off = pos.offset(side);
            int quanta = this.getQuantaValueBelow(world, off, lowerThan);
            if (quanta < 0) continue;
            int newQuanta = each;
            if (rem == count || rem > 1 && rand.nextInt(count - rem) != 0) {
                ++newQuanta;
                --rem;
            }
            if (newQuanta != quanta) {
                if (newQuanta == 0) {
                    world.setBlockToAir(off);
                } else {
                    world.setBlockState(off, this.getDefaultState().withProperty(LEVEL, newQuanta - 1), 2);
                }
                world.scheduleUpdate(off, this, this.tickRate);
            }
            --count;
        }
        if (rem > 0) {
            ++each;
        }
        world.setBlockState(pos, state.withProperty(LEVEL, each - 1), 2);
    }

    public int tryToFlowVerticallyInto(World world, BlockPos pos, int amtToInput) {
        IBlockState myState = world.getBlockState(pos);
        BlockPos other = pos.add(0, this.densityDir, 0);
        if (other.getY() < 0 || other.getY() >= world.getHeight()) {
            world.setBlockToAir(pos);
            return 0;
        }
        int amt = this.getQuantaValueBelow(world, other, this.quantaPerBlock);
        if (amt >= 0) {
            if ((amt += amtToInput) > this.quantaPerBlock) {
                world.setBlockState(other, myState.withProperty(LEVEL, this.quantaPerBlock - 1));
                world.scheduleUpdate(other, this, this.tickRate);
                return amt - this.quantaPerBlock;
            }
            if (amt > 0) {
                world.setBlockState(other, myState.withProperty(LEVEL, amt - 1));
                world.scheduleUpdate(other, this, this.tickRate);
                world.setBlockToAir(pos);
                return 0;
            }
            return amtToInput;
        }
        int density_other = BlockFluidFinite.getDensity(world, other);
        if (density_other == Integer.MAX_VALUE) {
            if (this.displaceIfPossible(world, other)) {
                world.setBlockState(other, myState.withProperty(LEVEL, amtToInput - 1));
                world.scheduleUpdate(other, this, this.tickRate);
                world.setBlockToAir(pos);
                return 0;
            }
            return amtToInput;
        }
        if (this.densityDir < 0) {
            if (density_other < this.density) {
                IBlockState state = world.getBlockState(other);
                world.setBlockState(other, myState.withProperty(LEVEL, amtToInput - 1));
                world.setBlockState(pos, state);
                world.scheduleUpdate(other, this, this.tickRate);
                world.scheduleUpdate(pos, state.getBlock(), state.getBlock().tickRate(world));
                return 0;
            }
        } else if (density_other > this.density) {
            IBlockState state = world.getBlockState(other);
            world.setBlockState(other, myState.withProperty(LEVEL, amtToInput - 1));
            world.setBlockState(pos, state);
            world.scheduleUpdate(other, this, this.tickRate);
            world.scheduleUpdate(pos, state.getBlock(), state.getBlock().tickRate(world));
            return 0;
        }
        return amtToInput;
    }

    @Override
    public int place(World world, BlockPos pos, @Nonnull FluidStack fluidStack, boolean doPlace) {
        IBlockState existing = world.getBlockState(pos);
        float quantaAmount = 1000.0f / this.quantaPerBlockFloat;
        int closest = 1000;
        int quanta = this.quantaPerBlock;
        if (fluidStack.amount < closest) {
            closest = MathHelper.floor(quantaAmount * (float)MathHelper.floor((float)fluidStack.amount / quantaAmount));
            quanta = MathHelper.floor((float)closest / quantaAmount);
        }
        if (existing.getBlock() == this) {
            int existingQuanta = existing.getValue(LEVEL) + 1;
            int missingQuanta = this.quantaPerBlock - existingQuanta;
            closest = Math.min(closest, MathHelper.floor((float)missingQuanta * quantaAmount));
            quanta = Math.min(quanta + existingQuanta, this.quantaPerBlock);
        }
        if (quanta < 1 || quanta > 16) {
            return 0;
        }
        if (doPlace) {
            FluidUtil.destroyBlockOnFluidPlacement(world, pos);
            world.setBlockState(pos, this.getDefaultState().withProperty(LEVEL, quanta - 1), 11);
        }
        return closest;
    }

    @Override
    public FluidStack drain(World world, BlockPos pos, boolean doDrain) {
        FluidStack fluidStack = new FluidStack(this.getFluid(), MathHelper.floor(this.getQuantaPercentage(world, pos) * 1000.0f));
        if (doDrain) {
            world.setBlockToAir(pos);
        }
        return fluidStack;
    }

    @Override
    public boolean canDrain(World world, BlockPos pos) {
        return true;
    }
}

