/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WorldEvent
extends Event {
    private final World world;

    public WorldEvent(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    @Cancelable
    public static class CreateSpawnPosition
    extends WorldEvent {
        private final WorldSettings settings;

        public CreateSpawnPosition(World world, WorldSettings settings) {
            super(world);
            this.settings = settings;
        }

        public WorldSettings getSettings() {
            return this.settings;
        }
    }

    @Cancelable
    public static class PotentialSpawns
    extends WorldEvent {
        private final EnumCreatureType type;
        private final BlockPos pos;
        private final List<Biome.SpawnListEntry> list;

        public PotentialSpawns(World world, EnumCreatureType type, BlockPos pos, List<Biome.SpawnListEntry> oldList) {
            super(world);
            this.pos = pos;
            this.type = type;
            this.list = oldList != null ? new ArrayList<Biome.SpawnListEntry>(oldList) : new ArrayList<Biome.SpawnListEntry>();
        }

        public EnumCreatureType getType() {
            return this.type;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public List<Biome.SpawnListEntry> getList() {
            return this.list;
        }
    }

    public static class Save
    extends WorldEvent {
        public Save(World world) {
            super(world);
        }
    }

    public static class Unload
    extends WorldEvent {
        public Unload(World world) {
            super(world);
        }
    }

    public static class Load
    extends WorldEvent {
        public Load(World world) {
            super(world);
        }
    }
}

