/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.terraingen;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.event.world.WorldEvent;

public class InitNoiseGensEvent<T extends Context>
extends WorldEvent {
    private final Random rand;
    private final T original;
    private T newValues;

    public InitNoiseGensEvent(World world, Random rand, T original) {
        super(world);
        this.rand = rand;
        this.original = original;
        this.newValues = ((Context)original).clone();
    }

    public Random getRandom() {
        return this.rand;
    }

    public T getOriginal() {
        return this.original;
    }

    public T getNewValues() {
        return this.newValues;
    }

    public static class Context {
        private NoiseGeneratorOctaves lperlin1;
        private NoiseGeneratorOctaves lperlin2;
        private NoiseGeneratorOctaves perlin;
        private NoiseGeneratorOctaves scale;
        private NoiseGeneratorOctaves depth;

        public Context(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth) {
            this.lperlin1 = lperlin1;
            this.lperlin2 = lperlin2;
            this.perlin = perlin;
            this.scale = scale;
            this.depth = depth;
        }

        public NoiseGeneratorOctaves getLPerlin1() {
            return this.lperlin1;
        }

        public NoiseGeneratorOctaves getLPerlin2() {
            return this.lperlin2;
        }

        public NoiseGeneratorOctaves getPerlin() {
            return this.perlin;
        }

        public NoiseGeneratorOctaves getScale() {
            return this.scale;
        }

        public NoiseGeneratorOctaves getDepth() {
            return this.depth;
        }

        public void setLPerlin1(NoiseGeneratorOctaves value) {
            this.lperlin1 = value;
        }

        public void getLPerlin2(NoiseGeneratorOctaves value) {
            this.lperlin2 = value;
        }

        public void getPerlin(NoiseGeneratorOctaves value) {
            this.perlin = value;
        }

        public void getScale(NoiseGeneratorOctaves value) {
            this.scale = value;
        }

        public void getDepth(NoiseGeneratorOctaves value) {
            this.depth = value;
        }

        public Context clone() {
            return new Context(this.lperlin1, this.lperlin2, this.perlin, this.scale, this.depth);
        }
    }

    public static class ContextHell
    extends Context {
        private NoiseGeneratorOctaves perlin2;
        private NoiseGeneratorOctaves perlin3;

        public ContextHell(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorOctaves perlin2, NoiseGeneratorOctaves perlin3, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.perlin2 = perlin2;
            this.perlin3 = perlin3;
        }

        @Override
        public ContextHell clone() {
            return new ContextHell(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.perlin2, this.perlin3, this.getScale(), this.getDepth());
        }

        public NoiseGeneratorOctaves getPerlin2() {
            return this.perlin2;
        }

        public NoiseGeneratorOctaves getPerlin3() {
            return this.perlin3;
        }

        public void getPerlin2(NoiseGeneratorOctaves value) {
            this.perlin2 = value;
        }

        public void getPerlin3(NoiseGeneratorOctaves value) {
            this.perlin3 = value;
        }
    }

    public static class ContextEnd
    extends Context {
        private NoiseGeneratorSimplex island;

        public ContextEnd(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth, NoiseGeneratorSimplex island) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.island = island;
        }

        @Override
        public ContextEnd clone() {
            return new ContextEnd(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.getScale(), this.getDepth(), this.island);
        }

        public NoiseGeneratorSimplex getIsland() {
            return this.island;
        }

        public void getIsland(NoiseGeneratorSimplex value) {
            this.island = value;
        }
    }

    public static class ContextOverworld
    extends Context {
        private NoiseGeneratorPerlin height;
        private NoiseGeneratorOctaves forest;

        public ContextOverworld(NoiseGeneratorOctaves lperlin1, NoiseGeneratorOctaves lperlin2, NoiseGeneratorOctaves perlin, NoiseGeneratorPerlin height, NoiseGeneratorOctaves scale, NoiseGeneratorOctaves depth, NoiseGeneratorOctaves forest) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.height = height;
            this.forest = forest;
        }

        @Override
        public ContextOverworld clone() {
            return new ContextOverworld(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.height, this.getScale(), this.getDepth(), this.forest);
        }

        public NoiseGeneratorPerlin getHeight() {
            return this.height;
        }

        public NoiseGeneratorOctaves getForest() {
            return this.forest;
        }

        public void getHeight(NoiseGeneratorPerlin value) {
            this.height = value;
        }

        public void getForest(NoiseGeneratorOctaves value) {
            this.forest = value;
        }
    }
}

