/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PotionEvent
extends LivingEvent {
    @Nullable
    protected final PotionEffect effect;

    public PotionEvent(EntityLivingBase living, PotionEffect effect) {
        super(living);
        this.effect = effect;
    }

    @Nullable
    public PotionEffect getPotionEffect() {
        return this.effect;
    }

    public static class PotionExpiryEvent
    extends PotionEvent {
        public PotionExpiryEvent(EntityLivingBase living, PotionEffect effect) {
            super(living, effect);
        }
    }

    public static class PotionAddedEvent
    extends PotionEvent {
        private final PotionEffect oldEffect;

        public PotionAddedEvent(EntityLivingBase living, PotionEffect oldEffect, PotionEffect newEffect) {
            super(living, newEffect);
            this.oldEffect = oldEffect;
        }

        @Override
        @Nonnull
        public PotionEffect getPotionEffect() {
            return super.getPotionEffect();
        }

        @Nullable
        public PotionEffect getOldPotionEffect() {
            return this.oldEffect;
        }
    }

    @Event.HasResult
    public static class PotionApplicableEvent
    extends PotionEvent {
        public PotionApplicableEvent(EntityLivingBase living, PotionEffect effect) {
            super(living, effect);
        }

        @Override
        @Nonnull
        public PotionEffect getPotionEffect() {
            return super.getPotionEffect();
        }
    }

    @Cancelable
    public static class PotionRemoveEvent
    extends PotionEvent {
        private final Potion potion;

        public PotionRemoveEvent(EntityLivingBase living, Potion potion) {
            super(living, living.getActivePotionEffect(potion));
            this.potion = potion;
        }

        public PotionRemoveEvent(EntityLivingBase living, PotionEffect effect) {
            super(living, effect);
            this.potion = effect.getPotion();
        }

        public Potion getPotion() {
            return this.potion;
        }

        @Override
        @Nullable
        public PotionEffect getPotionEffect() {
            return super.getPotionEffect();
        }
    }
}

