/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class BabyEntitySpawnEvent
extends Event {
    private final EntityLiving parentA;
    private final EntityLiving parentB;
    private final EntityPlayer causedByPlayer;
    private EntityAgeable child;

    public BabyEntitySpawnEvent(EntityLiving parentA, EntityLiving parentB, @Nullable EntityAgeable proposedChild) {
        EntityPlayerMP causedByPlayer = null;
        if (parentA instanceof EntityAnimal) {
            causedByPlayer = ((EntityAnimal)parentA).getLoveCause();
        }
        if (causedByPlayer == null && parentB instanceof EntityAnimal) {
            causedByPlayer = ((EntityAnimal)parentB).getLoveCause();
        }
        this.parentA = parentA;
        this.parentB = parentB;
        this.causedByPlayer = causedByPlayer;
        this.child = proposedChild;
    }

    public EntityLiving getParentA() {
        return this.parentA;
    }

    public EntityLiving getParentB() {
        return this.parentB;
    }

    @Nullable
    public EntityPlayer getCausedByPlayer() {
        return this.causedByPlayer;
    }

    @Nullable
    public EntityAgeable getChild() {
        return this.child;
    }

    public void setChild(EntityAgeable proposedChild) {
        this.child = proposedChild;
    }
}

